/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderObjectBuffers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.GpuBufferCache;
import fi.dy.masa.litematica.render.schematic.IBufferBuilderPatch;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.IgnoreBlockRegistry;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.apache.logging.log4j.Logger;

public class ChunkRendererSchematicVbo
implements AutoCloseable {
    private static final Logger LOGGER = Litematica.LOGGER;
    protected static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final ReentrantLock chunkRenderLock;
    protected final ReentrantLock chunkRenderDataLock;
    protected final Set<class_2586> setBlockEntities = new HashSet<class_2586>();
    protected class_3695 profiler;
    protected final class_2338.class_2339 position;
    protected final class_2338.class_2339 chunkRelativePos;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private class_238 boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    private boolean ignoreClientWorldFluids;
    private IgnoreBlockRegistry ignoreBlockRegistry;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    private final BufferBuilderCache builderCache;
    private final GpuBufferCache gpuBufferCache;
    protected ChunkRenderTaskSchematic compileTask;
    protected ChunkRenderDataSchematic chunkRenderData;
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    protected ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.chunkRenderLock = new ReentrantLock();
        this.chunkRenderDataLock = new ReentrantLock();
        this.position = new class_2338.class_2339();
        this.chunkRelativePos = new class_2338.class_2339();
        this.builderCache = new BufferBuilderCache();
        this.gpuBufferCache = new GpuBufferCache();
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    protected class_3695 getProfiler() {
        if (this.profiler == null) {
            this.profiler = this.worldRenderer.getProfiler();
        }
        return this.profiler;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBlockBuffersByBlockLayer(class_11515 layer) {
        if (this.gpuBufferCache.hasBuffersByBlockLayer(layer)) {
            return this.gpuBufferCache.getBuffersByBlockLayer(layer);
        }
        return null;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBlockBuffersByLayer(class_1921 layer) {
        if (this.gpuBufferCache.hasBuffersByLayer(layer)) {
            return this.gpuBufferCache.getBuffersByLayer(layer);
        }
        return null;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getOverlayBuffersByType(OverlayRenderType type) {
        if (this.gpuBufferCache.hasBuffersByType(type)) {
            return this.gpuBufferCache.getBuffersByType(type);
        }
        return null;
    }

    protected ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    protected BufferBuilderCache getBuilderCache() {
        return this.builderCache;
    }

    protected GpuBufferCache getGpuBufferCache() {
        return this.gpuBufferCache;
    }

    protected void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.chunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public class_2338 getOrigin() {
        return this.position;
    }

    public class_238 getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.method_10263();
            int y = this.position.method_10264();
            int z = this.position.method_10260();
            this.boundingBox = new class_238((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + this.world.method_31605()), (double)(z + 16));
        }
        return this.boundingBox;
    }

    protected void setPosition(int x, int y, int z) {
        if (x != this.position.method_10263() || y != this.position.method_10264() || z != this.position.method_10260()) {
            this.clear();
            this.boundingBox = null;
            this.position.method_10103(x, y, z);
        }
    }

    protected double getDistanceSq() {
        class_1297 entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return 0.0;
        }
        double x = (double)this.position.method_10263() + 8.0 - entity.method_23317();
        double z = (double)this.position.method_10260() + 8.0 - entity.method_23321();
        return x * x + z * z;
    }

    protected void deleteGlResources() {
        this.clear();
        this.closeAllVertexBuffers();
    }

    private void closeAllVertexBuffers() {
        this.gpuBufferCache.clearAll();
    }

    protected void resortTransparency(ChunkRenderTaskSchematic task, class_3695 profiler) {
        this.profiler = profiler;
        this.getProfiler().method_15396("resort_task");
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        class_243 cameraPos = task.getCameraPosSupplier().get();
        class_11515 layerTranslucent = class_11515.field_60926;
        BufferAllocatorCache allocators = task.getAllocatorCache();
        float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
        float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
        float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
        if (!data.isBlockLayerEmpty(layerTranslucent) && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
            this.getProfiler().method_15405("resort_blocks");
            if (data.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layerTranslucent)) {
                try {
                    this.resortRenderBlocks(layerTranslucent, x, y, z, data, allocators);
                }
                catch (Exception e) {
                    LOGGER.error("resortTransparency() [VBO] caught exception for layer [{}] // {}", (Object)layerTranslucent.method_72022(), (Object)e.toString());
                }
            }
        }
        this.getProfiler().method_15407();
        this.profiler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildChunk(ChunkRenderTaskSchematic task, class_3695 profiler) {
        this.profiler = profiler;
        this.getProfiler().method_15396("rebuild_chunk");
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            task.setChunkRenderData(data);
        }
        finally {
            task.getLock().unlock();
        }
        this.builderCache.clearAll();
        this.gpuBufferCache.clearAll();
        class_2338.class_2339 posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        BufferAllocatorCache allocators = task.getAllocatorCache();
        if (!allocators.isClear()) {
            allocators.resetAll();
        }
        this.existingOverlays.clear();
        this.hasOverlay = false;
        this.getProfiler().method_15405("rebuild_chunk_start");
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            int minX = posChunk.method_10263();
            int minY = posChunk.method_10264();
            int minZ = posChunk.method_10260();
            int maxX = minX + 15;
            int maxY = minY + this.world.method_31605();
            int maxZ = minZ + 15;
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ))) {
                ++schematicRenderChunksUpdated;
                class_243 cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
                float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
                float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
                HashSet<class_11515> usedBlockLayers = new HashSet<class_11515>();
                HashSet<class_1921> usedRenderLayers = new HashSet<class_1921>();
                class_4587 matrixStack = new class_4587();
                int bottomY = this.position.method_10264();
                this.getProfiler().method_15405("rebuild_chunk_boxes");
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    class_2338 posFrom = new class_2338(box.minX, box.minY, box.minZ);
                    class_2338 posTo = new class_2338(box.maxX, box.maxY, box.maxZ);
                    for (class_2338 posMutable : class_2338.class_2339.method_10097((class_2338)posFrom, (class_2338)posTo)) {
                        matrixStack.method_22903();
                        matrixStack.method_46416((float)(posMutable.method_10263() & 0xF), (float)(posMutable.method_10264() - bottomY), (float)(posMutable.method_10260() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, allocators, usedBlockLayers, usedRenderLayers, matrixStack);
                        matrixStack.method_22909();
                    }
                }
                this.getProfiler().method_15405("rebuild_chunk_layers");
                for (class_11515 layerTmp : ChunkRenderLayers.BLOCK_RENDER_LAYERS) {
                    if (usedBlockLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    try {
                        data.setBlockLayerUsed(layerTmp);
                        this.postRenderBlocks(layerTmp, x, y, z, data, allocators);
                    }
                    catch (Exception e) {
                        LOGGER.error("rebuildChunk() [VBO] failed to postRenderBlocks() for layer [{}] --> {}", (Object)layerTmp.method_72022(), (Object)e.toString());
                    }
                }
                if (this.hasOverlay) {
                    this.getProfiler().method_15405("rebuild_chunk_overlays");
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        try {
                            data.setOverlayTypeUsed(type);
                            this.postRenderOverlay(type, x, y, z, data, allocators);
                        }
                        catch (Exception e) {
                            LOGGER.error("rebuildChunk() [VBO] failed to postRenderOverlay() for overlay type [{}] --> {}", (Object)type.getDrawMode().name(), (Object)e.toString());
                        }
                    }
                }
            }
        }
        this.getProfiler().method_15405("rebuild_chunk_lock");
        this.chunkRenderLock.lock();
        try {
            HashSet set2;
            List<class_2586> noCull = data.getNoCullBlockEntities();
            HashSet set = Sets.newHashSet(noCull);
            Set<class_2586> set3 = this.setBlockEntities;
            synchronized (set3) {
                set2 = Sets.newHashSet(this.setBlockEntities);
                set.removeAll(this.setBlockEntities);
                noCull.forEach(set2::remove);
                this.setBlockEntities.clear();
                this.setBlockEntities.addAll(noCull);
            }
            this.worldRenderer.updateBlockEntities(set2, set);
            this.builderCache.clearAll();
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        this.getProfiler().method_15407();
        this.profiler = null;
        data.setTimeBuilt(this.world.method_8510());
    }

    protected void renderBlocksAndOverlay(class_2338 pos, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators, Set<class_11515> usedBlockLayers, Set<class_1921> usedRenderLayers, class_4587 matrixStack) {
        class_2680 stateSchematic = this.schematicWorldView.method_8320(pos);
        class_2680 stateClient = this.clientWorldView.method_8320(pos);
        boolean clientHasAir = stateClient.method_26215();
        boolean schematicHasAir = stateSchematic.method_26215();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.getProfiler().method_15396("render_build");
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            class_11515 layer;
            if (stateSchematic.method_31709()) {
                this.addBlockEntity(pos, data);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            class_3610 fluidState = stateSchematic.method_26227();
            if (!fluidState.method_15769() && Configs.Visuals.ENABLE_SCHEMATIC_FLUIDS.getBooleanValue()) {
                this.getProfiler().method_15405("render_build_fluids");
                layer = class_4696.method_23680((class_3610)fluidState);
                int offsetY = (pos.method_10264() >> 4 << 4) - this.position.method_10264();
                class_287 bufferSchematic = this.builderCache.getBufferByBlockLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                ((IBufferBuilderPatch)bufferSchematic).litematica$setOffsetY(offsetY);
                this.worldRenderer.renderFluid(this.schematicWorldView, stateSchematic, fluidState, pos, bufferSchematic);
                usedBlockLayers.add(layer);
                ((IBufferBuilderPatch)bufferSchematic).litematica$setOffsetY(0.0f);
            }
            if (stateSchematic.method_26217() != class_2464.field_11455) {
                this.getProfiler().method_15405("render_build_blocks");
                layer = translucent ? class_11515.field_60926 : class_4696.method_23679((class_2680)stateSchematic);
                class_287 bufferSchematic = this.builderCache.getBufferByBlockLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrixStack, bufferSchematic)) {
                    usedBlockLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            this.getProfiler().method_15405("render_build_overlays");
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = ChunkRendererSchematicVbo.getOverlayColor(type);
            if (this.overlayColor != null) {
                if (!stateSchematic.method_26227().method_15769() && !Configs.Visuals.ENABLE_SCHEMATIC_FLUIDS.getBooleanValue()) {
                    this.getProfiler().method_15407();
                    return;
                }
                this.renderOverlay(type, pos, stateSchematic, missing, data, allocators);
            }
        }
        this.getProfiler().method_15407();
    }

    protected void renderOverlay(OverlayType type, class_2338 pos, class_2680 stateSchematic, boolean missing, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators) {
        List<class_10889> modelParts;
        OverlayRenderType overlayType;
        this.getProfiler().method_15396("render_overlay");
        boolean useDefault = false;
        class_2338.class_2339 relPos = this.getChunkRelativePosition(pos);
        class_5819 rand = class_5819.method_43047();
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            this.getProfiler().method_15396("overlay_sides");
            overlayType = OverlayRenderType.QUAD;
            class_287 bufferOverlayQuads = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayQuads == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayQuads = this.preRenderOverlay(overlayType, allocators);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                this.getProfiler().method_15405("cull_inner_sides");
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                modelParts = this.worldRenderer.getModelParts((class_2338)relPos, stateSchematic, rand);
                if (!RenderUtils.hasQuads(modelParts)) {
                    useDefault = true;
                } else {
                    class_265 shape = stateSchematic.method_26220((class_1922)this.schematicWorldView, pos);
                    for (int i = 0; i < 6; ++i) {
                        class_2350 side = PositionUtils.ALL_DIRECTIONS[i];
                        posMutable.method_10103(pos.method_10263() + side.method_10148(), pos.method_10264() + side.method_10164(), pos.method_10260() + side.method_10165());
                        class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                        class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                        OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                        boolean fullSquareSide = class_2248.method_9501((class_265)shape, (class_2350)side);
                        if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                            this.getProfiler().method_15405("cull_render_model_sides");
                            if (type.getRenderPriority() <= typeAdj.getRenderPriority() && fullSquareSide) continue;
                            this.getProfiler().method_15405("cull_render_model");
                            for (class_10889 part : modelParts) {
                                RenderUtils.drawBlockModelQuadOverlayBatched(part, stateSchematic, (class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                            }
                            continue;
                        }
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                        this.getProfiler().method_15405("cull_render_default");
                        RenderUtils.drawBlockBoxSideBatchedQuads((class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                    }
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                this.getProfiler().method_15405("render_model_sides");
                List<class_10889> modelParts2 = this.worldRenderer.getModelParts((class_2338)relPos, stateSchematic, rand);
                if (!RenderUtils.hasQuads(modelParts2)) {
                    useDefault = true;
                } else {
                    RenderUtils.drawBlockModelQuadOverlayBatched(modelParts2, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else {
                this.getProfiler().method_15405("render_batched");
                RenderUtils.drawBlockBoxBatchedQuads((class_2338)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            }
            if (useDefault) {
                try {
                    this.getProfiler().method_15405("render_batched_default");
                    RenderUtils.drawBlockBoxBatchedQuads((class_2338)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
                }
                catch (Exception modelParts2) {
                    // empty catch block
                }
            }
            this.getProfiler().method_15407();
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            this.getProfiler().method_15396("overlay_outlines");
            useDefault = false;
            overlayType = OverlayRenderType.OUTLINE;
            class_287 bufferOverlayOutlines = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayOutlines == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayOutlines = this.preRenderOverlay(overlayType, allocators);
            }
            Color4f overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            this.getProfiler().method_15405("cull_inner_sides");
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.method_10103(pos.method_10263() + x - 1, pos.method_10264() + y - 1, pos.method_10260() + z - 1);
                                class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                                class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    if (stateSchematic.method_26225()) {
                        useDefault = true;
                    } else {
                        this.getProfiler().method_15405("render_model_batched");
                        List<class_10889> modelParts3 = this.worldRenderer.getModelParts((class_2338)relPos, stateSchematic, rand);
                        if (!RenderUtils.hasQuads(modelParts3)) {
                            useDefault = true;
                        } else {
                            RenderUtils.drawDebugBlockModelOutlinesBatched(modelParts3, stateSchematic, (class_2338)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                        }
                    }
                } else {
                    this.getProfiler().method_15405("render_reduced_edges");
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else {
                this.getProfiler().method_15405("render_fallback");
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    this.getProfiler().method_15405("render_model_batched");
                    modelParts = this.worldRenderer.getModelParts((class_2338)relPos, stateSchematic, rand);
                    if (!RenderUtils.hasQuads(modelParts)) {
                        useDefault = true;
                    } else {
                        RenderUtils.drawDebugBlockModelOutlinesBatched(modelParts, stateSchematic, (class_2338)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    useDefault = true;
                }
            }
            if (useDefault) {
                try {
                    this.getProfiler().method_15405("render_batched_box");
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedDebugLines((class_2338)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getProfiler().method_15407();
        }
        this.getProfiler().method_15407();
    }

    protected class_2338.class_2339 getChunkRelativePosition(class_2338 pos) {
        return this.chunkRelativePos.method_10103(pos.method_10263() & 0xF, pos.method_10264() - this.position.method_10264(), pos.method_10260() & 0xF);
    }

    protected void renderOverlayReducedEdges(class_2338 pos, OverlayType[][][] adjTypes, OverlayType typeSelf, class_287 bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        class_2382[] neighborPositions = new class_2382[4];
        int lines = 0;
        this.getProfiler().method_15396("overlay_reduced_edges");
        for (class_2350.class_2351 axis : fi.dy.masa.litematica.util.PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                class_2382[] offsets = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                if (offsets == null) continue;
                for (int i = 0; i < 4; ++i) {
                    class_2382 offset = offsets[i];
                    OverlayType type = adjTypes[offset.method_10263() + 1][offset.method_10264() + 1][offset.method_10260() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new class_2382(pos.method_10263() + offset.method_10263(), pos.method_10264() + offset.method_10264(), pos.method_10260() + offset.method_10260());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                this.getProfiler().method_15405("edges_plop");
                if (index <= 0 || !hasCurrent) continue;
                class_2382 posTmp = new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    class_2382 tmp = neighborPositions[i];
                    if (tmp.method_10263() > posTmp.method_10263() || tmp.method_10264() > posTmp.method_10264() || tmp.method_10260() > posTmp.method_10260()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.method_10263() != pos.method_10263() || posTmp.method_10264() != pos.method_10264() || posTmp.method_10260() != pos.method_10260()) continue;
                try {
                    this.getProfiler().method_15405("render_batched");
                    RenderUtils.drawBlockBoxEdgeBatchedDebugLines((class_2338)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                }
                catch (IllegalStateException ignored) {
                    this.getProfiler().method_15407();
                    return;
                }
                ++lines;
            }
        }
        this.getProfiler().method_15407();
    }

    protected OverlayType getOverlayType(class_2680 stateSchematic, class_2680 stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.method_26215();
        boolean schematicHasAir = stateSchematic.method_26215();
        if (schematicHasAir) {
            if (clientHasAir) {
                return OverlayType.NONE;
            }
            if (this.ignoreClientWorldFluids && stateClient.method_51176()) {
                return OverlayType.NONE;
            }
            if (this.ignoreBlockRegistry.hasBlock(stateClient.method_26204())) {
                return OverlayType.NONE;
            }
            return OverlayType.EXTRA;
        }
        if (clientHasAir || this.ignoreClientWorldFluids && stateClient.method_51176()) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.method_26204() != stateClient.method_26204()) {
            if (Configs.Generic.ENABLE_DIFFERENT_BLOCKS.getBooleanValue() && BlockUtils.isInSameGroup((class_2680)stateSchematic, (class_2680)stateClient)) {
                if (BlockUtils.matchPropertiesOnly((class_2680)stateSchematic, (class_2680)stateClient)) {
                    return OverlayType.DIFF_BLOCK;
                }
                return OverlayType.WRONG_STATE;
            }
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected static Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
            case DIFF_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_DIFF_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_DIFF_BLOCK.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private <T extends class_2586> void addBlockEntity(class_2338 pos, ChunkRenderDataSchematic chunkRenderData) {
        class_827 tesr;
        class_2586 te = this.schematicWorldView.getBlockEntity(pos, class_2818.class_2819.field_12859);
        if (te != null && (tesr = this.worldRenderer.getBlockEntityRenderer().method_3550(te)) != null) {
            chunkRenderData.addBlockEntity(te);
            if (tesr.method_3563()) {
                chunkRenderData.addNoCullBlockEntity(te);
            }
        }
    }

    private class_287 preRenderBlocks(class_11515 layer, @Nonnull BufferAllocatorCache allocators) {
        return this.builderCache.getBufferByBlockLayer(layer, allocators);
    }

    private class_287 preRenderOverlay(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        return this.builderCache.getBufferByOverlay(type, allocators);
    }

    protected void uploadBuffersByLayer(class_11515 layer, @Nonnull class_9801 meshData) {
        ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByBlockLayer(layer);
        boolean useResorting = Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue();
        if (gpuBuffers != null) {
            if (gpuBuffers.vertexBuffer != null) {
                gpuBuffers.vertexBuffer.close();
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.indexBuffer = null;
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (gpuBuffers.vertexBuffer.size() < meshData.method_60818().remaining()) {
                gpuBuffers.vertexBuffer.close();
                gpuBuffers.setVertexBuffer(RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 40, meshData.method_60818()));
            } else if (!gpuBuffers.vertexBuffer.isClosed()) {
                encoder.writeToBuffer(gpuBuffers.vertexBuffer.slice(), meshData.method_60818());
            }
            if (meshData.method_60821() != null && useResorting) {
                if (gpuBuffers.indexBuffer != null && gpuBuffers.indexBuffer.size() >= meshData.method_60821().remaining()) {
                    if (!gpuBuffers.indexBuffer.isClosed()) {
                        encoder.writeToBuffer(gpuBuffers.indexBuffer.slice(), meshData.method_60821());
                    }
                } else {
                    if (gpuBuffers.indexBuffer != null) {
                        gpuBuffers.indexBuffer.close();
                    }
                    gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "SortedBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 72, meshData.method_60821()));
                }
            } else if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.setIndexBuffer(null);
            }
            gpuBuffers.setIndexCount(meshData.method_60822().comp_751());
            gpuBuffers.setIndexType(meshData.method_60822().comp_753());
        } else {
            Supplier<String> name = () -> layer.method_72022();
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: " + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 40, meshData.method_60818());
            GpuBuffer indexBuffer = meshData.method_60821() != null && useResorting ? RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: " + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 72, meshData.method_60821()) : null;
            this.gpuBufferCache.storeBuffersByBlockLayer(layer, new ChunkRenderObjectBuffers(name, vertexBuffer, indexBuffer, meshData.method_60822().comp_751(), meshData.method_60822().comp_753()));
        }
    }

    protected void uploadBuffersByType(OverlayRenderType type, @Nonnull class_9801 meshData) {
        ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByType(type);
        if (gpuBuffers != null) {
            if (gpuBuffers.vertexBuffer != null) {
                gpuBuffers.vertexBuffer.close();
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.indexBuffer = null;
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (gpuBuffers.vertexBuffer.size() < meshData.method_60818().remaining()) {
                gpuBuffers.vertexBuffer.close();
                gpuBuffers.setVertexBuffer(RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: Overlay/" + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 40, meshData.method_60818()));
            } else if (!gpuBuffers.vertexBuffer.isClosed()) {
                encoder.writeToBuffer(gpuBuffers.vertexBuffer.slice(), meshData.method_60818());
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.setIndexBuffer(null);
            }
            gpuBuffers.setIndexCount(meshData.method_60822().comp_751());
            gpuBuffers.setIndexType(meshData.method_60822().comp_753());
        } else {
            Supplier<String> name = type::name;
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: Overlay/" + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 40, meshData.method_60818());
            GpuBuffer indexBuffer = null;
            this.gpuBufferCache.storeBuffersByType(type, new ChunkRenderObjectBuffers(name, vertexBuffer, indexBuffer, meshData.method_60822().comp_751(), meshData.method_60822().comp_753()));
        }
    }

    protected void uploadIndexByBlockLayer(class_11515 layer, @Nonnull class_9799.class_9800 buffer) {
        if (this.gpuBufferCache.hasBuffersByBlockLayer(layer)) {
            ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByBlockLayer(layer);
            assert (gpuBuffers != null);
            if (gpuBuffers.indexBuffer == null) {
                gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 72, buffer.method_60817()));
            } else if (!gpuBuffers.indexBuffer.isClosed()) {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(gpuBuffers.indexBuffer.slice(), buffer.method_60817());
            }
        }
    }

    protected void uploadIndexByType(OverlayRenderType type, @Nonnull class_9799.class_9800 buffer) {
        if (this.gpuBufferCache.hasBuffersByType(type)) {
            ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByType(type);
            assert (gpuBuffers != null);
            if (gpuBuffers.indexBuffer == null) {
                gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: Overlay/" + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.method_23854() + "]", 72, buffer.method_60817()));
            } else if (!gpuBuffers.indexBuffer.isClosed()) {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(gpuBuffers.indexBuffer.slice(), buffer.method_60817());
            }
        }
    }

    private void postRenderBlocks(class_11515 layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            class_9801 meshData;
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) {
                Objects.requireNonNull(chunkRenderData.getBuiltBufferCache().getBuiltBufferByBlockLayer(layer)).close();
            }
            if (this.builderCache.hasBufferByBlockLayer(layer)) {
                class_287 builder = this.builderCache.getBufferByBlockLayer(layer, allocators);
                meshData = builder.method_60794();
                if (meshData == null) {
                    chunkRenderData.setBlockLayerUnused(layer);
                    return;
                }
            } else {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            chunkRenderData.getBuiltBufferCache().storeBuiltBufferByBlockLayer(layer, meshData);
            if (layer == class_11515.field_60926 && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
                try {
                    this.resortRenderBlocks(layer, x, y, z, chunkRenderData, allocators);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                Objects.requireNonNull(chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type)).close();
            }
            if (this.builderCache.hasBufferByOverlay(type)) {
                class_287 builder = this.builderCache.getBufferByOverlay(type, allocators);
                class_9801 meshData = builder.method_60794();
                if (meshData == null) {
                    chunkRenderData.setOverlayTypeUnused(type);
                    return;
                }
                chunkRenderData.getBuiltBufferCache().storeBuiltBufferByType(type, meshData);
            } else {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
        }
    }

    protected class_8251 createVertexSorter(float x, float y, float z) {
        return class_8251.method_49906((float)x, (float)y, (float)z);
    }

    protected class_8251 createVertexSorter(class_243 pos) {
        return class_8251.method_49906((float)((float)pos.method_10216()), (float)((float)pos.method_10214()), (float)((float)pos.method_10215()));
    }

    protected class_8251 createVertexSorter(class_243 pos, class_2338 origin) {
        return class_8251.method_49906((float)((float)(pos.field_1352 - (double)origin.method_10263())), (float)((float)(pos.field_1351 - (double)origin.method_10264())), (float)((float)(pos.field_1350 - (double)origin.method_10260())));
    }

    protected class_8251 createVertexSorter(class_4184 camera) {
        class_243 vec3d = camera.method_19326();
        return this.createVertexSorter(vec3d, this.getOrigin());
    }

    private void resortRenderBlocks(class_11515 layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws InterruptedException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            class_9799 allocator = allocators.getBufferByBlockLayer(layer);
            if (allocator == null) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            class_9801 built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByBlockLayer(layer);
            if (built == null) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            if (layer == class_11515.field_60926 && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
                class_9801.class_9802 sortingData;
                class_8251 sorter = class_8251.method_49906((float)x, (float)y, (float)z);
                if (!chunkRenderData.hasTransparentSortingDataForBlockLayer(layer)) {
                    sortingData = built.method_60819(allocator, sorter);
                    if (sortingData == null) {
                        throw new InterruptedException("Sort State failure");
                    }
                    chunkRenderData.setTransparentSortingDataForBlockLayer(layer, sortingData);
                } else {
                    sortingData = chunkRenderData.getTransparentSortingDataForBlockLayer(layer);
                }
                if (sortingData == null) {
                    throw new InterruptedException("Sorting Data failure");
                }
            }
        }
    }

    private void resortRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) {
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            class_9799 allocator = allocators.getBufferByOverlay(type);
            if (allocator == null) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
            class_9801 built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type);
            if (built == null) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
        }
    }

    protected ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<class_243> cameraPosSupplier) {
        ChunkRenderTaskSchematic generator;
        this.chunkRenderLock.lock();
        try {
            this.finishCompileTask();
            this.rebuildWorldView();
            generator = this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return generator;
    }

    @Nullable
    protected ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<class_243> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
                this.compileTask.setChunkRenderData(this.chunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return null;
    }

    protected void finishCompileTask() {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
    }

    protected ReentrantLock getLockCompileTask() {
        return this.chunkRenderLock;
    }

    protected void clear() {
        try {
            this.finishCompileTask();
        }
        finally {
            if (this.chunkRenderData != null && !this.chunkRenderData.equals(ChunkRenderDataSchematic.EMPTY)) {
                this.chunkRenderData.clearAll();
            }
            this.builderCache.clearAll();
            this.gpuBufferCache.clearAll();
            this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
            this.existingOverlays.clear();
            this.hasOverlay = false;
        }
    }

    protected void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    protected void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreClientWorldFluids = Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue();
            this.ignoreBlockRegistry = new IgnoreBlockRegistry();
            class_638 worldClient = class_310.method_1551().field_1687;
            assert (worldClient != null);
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (class_2338)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic((class_1937)worldClient, worldClient, (class_2338)this.position, 2);
            this.boxes.clear();
            int chunkX = this.position.method_10263() / 16;
            int chunkZ = this.position.method_10260() / 16;
            for (SchematicPlacementManager.PlacementPart part : DataManager.getSchematicPlacementManager().getPlacementPartsInChunk(chunkX, chunkZ)) {
                this.boxes.add(part.bb);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.deleteGlResources();
    }
}

