/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.Iterables;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_238;
import net.minecraft.class_5568;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_7927;
import org.jetbrains.annotations.Nullable;

public class SchematicEntityLookup<T extends class_5568>
implements class_5577<T>,
AutoCloseable {
    private final ConcurrentHashMap<Integer, T> entityMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Integer> uuidMap = new ConcurrentHashMap();

    protected SchematicEntityLookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(T entity) {
        T tmp = this.method_31808(entity.method_5667());
        if (tmp != null) {
            this.remove(entity.method_5667());
        }
        ConcurrentHashMap<Comparable<UUID>, Integer> concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.put(entity.method_5667(), entity.method_5628());
        }
        concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.put(entity.method_5628(), entity);
        }
    }

    protected int size() {
        return this.entityMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(UUID uuid) {
        Integer key = this.uuidMap.get(uuid);
        if (key != null) {
            ConcurrentHashMap<Comparable<Integer>, Object> concurrentHashMap = this.entityMap;
            synchronized (concurrentHashMap) {
                this.entityMap.remove(key);
            }
            concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
        }
        ConcurrentHashMap<Integer, T> concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            for (Integer id : this.entityMap.keySet()) {
                class_5568 e = (class_5568)this.entityMap.get(id);
                if (!e.method_5667().equals(uuid)) continue;
                this.entityMap.remove(id);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T method_31804(int id) {
        if (this.entityMap.containsKey(id)) {
            class_5568 e = (class_5568)this.entityMap.get(id);
            if (!this.uuidMap.containsKey(e.method_5667())) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(e.method_5667(), id);
                }
            }
            return (T)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T method_31808(UUID uuid) {
        if (this.uuidMap.containsKey(uuid)) {
            int key = this.uuidMap.get(uuid);
            if (this.entityMap.containsKey(key)) {
                return (T)((class_5568)this.entityMap.get(key));
            }
            ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
            return null;
        }
        for (Integer id : this.entityMap.keySet()) {
            class_5568 e = (class_5568)this.entityMap.get(id);
            if (!e.method_5667().equals(uuid)) continue;
            if (!this.uuidMap.containsKey(uuid)) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(uuid, id);
                }
            }
            return (T)e;
        }
        return null;
    }

    public Iterable<T> method_31803() {
        return Iterables.unmodifiableIterable(this.entityMap.values());
    }

    public void method_31807(class_238 box, Consumer<T> action) {
        this.entityMap.forEach((id, e) -> {
            class_7927 consumer;
            if (box.method_994(e.method_5829()) && (consumer = class_7927.forConsumer((Consumer)action)).accept(e).method_47543()) {
                return;
            }
        });
    }

    public <U extends T> void method_31805(class_5575<T, U> filter, class_238 box, class_7927<U> consumer) {
        this.entityMap.forEach((id, e) -> {
            class_5568 filtered = (class_5568)filter.method_31796(e);
            if (filtered != null && box.method_994(filtered.method_5829()) && consumer.accept((Object)filtered).method_47543()) {
                return;
            }
        });
    }

    public <U extends T> void method_31806(class_5575<T, U> filter, class_7927<U> consumer) {
        this.entityMap.forEach((id, e) -> {
            class_5568 filtered = (class_5568)filter.method_31796(e);
            if (filtered != null && consumer.accept((Object)filtered).method_47543()) {
                return;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ConcurrentHashMap<Comparable<Integer>, Object> concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.clear();
        }
        concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.clear();
        }
    }
}

