/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.compat.aether;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import net.minecraft.class_1657;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AetherGlovesCompat {
    private static final boolean AETHER_LOADED;
    private static final Logger LOGGER;
    private static boolean once;

    public static boolean isWearingGloves(class_1657 player2) {
        if (!AETHER_LOADED || player2 == null) {
            return false;
        }
        return AetherGlovesCompat.isWearingGlovesImpl(player2);
    }

    private static boolean isWearingGlovesImpl(@NotNull class_1657 player2) {
        try {
            AccessoriesCapability capability = ((AccessoriesAPIAccess)player2).accessoriesCapability();
            if (capability == null) {
                return false;
            }
            for (SlotEntryReference slotEntryReference : capability.getAllEquipped()) {
                if (!slotEntryReference.reference().slotName().equals("aether:gloves_slot") || !slotEntryReference.reference().slotContainer().shouldRender(0)) continue;
                return true;
            }
        }
        catch (Exception e) {
            AetherGlovesCompat.warnOnce(e);
        }
        return false;
    }

    private static void warnOnce(Exception e) {
        if (once) {
            return;
        }
        LOGGER.warn("Essential's cosmetic compatibility with [The Aether] and its glove armor has broken, and is now disabled. Cause:", (Throwable)e);
        once = true;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Essential Logger - AetherGlovesCompat");
        boolean loaded = false;
        try {
            Class.forName("io.wispforest.accessories.api.AccessoriesAPI");
            Class.forName("com.aetherteam.aether.Aether");
            loaded = true;
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                LOGGER.debug("The Aether mod is not present, or is an unsupported version. Cosmetic glove compatibility feature disabled.");
            }
            LOGGER.error("Unexpected exception checking for The Aether mod:", (Throwable)e);
        }
        AETHER_LOADED = loaded;
        once = false;
    }
}

