/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.effect;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.effects.Effect;
import gg.essential.gui.EssentialPalette;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lgg/essential/gui/common/effect/CheckerboardBackgroundEffect;", "Lgg/essential/elementa/effects/Effect;", "()V", "beforeDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawCheckerBoard", "component", "Lgg/essential/elementa/UIComponent;", "drawVertex", "graphics", "Lgg/essential/universal/vertex/UBufferBuilder;", "x", "", "y", "color", "Ljava/awt/Color;", "Companion", "essential-gui-essential"})
public final class CheckerboardBackgroundEffect
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final URenderPipeline PIPELINE = URenderPipeline.Companion.builderWithDefaultShader("essential:checkerboard_background_effect", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR).build();

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.drawCheckerBoard(matrixStack, this.getBoundComponent());
    }

    private final void drawCheckerBoard(UMatrixStack matrixStack, UIComponent component3) {
        block2: {
            double left = component3.getLeft();
            double top = component3.getTop();
            double right = component3.getRight();
            double bottom = component3.getBottom();
            UBufferBuilder graphics = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
            int n = (int)(right - left);
            for (int x = 0; x < n; ++x) {
                int n2 = (int)(bottom - top);
                for (int y = 0; y < n2; ++y) {
                    Color color2 = (x + y) % 2 == 0 ? Color.LIGHT_GRAY : EssentialPalette.TEXT_HIGHLIGHT;
                    double d = left + (double)x;
                    double d2 = top + (double)y;
                    Intrinsics.checkNotNull((Object)color2);
                    this.drawVertex(graphics, matrixStack, d, d2, color2);
                    this.drawVertex(graphics, matrixStack, left + (double)x, top + (double)y + 1.0, color2);
                    this.drawVertex(graphics, matrixStack, left + (double)x + 1.0, top + (double)y + 1.0, color2);
                    this.drawVertex(graphics, matrixStack, left + (double)x + 1.0, top + (double)y, color2);
                }
            }
            UBuiltBuffer uBuiltBuffer = graphics.build();
            if (uBuiltBuffer == null) break block2;
            UBuiltBuffer.drawAndClose$default((UBuiltBuffer)uBuiltBuffer, (URenderPipeline)PIPELINE, null, (int)2, null);
        }
    }

    private final void drawVertex(UBufferBuilder graphics, UMatrixStack matrixStack, double x, double y, Color color2) {
        graphics.pos(matrixStack, x, y, 0.0).color((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, (float)color2.getAlpha() / 255.0f).endVertex();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/gui/common/effect/CheckerboardBackgroundEffect$Companion;", "", "()V", "PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

