/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.image;

import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.inspector.Inspector;
import gg.essential.elementa.utils.ResourceCache;
import gg.essential.gui.image.ImageFactory;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgg/essential/gui/image/ResourceImageFactory;", "Lgg/essential/gui/image/ImageFactory;", "resource", "", "preload", "", "(Ljava/lang/String;Z)V", "name", "getName", "()Ljava/lang/String;", "generate", "Lgg/essential/elementa/components/UIImage;", "Companion", "essential-gui-essential"})
public final class ResourceImageFactory
extends ImageFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String resource;
    private static boolean preloadEnabled;
    private static final Set<ResourceImageFactory> preloadQueue;
    @NotNull
    private static final ResourceCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceImageFactory(@NotNull String resource, boolean preload) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        super(null, 1, null);
        this.resource = resource;
        if (preload) {
            Set<ResourceImageFactory> set2 = preloadQueue;
            Intrinsics.checkNotNullExpressionValue(set2, (String)"preloadQueue");
            Set<ResourceImageFactory> set3 = set2;
            synchronized (set3) {
                boolean bl = false;
                Object object = !preloadEnabled ? Boolean.valueOf(preloadQueue.add(this)) : this.generate();
            }
        }
    }

    public /* synthetic */ ResourceImageFactory(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @Override
    @NotNull
    public String getName() {
        return this.resource;
    }

    @Override
    @NotNull
    protected UIImage generate() {
        return UIImage.Companion.ofResourceCached(this.resource, cache);
    }

    static {
        preloadQueue = Collections.newSetFromMap(new WeakHashMap());
        cache = new ResourceCache(Integer.MAX_VALUE);
        Inspector.Companion.registerComponentFactory$default((Inspector.Companion)Inspector.Companion, ResourceImageFactory.class, null, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/gui/image/ResourceImageFactory$Companion;", "", "()V", "cache", "Lgg/essential/elementa/utils/ResourceCache;", "preloadEnabled", "", "preloadQueue", "", "Lgg/essential/gui/image/ResourceImageFactory;", "kotlin.jvm.PlatformType", "", "preload", "", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void preload() {
            Set set2 = preloadQueue;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"access$getPreloadQueue$cp(...)");
            Set set3 = set2;
            synchronized (set3) {
                boolean bl = false;
                preloadEnabled = true;
                for (ResourceImageFactory factory2 : preloadQueue) {
                    factory2.generate();
                }
                preloadQueue.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

