/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.proxies;

import gg.essential.gui.proxies.TintVanillaButtonsEffectShared;
import gg.essential.model.util.Color;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UResolution;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.util.ResourceManagerUtil;
import gg.essential.util.image.GpuTexture;
import gg.essential.util.image.bitmap.Bitmap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0005\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/proxies/TintVanillaButtonsEffectShared;", "", "<init>", "()V", "Companion", "AreaToBeTinted", "Essential 1.21.9-fabric"})
public final class TintVanillaButtonsEffectShared {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private static java.awt.Color averageVanillaButtonColor;
    private static boolean satisfiedWithAverageColor;
    private static int lastHighestButtonAlpha;
    private static long lastHighestAlphaTime;
    @NotNull
    private static final URenderPipeline NON_WHITE_TINT_PIPELINE;

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        ResourceManagerUtil.INSTANCE.onResourceManagerReload((Function0<Unit>)((Function0)Companion.1.INSTANCE));
        URenderPipeline.Builder $this$NON_WHITE_TINT_PIPELINE_u24lambda_u240 = builder = URenderPipeline.Companion.builderWithLegacyShader("essential:darken_vanilla/tint", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR, "#version 110\n\nvarying vec2 f_Position;\nvarying vec2 f_TexCoord;\nvarying vec4 f_Color;\n\nvoid main() {\n    f_Position = gl_Vertex.xy;\n    f_TexCoord = gl_MultiTexCoord0.st;\n    \n    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n    f_Color = gl_Color;\n}", "#version 110\n\nuniform sampler2D u_Button;\nuniform vec3 u_AverageColor;\n\nvarying vec2 f_Position;\nvarying vec2 f_TexCoord;\nvarying vec4 f_Color;\n\nvoid main() {\n    vec4 buttonColor = texture2D(u_Button, f_TexCoord);\n    \n    // Avoid tinting pure white pixels\n    if (buttonColor == vec4(1.0)) {\n        gl_FragColor = buttonColor;\n    } else {\n        // Tint scaled by button alpha\n        vec3 tint = clamp(u_AverageColor - f_Color.rgb, 0.0, 1.0) * buttonColor.a;\n        vec3 tintedColor = clamp(buttonColor.rgb - tint, 0.0, 1.0);\n        gl_FragColor = vec4(tintedColor, buttonColor.a);\n    }\n}");
        boolean bl = false;
        $this$NON_WHITE_TINT_PIPELINE_u24lambda_u240.setBlendState(BlendState.PREMULTIPLIED_ALPHA);
        $this$NON_WHITE_TINT_PIPELINE_u24lambda_u240.setDepthTest(URenderPipeline.DepthTest.Always);
        NON_WHITE_TINT_PIPELINE = builder.build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001d\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0018\u0010\fR\u0017\u0010\u0019\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u001b\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001f\u0010\fR\u0017\u0010 \u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b \u0010\n\u001a\u0004\b!\u0010\fR\u0011\u0010#\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b$\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\n\u001a\u0004\b%\u0010\fR\u0011\u0010'\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0011R\u0011\u0010)\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b*\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\n\u001a\u0004\b+\u0010\fR\u0011\u0010-\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0011R\u0017\u0010.\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b.\u0010\n\u001a\u0004\b/\u0010\f\u00a8\u00060"}, d2={"Lgg/essential/gui/proxies/TintVanillaButtonsEffectShared$AreaToBeTinted;", "", "", "x1", "y1", "x2", "y2", "<init>", "(IIII)V", "bottom", "I", "getBottom", "()I", "height", "getHeight", "", "getHeightMC", "()D", "heightMC", "", "getInvalid", "()Z", "invalid", "left", "getLeft", "right", "getRight", "scale", "D", "getScale", "top", "getTop", "width", "getWidth", "getWidthMC", "widthMC", "getX1", "getX2", "getXMC", "xMC", "getXViewport", "xViewport", "getY1", "getY2", "getYMC", "yMC", "yViewport", "getYViewport", "Essential 1.21.9-fabric"})
    public static final class AreaToBeTinted {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;
        private final double scale;
        private final int left;
        private final int right;
        private final int top;
        private final int bottom;
        private final int width;
        private final int height;
        private final int yViewport;

        public AreaToBeTinted(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.scale = UResolution.getScaleFactor();
            this.left = RangesKt.coerceIn((int)((int)((double)this.x1 * this.scale)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
            this.right = RangesKt.coerceIn((int)((int)((double)this.x2 * this.scale)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
            this.top = RangesKt.coerceIn((int)((int)((double)this.y1 * this.scale)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
            this.bottom = RangesKt.coerceIn((int)((int)((double)this.y2 * this.scale)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
            this.yViewport = UResolution.getViewportHeight() - this.bottom;
        }

        public final int getX1() {
            return this.x1;
        }

        public final int getY1() {
            return this.y1;
        }

        public final int getX2() {
            return this.x2;
        }

        public final int getY2() {
            return this.y2;
        }

        public final double getScale() {
            return this.scale;
        }

        public final int getLeft() {
            return this.left;
        }

        public final int getRight() {
            return this.right;
        }

        public final int getTop() {
            return this.top;
        }

        public final int getBottom() {
            return this.bottom;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getXViewport() {
            return this.left;
        }

        public final int getYViewport() {
            return this.yViewport;
        }

        public final double getXMC() {
            return (double)this.left / this.scale;
        }

        public final double getYMC() {
            return (double)this.top / this.scale;
        }

        public final double getWidthMC() {
            return (double)this.width / this.scale;
        }

        public final double getHeightMC() {
            return (double)this.height / this.scale;
        }

        public final boolean getInvalid() {
            return this.width == 0 || this.height == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lgg/essential/gui/proxies/TintVanillaButtonsEffectShared$Companion;", "", "<init>", "()V", "Lgg/essential/util/image/GpuTexture;", "texture", "", "x", "y", "width", "height", "Ljava/awt/Color;", "averageButtonColor", "(Lgg/essential/util/image/GpuTexture;IIII)Ljava/awt/Color;", "Lgg/essential/universal/render/URenderPipeline;", "NON_WHITE_TINT_PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "getNON_WHITE_TINT_PIPELINE", "()Lgg/essential/universal/render/URenderPipeline;", "averageVanillaButtonColor", "Ljava/awt/Color;", "", "lastHighestAlphaTime", "J", "lastHighestButtonAlpha", "I", "", "satisfiedWithAverageColor", "Z", "Essential 1.21.9-fabric"})
    @SourceDebugExtension(value={"SMAP\nTintVanillaButtonsEffectShared.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TintVanillaButtonsEffectShared.kt\ngg/essential/gui/proxies/TintVanillaButtonsEffectShared$Companion\n+ 2 extensions.kt\ngg/essential/util/image/bitmap/ExtensionsKt\n*L\n1#1,175:1\n35#2,6:176\n*S KotlinDebug\n*F\n+ 1 TintVanillaButtonsEffectShared.kt\ngg/essential/gui/proxies/TintVanillaButtonsEffectShared$Companion\n*L\n94#1:176,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final java.awt.Color averageButtonColor(@NotNull GpuTexture texture, int x, int y, int width2, int height2) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            if (satisfiedWithAverageColor) {
                return averageVanillaButtonColor;
            }
            if (lastHighestAlphaTime != 0L && System.currentTimeMillis() - lastHighestAlphaTime > 5000L) {
                satisfiedWithAverageColor = true;
                return averageVanillaButtonColor;
            }
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            int count = 0;
            int yGl = texture.getHeight() - (y + height2);
            Bitmap bitmap = texture.readPixelColors(x, yGl, width2, height2);
            int prevHighestAlpha = lastHighestButtonAlpha;
            Bitmap $this$forEachPixel$iv = bitmap;
            boolean $i$f$forEachPixel = false;
            int n = $this$forEachPixel$iv.getHeight();
            for (int y$iv = 0; y$iv < n; ++y$iv) {
                int n2 = $this$forEachPixel$iv.getWidth();
                for (int x$iv = 0; x$iv < n2; ++x$iv) {
                    int pixel = $this$forEachPixel$iv.get-XEV4ZDs(x$iv, y$iv);
                    boolean bl = false;
                    int alpha2 = Color.getA-w2LRezQ(pixel) & 0xFF;
                    int red = Color.getR-w2LRezQ(pixel) & 0xFF;
                    int green = Color.getG-w2LRezQ(pixel) & 0xFF;
                    int blue = Color.getB-w2LRezQ(pixel) & 0xFF;
                    if (alpha2 <= 0 || red <= 0 && green <= 0 && blue <= 0) continue;
                    float alphaMultiplier = (float)alpha2 / 255.0f;
                    r += (float)red / alphaMultiplier;
                    g += (float)green / alphaMultiplier;
                    b += (float)blue / alphaMultiplier;
                    ++count;
                    if (alpha2 <= lastHighestButtonAlpha) continue;
                    lastHighestButtonAlpha = alpha2;
                    lastHighestAlphaTime = System.currentTimeMillis();
                    satisfiedWithAverageColor = alpha2 > 64;
                }
            }
            if (count != 0 && prevHighestAlpha != lastHighestButtonAlpha) {
                averageVanillaButtonColor = new java.awt.Color(r / (float)count / 255.0f, g / (float)count / 255.0f, b / (float)count / 255.0f);
            }
            return averageVanillaButtonColor;
        }

        @NotNull
        public final URenderPipeline getNON_WHITE_TINT_PIPELINE() {
            return NON_WHITE_TINT_PIPELINE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

