/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot;

import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.api.gui.Notifications;
import gg.essential.gui.NotificationsKt;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.common.modal.PropertiesModal;
import gg.essential.gui.elementa.state.v2.CoroutineKt;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.ScreenshotIdKt;
import gg.essential.gui.screenshot.UtilsKt;
import gg.essential.gui.screenshot.components.ScreenshotProperties;
import gg.essential.gui.screenshot.image.ForkedImageClipboard;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.sps.SpsAddress;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.TimeFormatKt;
import gg.essential.util.UuidNameLookup;
import gg.essential.util.lwjgl3.Lwjgl3Loader;
import gg.essential.util.lwjgl3.api.ImageData;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a0\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"copyScreenshotToClipboard", "", "screenshot", "Lgg/essential/gui/screenshot/ScreenshotId;", "Ljava/nio/file/Path;", "createDateOnlyCalendar", "Ljava/util/Calendar;", "time", "", "generateImageProperties", "", "Lkotlin/Pair;", "", "Lgg/essential/gui/elementa/state/v2/State;", "properties", "Lgg/essential/gui/screenshot/components/ScreenshotProperties;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getImageTime", "Lcom/sparkuniverse/toolbox/util/DateTime;", "useEditIfPresent", "", "path", "metadata", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "openScreenshotPropertiesModal", "saveImageAsScreenshot", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "essential-gui-essential"})
public final class UtilsKt {
    @NotNull
    public static final Calendar createDateOnlyCalendar(long time2) {
        Calendar date = new GregorianCalendar();
        date.setTimeInMillis(time2);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        return date;
    }

    public static /* synthetic */ Calendar createDateOnlyCalendar$default(long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = System.currentTimeMillis();
        }
        return UtilsKt.createDateOnlyCalendar(l);
    }

    @NotNull
    public static final DateTime getImageTime(@NotNull Path path, @Nullable ClientScreenshotMetadata metadata2, boolean useEditIfPresent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return UtilsKt.getImageTime(new ScreenshotProperties(new LocalScreenshot(path), metadata2), useEditIfPresent);
    }

    @NotNull
    public static final DateTime getImageTime(@NotNull ScreenshotProperties properties, boolean useEditIfPresent) {
        DateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        ScreenshotId id2 = properties.component1();
        ClientScreenshotMetadata metadata2 = properties.component2();
        if (metadata2 != null) {
            if (useEditIfPresent) {
                dateTime = metadata2.getEditTime();
                if (dateTime == null) {
                    dateTime = metadata2.getTime();
                }
            } else {
                dateTime = metadata2.getTime();
            }
        } else if (id2 instanceof LocalScreenshot) {
            long l;
            Path path = ((LocalScreenshot)id2).getPath();
            String[] stringArray = new String[]{"_"};
            String name2 = StringsKt.removeSuffix((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)((Object)path.getFileName()).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null), (CharSequence)".png");
            try {
                l = ScreenshotIdKt.getSCREENSHOT_DATETIME_FORMAT().parse(name2).getTime();
            }
            catch (Exception e) {
                long l2;
                try {
                    l2 = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                }
                catch (Exception e2) {
                    l2 = 0L;
                }
                l = l2;
            }
            long millis = l;
            dateTime = new DateTime(millis);
        } else {
            dateTime = new DateTime(0L);
        }
        return dateTime;
    }

    public static final void openScreenshotPropertiesModal(@NotNull ScreenshotProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        GuiEssentialPlatform.Companion.getPlatform().pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(properties){
            final /* synthetic */ ScreenshotProperties $properties;
            {
                this.$properties = $properties;
                super(1);
            }

            @NotNull
            public final Modal invoke(@NotNull ModalManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                return new PropertiesModal(manager, MapsKt.toMap((Iterable)UtilsKt.access$generateImageProperties(this.$properties, manager.getCoroutineScope())));
            }
        }));
    }

    private static final List<Pair<String, State<String>>> generateImageProperties(ScreenshotProperties properties, CoroutineScope coroutineScope) {
        DateTime editTime;
        DateTime imageTime;
        List pairList = new ArrayList();
        pairList.add(TuplesKt.to((Object)"Name", StateKt.stateOf(properties.getId().getName())));
        ClientScreenshotMetadata metadata2 = properties.getMetadata();
        if (metadata2 != null) {
            String string = metadata2.getLocationMetadata().getIdentifier();
            if (string == null) {
                string = "";
            }
            String locationIdentifier = string;
            switch (WhenMappings.$EnumSwitchMapping$0[metadata2.getLocationMetadata().getType().ordinal()]) {
                case 1: {
                    pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf("Unknown")));
                    break;
                }
                case 2: {
                    pairList.add(TuplesKt.to((Object)"Server", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 3: {
                    pairList.add(TuplesKt.to((Object)"Menu", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 4: {
                    pairList.add(TuplesKt.to((Object)"World", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 5: {
                    UUID host;
                    SpsAddress spsAddress = SpsAddress.Companion.parse(locationIdentifier);
                    UUID uUID = host = spsAddress != null ? spsAddress.getHost() : null;
                    if (host != null) {
                        pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf("Shared World")));
                        pairList.add(TuplesKt.to((Object)"Host", UuidNameLookup.nameState(host, "Loading...")));
                        break;
                    }
                    pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf(locationIdentifier)));
                }
            }
            pairList.add(TuplesKt.to((Object)"Creator", UuidNameLookup.nameState(metadata2.getAuthorId(), "Loading...")));
        }
        if ((imageTime = UtilsKt.getImageTime(properties, false)).getTime() > 0L) {
            Instant instant = Instant.ofEpochMilli(imageTime.getTime());
            LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            StringBuilder stringBuilder = new StringBuilder().append(imageTime.format(new SimpleDateFormat("EEEE", Locale.ENGLISH))).append(", ");
            Intrinsics.checkNotNull((Object)localDate);
            pairList.add(TuplesKt.to((Object)"Date", StateKt.stateOf(stringBuilder.append(TimeFormatKt.formatDate$default(localDate, false, 2, null)).toString())));
            Intrinsics.checkNotNull((Object)instant);
            pairList.add(TuplesKt.to((Object)"Time", StateKt.stateOf(TimeFormatKt.formatTime(instant, true))));
        }
        ClientScreenshotMetadata clientScreenshotMetadata = properties.getMetadata();
        DateTime dateTime = editTime = clientScreenshotMetadata != null ? clientScreenshotMetadata.getEditTime() : null;
        if (editTime != null) {
            Instant instant = Instant.ofEpochMilli(editTime.getTime());
            LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            StringBuilder stringBuilder = new StringBuilder().append(editTime.format(new SimpleDateFormat("EEEE", Locale.ENGLISH))).append(", ");
            Intrinsics.checkNotNull((Object)localDate);
            pairList.add(TuplesKt.to((Object)"Edit Date", StateKt.stateOf(stringBuilder.append(TimeFormatKt.formatDate$default(localDate, false, 2, null)).toString())));
            Intrinsics.checkNotNull((Object)instant);
            pairList.add(TuplesKt.to((Object)"Edit Time", StateKt.stateOf(TimeFormatKt.formatTime(instant, true))));
        }
        pairList.add(TuplesKt.to((Object)"Dimensions", gg.essential.gui.elementa.state.v2.combinators.StateKt.map(CoroutineKt.asyncMap$default(StateKt.stateOf(""), coroutineScope, false, (Function2)new Function2<String, Continuation<? super String>, Object>(properties, null){
            int label;
            final /* synthetic */ ScreenshotProperties $properties;
            {
                this.$properties = $properties;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageData>, Object>(this.$properties, null){
                            int label;
                            final /* synthetic */ ScreenshotProperties $properties;
                            {
                                this.$properties = $properties;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Object object2 = this.$properties.getId().open();
                                        Throwable throwable = null;
                                        try {
                                            Object it = (InputStream)object2;
                                            boolean bl = false;
                                            it = ByteStreamsKt.readBytes((InputStream)it);
                                        }
                                        catch (Throwable it) {
                                            throwable = it;
                                            throw it;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                                        }
                                        ByteBuf bytes = Unpooled.wrappedBuffer((byte[])it);
                                        Lwjgl3Loader this_$iv = GuiEssentialPlatform.Companion.getPlatform().getLwjgl3();
                                        boolean $i$f$get = false;
                                        Intrinsics.checkNotNull((Object)bytes);
                                        UnpooledByteBufAllocator unpooledByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
                                        Intrinsics.checkNotNullExpressionValue((Object)unpooledByteBufAllocator, (String)"DEFAULT");
                                        Object it = object2 = this_$iv.get(NativeImageReader.class).getImageData(bytes, (ByteBufAllocator)unpooledByteBufAllocator);
                                        boolean bl = false;
                                        it.release();
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ImageData> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            image = (ImageData)v0;
                            var2_3 = "" + image.getWidth() + 'x' + image.getHeight() + " pixels";
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(PropertiesModal.class).error("Failed to read image dimensions: ", (Throwable)e);
                            var2_3 = "Unknown";
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull String p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null), generateImageProperties.2.INSTANCE)));
        return pairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyScreenshotToClipboard(@NotNull ScreenshotId screenshot) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        Path tmpFile = Files.createTempFile("screenshot", ".png", new FileAttribute[0]);
        try {
            Closeable closeable = screenshot.open();
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(stream, tmpFile, copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNull((Object)tmpFile);
            UtilsKt.copyScreenshotToClipboard(tmpFile);
            Files.deleteIfExists(tmpFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            gg.essential.gui.notification.Notifications.INSTANCE.push("Error Copying Screenshot", "An unknown error occurred. Check logs for details");
        }
        finally {
            Intrinsics.checkNotNull((Object)tmpFile);
            Files.deleteIfExists(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyScreenshotToClipboard(@NotNull Path screenshot) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        AutoCloseable autoCloseable = new ForkedImageClipboard();
        Throwable throwable = null;
        try {
            ForkedImageClipboard clipboard = (ForkedImageClipboard)autoCloseable;
            boolean bl = false;
            File file = screenshot.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (clipboard.copy(file)) {
                NotificationsKt.sendPictureCopiedNotification();
            } else {
                ExtensionsKt.error$default(gg.essential.gui.notification.Notifications.INSTANCE, "Failed to copy picture", "", null, null, null, 28, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object saveImageAsScreenshot(@NotNull BufferedImage var0, @NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof saveImageAsScreenshot.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.saveImageAsScreenshot(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(image, null){
                    int label;
                    final /* synthetic */ BufferedImage $image;
                    {
                        this.$image = $image;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                folder = GuiEssentialPlatform.Companion.getPlatform().getScreenshotFolder();
                                baseName = "saved_" + ScreenshotIdKt.getSCREENSHOT_DATETIME_FORMAT().format(new Date());
                                var6_4 = ((Iterable)new IntRange(0, 0x7FFFFFFF)).iterator();
                                while (var6_4.hasNext()) {
                                    i = ((IntIterator)var6_4).nextInt();
                                    $i$a$-firstNotNullOf-UtilsKt$saveImageAsScreenshot$2$file$1 = false;
                                    it = var9_11 = folder.resolve(baseName + (i > 0 ? "" + '_' + i : "") + ".png");
                                    $i$a$-takeUnless-UtilsKt$saveImageAsScreenshot$2$file$1$1 = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    v0 = new LinkOption[]{};
                                    v1 = !Files.exists(it, Arrays.copyOf(v0, v0.length)) ? var9_11 : null;
                                    v2 = v1;
                                    if (v1 == null) {
                                        continue;
                                    }
                                    ** GOTO lbl23
                                }
                                v2 = null;
lbl23:
                                // 2 sources

                                if (v2 == null) {
                                    throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
                                }
                                file = v2;
                                v3 = new OpenOption[]{};
                                v4 = Files.newOutputStream(file, Arrays.copyOf(v3, v3.length));
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"newOutputStream(...)");
                                var5_16 = v4;
                                var6_4 = this.$image;
                                var7_6 = null;
                                try {
                                    it = (OutputStream)var5_16;
                                    $i$a$-use-UtilsKt$saveImageAsScreenshot$2$1 = false;
                                    var8_8 = Boxing.boxBoolean((boolean)ImageIO.write((RenderedImage)var6_4, "png", it));
                                }
                                catch (Throwable var8_9) {
                                    var7_6 = var8_9;
                                    throw var8_9;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var5_16, (Throwable)var7_6);
                                }
                                return var8_8;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                Notifications.push$default(gg.essential.gui.notification.Notifications.INSTANCE, "Picture saved", "", 0.0f, saveImageAsScreenshot.3.INSTANCE, null, saveImageAsScreenshot.4.INSTANCE, 20, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ List access$generateImageProperties(ScreenshotProperties properties, CoroutineScope coroutineScope) {
        return UtilsKt.generateImageProperties(properties, coroutineScope);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientScreenshotMetadata.Location.Type.values().length];
            try {
                nArray[ClientScreenshotMetadata.Location.Type.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.MULTIPLAYER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.MENU.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.SINGLE_PLAYER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.SHARED_WORLD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

