/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.api.utils.ShutdownHookUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
implements ShutdownHookUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);
    public static final ShutdownHook INSTANCE = new ShutdownHook();
    private final Queue<Runnable> hooks = new ConcurrentLinkedQueue<Runnable>();

    public void execute() {
        for (Runnable hook : this.hooks) {
            try {
                hook.run();
            }
            catch (Exception e) {
                LOGGER.error("Failed to run shutdown hook.", (Throwable)e);
            }
        }
    }

    @Override
    public void register(@NotNull Runnable runnable) {
        this.hooks.add(runnable);
    }

    @Override
    public void unregister(@NotNull Runnable runnable) {
        this.hooks.remove(runnable);
    }
}

