/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.key;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.WindowScreen;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.components.inspector.Inspector;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.event.client.ClientTickEvent;
import gg.essential.gui.emotes.EmoteWheel;
import gg.essential.gui.friends.SocialMenu;
import gg.essential.gui.modals.QuickAccessModal;
import gg.essential.gui.overlay.Layer;
import gg.essential.gui.overlay.OverlayManagerImpl;
import gg.essential.gui.screenshot.components.ScreenshotBrowser;
import gg.essential.gui.wardrobe.Wardrobe;
import gg.essential.handlers.PauseMenuDisplay;
import gg.essential.handlers.ZoomHandler;
import gg.essential.key.EssentialKeybinding;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.model.BedrockModel;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.sps.SPSSessionSource;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.wrappers.UPlayer;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.OptiFineUtil;
import java.util.List;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class EssentialKeybindingRegistry {
    private static final class_304.class_11900 CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"essential", (String)"general"));
    private static final EssentialKeybindingRegistry INSTANCE = new EssentialKeybindingRegistry();
    private EssentialKeybinding cosmetics_visibility_toggle;
    private EssentialKeybinding emote_wheel_open;
    private EssentialKeybinding quick_access_open;
    private EssentialKeybinding zoom;
    private boolean holdingChatPeek;

    public void refreshBinds() {
        boolean anyKeybindingsRegistered = false;
        for (EssentialKeybinding bind2 : EssentialKeybinding.ALL_BINDS) {
            if (bind2.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
                bind2.unregister();
                continue;
            }
            if (bind2.isRegisteredWithMinecraft()) {
                anyKeybindingsRegistered = true;
                continue;
            }
            anyKeybindingsRegistered = true;
            bind2.register();
        }
    }

    public class_304[] registerKeyBinds(class_304[] allBindings) {
        new EssentialKeybinding("ESSENTIAL_FRIENDS", CATEGORY, UKeyboard.KEY_H).requiresEssentialFull().withInitialPress(() -> {
            if (!UKeyboard.isKeyDown((int)UKeyboard.KEY_F3) && UMinecraft.getMinecraft().field_1755 == null) {
                GuiUtil.openScreen(SocialMenu.class, SocialMenu::new);
            }
        });
        EssentialKeybinding studio = new EssentialKeybinding("COSMETIC_STUDIO", CATEGORY, UKeyboard.KEY_B).withInitialPress(() -> {
            if (!UKeyboard.isKeyDown((int)UKeyboard.KEY_F3) && UMinecraft.getMinecraft().field_1755 == null) {
                GuiUtil.openScreen(Wardrobe.class, Wardrobe::new);
            }
        });
        new EssentialKeybinding("SCREENSHOT_MANAGER", CATEGORY, UKeyboard.KEY_I).requiresEssentialFull().withInitialPress(() -> {
            if (!UKeyboard.isKeyDown((int)UKeyboard.KEY_F3) && UMinecraft.getMinecraft().field_1755 == null) {
                GuiUtil.openScreen(ScreenshotBrowser.class, ScreenshotBrowser::new);
            }
        });
        if (System.getProperty("elementa.dev", "false").equals("true")) {
            new EssentialKeybinding("INSERT_INSPECTOR", CATEGORY, UKeyboard.KEY_EQUALS, true).withInitialPress(() -> {
                if (UKeyboard.isShiftKeyDown()) {
                    OptionsKt.setElementaDebug((!OptionsKt.getElementaDebug() ? 1 : 0) != 0);
                } else {
                    Window window = null;
                    class_437 openedScreen = GuiUtil.INSTANCE.openedScreen();
                    Layer layer2 = OverlayManagerImpl.INSTANCE.getHoveredLayer();
                    if (layer2 != null) {
                        window = layer2.getWindow();
                    } else if (openedScreen instanceof WindowScreen) {
                        window = ((WindowScreen)openedScreen).getWindow();
                    } else {
                        return;
                    }
                    List inspectors = window.childrenOfType(Inspector.class);
                    if (inspectors.size() > 0) {
                        for (Inspector inspector : inspectors) {
                            window.removeChild((UIComponent)inspector);
                        }
                    } else {
                        window.addChild((UIComponent)new Inspector((UIComponent)window));
                    }
                }
            });
            if (MinecraftUtils.INSTANCE.isDevelopment()) {
                new EssentialKeybinding("ESSENTIAL_DEBUG_KEY", CATEGORY, UKeyboard.KEY_MINUS, true).withInitialPress(() -> Essential.getInstance().debugKeyFunction());
                new EssentialKeybinding("TOGGLE_DEBUG", CATEGORY, UKeyboard.KEY_BACKSLASH).withInitialPress(ExtensionsKt::toggleElementaDebug);
            }
        }
        int cosmeticToggleKey = UKeyboard.KEY_NONE;
        this.cosmetics_visibility_toggle = new EssentialKeybinding("COSMETICS_VISIBILITY_TOGGLE", CATEGORY, cosmeticToggleKey, false).withInitialPress(() -> {
            if (OverlayManagerImpl.INSTANCE.getFocusedLayer() == null && !EssentialConfig.INSTANCE.getDisableCosmetics()) {
                EssentialConfig.INSTANCE.getOwnCosmeticsVisibleStateWithSource().set((Pair<Boolean, EssentialConfig.CosmeticsVisibilitySource>)((Function1)pair -> new Pair((Object)((Boolean)pair.component1() == false ? 1 : 0), (Object)EssentialConfig.CosmeticsVisibilitySource.UserWithNotification)));
            }
        });
        EssentialKeybinding chatPeek = new EssentialKeybinding("CHAT_PEEK", CATEGORY, UKeyboard.KEY_Z).withRepeatedHold(() -> {
            this.holdingChatPeek = true;
        }).withRelease(() -> {
            this.holdingChatPeek = false;
            class_310.method_1551().field_1705.method_1743().method_1820();
        });
        EssentialKeybinding invite = new EssentialKeybinding("INVITE_FRIENDS", CATEGORY, UKeyboard.KEY_NONE).withInitialPress(() -> PauseMenuDisplay.Companion.showInviteOrHostModal(SPSSessionSource.KEYBIND));
        this.quick_access_open = new EssentialKeybinding("MENU_ACCESS", CATEGORY, UKeyboard.KEY_G).withInitialPress(QuickAccessModal::openInGame).requiresEssentialFull();
        this.emote_wheel_open = new EssentialKeybinding("EMOTE_WHEEL", CATEGORY, UKeyboard.KEY_R).requiresEssentialFull().withRepeatedHold(() -> EmoteWheel.open()).withRelease(() -> {
            EmoteWheel.emoteClicked = false;
        });
        for (int i2 = 0; i2 < 8; ++i2) {
            int index2 = i2;
            new EssentialKeybinding("EMOTE_SLOT_" + (i2 + 1), CATEGORY, UKeyboard.KEY_NONE).requiresEssentialFull().withInitialPress(() -> {
                ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
                CosmeticsManager cosmeticsManager = connectionManager.getCosmeticsManager();
                String emote2 = connectionManager.getEmoteWheelManager().getSelectedEmoteWheelSlots().getUntracked().get(index2);
                if (emote2 == null) {
                    return;
                }
                Cosmetic cosmetic2 = cosmeticsManager.getCosmetic(emote2);
                class_746 player2 = UPlayer.getPlayer();
                if (cosmetic2 != null && player2 != null) {
                    cosmeticsManager.getModelLoader().getModel(cosmetic2, cosmetic2.getDefaultVariantName(), AssetLoader.Priority.Blocking).whenCompleteAsync((model, throwable) -> {
                        if (throwable == null && EmoteWheel.canEmote((class_742)player2)) {
                            EmoteWheel.Companion.equipEmote((BedrockModel)model);
                        }
                    }, ExtensionsKt.getExecutor(UMinecraft.getMinecraft()));
                }
            });
        }
        if (!OptiFineUtil.isLoaded()) {
            this.zoom = new EssentialKeybinding("ZOOM", CATEGORY, UKeyboard.KEY_C);
            this.zoom.requiresEssentialFull();
            ZoomHandler.getInstance().zoomKeybinding = this.zoom.keyBinding;
        }
        studio.requiresEssentialFull();
        this.cosmetics_visibility_toggle.requiresEssentialFull();
        chatPeek.requiresEssentialFull();
        invite.requiresEssentialFull();
        for (EssentialKeybinding binding : EssentialKeybinding.ALL_BINDS) {
            allBindings = binding.register(allBindings);
        }
        return allBindings;
    }

    @Subscribe
    public void tick(ClientTickEvent event) {
        for (EssentialKeybinding essentialKeybinding : EssentialKeybinding.ALL_BINDS) {
            essentialKeybinding.tickEvents();
        }
    }

    @NotNull
    public EssentialKeybinding getToggleCosmetics() {
        return this.cosmetics_visibility_toggle;
    }

    @NotNull
    public EssentialKeybinding getOpenEmoteWheel() {
        return this.emote_wheel_open;
    }

    @NotNull
    public EssentialKeybinding getOpenQuickAccess() {
        return this.quick_access_open;
    }

    public EssentialKeybinding getZoom() {
        return this.zoom;
    }

    public boolean isHoldingChatPeek() {
        return this.holdingChatPeek;
    }

    public static EssentialKeybindingRegistry getInstance() {
        return INSTANCE;
    }
}

