/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.http;

import gg.essential.lib.okhttp3.Interceptor;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.Response;
import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okhttp3.internal.connection.RealConnection;
import gg.essential.lib.okhttp3.internal.connection.StreamAllocation;
import gg.essential.lib.okhttp3.internal.http.HttpCodec;
import gg.essential.lib.okhttp3.internal.http.HttpMethod;
import gg.essential.lib.okhttp3.internal.http.RealInterceptorChain;
import gg.essential.lib.okio.Buffer;
import gg.essential.lib.okio.BufferedSink;
import gg.essential.lib.okio.ForwardingSink;
import gg.essential.lib.okio.Okio;
import gg.essential.lib.okio.Sink;
import java.io.IOException;
import java.net.ProtocolException;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean forWebSocket) {
        this.forWebSocket = forWebSocket;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        HttpCodec httpCodec = realChain.httpStream();
        StreamAllocation streamAllocation = realChain.streamAllocation();
        RealConnection connection = (RealConnection)realChain.connection();
        Request request2 = realChain.request();
        long sentRequestMillis = System.currentTimeMillis();
        realChain.eventListener().requestHeadersStart(realChain.call());
        httpCodec.writeRequestHeaders(request2);
        realChain.eventListener().requestHeadersEnd(realChain.call(), request2);
        Response.Builder responseBuilder = null;
        if (HttpMethod.permitsRequestBody(request2.method()) && request2.body() != null) {
            if ("100-continue".equalsIgnoreCase(request2.header("Expect"))) {
                httpCodec.flushRequest();
                realChain.eventListener().responseHeadersStart(realChain.call());
                responseBuilder = httpCodec.readResponseHeaders(true);
            }
            if (responseBuilder == null) {
                realChain.eventListener().requestBodyStart(realChain.call());
                long contentLength = request2.body().contentLength();
                CountingSink requestBodyOut = new CountingSink(httpCodec.createRequestBody(request2, contentLength));
                BufferedSink bufferedRequestBody = Okio.buffer(requestBodyOut);
                request2.body().writeTo(bufferedRequestBody);
                bufferedRequestBody.close();
                realChain.eventListener().requestBodyEnd(realChain.call(), requestBodyOut.successfulCount);
            } else if (!connection.isMultiplexed()) {
                streamAllocation.noNewStreams();
            }
        }
        httpCodec.finishRequest();
        if (responseBuilder == null) {
            realChain.eventListener().responseHeadersStart(realChain.call());
            responseBuilder = httpCodec.readResponseHeaders(false);
        }
        Response response = responseBuilder.request(request2).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
        realChain.eventListener().responseHeadersEnd(realChain.call(), response);
        int code = response.code();
        response = this.forWebSocket && code == 101 ? response.newBuilder().body(Util.EMPTY_RESPONSE).build() : response.newBuilder().body(httpCodec.openResponseBody(response)).build();
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            streamAllocation.noNewStreams();
        }
        if ((code == 204 || code == 205) && response.body().contentLength() > 0L) {
            throw new ProtocolException("HTTP " + code + " had non-zero Content-Length: " + response.body().contentLength());
        }
        return response;
    }

    static final class CountingSink
    extends ForwardingSink {
        long successfulCount;

        CountingSink(Sink delegate2) {
            super(delegate2);
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.successfulCount += byteCount;
        }
    }
}

