/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.minecraftauth.minecraft;

import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.minecraftauth.exception.AuthenticationException;
import gg.essential.minecraftauth.exception.MinecraftAuthenticationException;
import gg.essential.minecraftauth.minecraft.request.MinecraftAuthenticationRequest;
import gg.essential.minecraftauth.minecraft.response.MinecraftAuthenticationErrorResponse;
import gg.essential.minecraftauth.minecraft.response.MinecraftProfileResponse;
import gg.essential.minecraftauth.minecraft.response.MinecraftTokenResponse;
import gg.essential.minecraftauth.util.HttpKt;
import gg.essential.minecraftauth.util.JsonKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgg/essential/minecraftauth/minecraft/MinecraftAuthenticationService;", "", "()V", "AUTHENTICATION_URI", "", "PROFILE_URI", "authenticateWithXbox", "Lgg/essential/minecraftauth/minecraft/response/MinecraftTokenResponse;", "token", "userHash", "getProfile", "Lgg/essential/minecraftauth/minecraft/response/MinecraftProfileResponse;", "accessToken", "minecraft-auth"})
@SourceDebugExtension(value={"SMAP\nMinecraftAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftAuthenticationService.kt\ngg/essential/minecraftauth/minecraft/MinecraftAuthenticationService\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,100:1\n113#2:101\n1#3:102\n96#4:103\n96#4:104\n96#4:105\n96#4:106\n*S KotlinDebug\n*F\n+ 1 MinecraftAuthenticationService.kt\ngg/essential/minecraftauth/minecraft/MinecraftAuthenticationService\n*L\n47#1:101\n51#1:103\n57#1:104\n81#1:105\n87#1:106\n*E\n"})
public final class MinecraftAuthenticationService {
    @NotNull
    public static final MinecraftAuthenticationService INSTANCE = new MinecraftAuthenticationService();
    @NotNull
    private static final String AUTHENTICATION_URI = "https://api.minecraftservices.com/authentication/login_with_xbox";
    @NotNull
    private static final String PROFILE_URI = "https://api.minecraftservices.com/minecraft/profile";

    private MinecraftAuthenticationService() {
    }

    @NotNull
    public final MinecraftTokenResponse authenticateWithXbox(@NotNull String token, @NotNull String userHash) throws MinecraftAuthenticationException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)userHash, (String)"userHash");
        MinecraftAuthenticationRequest request2 = new MinecraftAuthenticationRequest("XBL3.0 x=" + userHash + ';' + token);
        Request.Builder builder = new Request.Builder().url(AUTHENTICATION_URI).header("Accept", "application/json");
        MediaType mediaType = HttpKt.getJSON_MEDIA_TYPE();
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.getJSON();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        Request request3 = builder.post(RequestBody.create(mediaType, $this$encodeToString$iv.encodeToString((SerializationStrategy)MinecraftAuthenticationRequest.Companion.serializer(), (Object)request2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)request3, (String)"build(...)");
        Pair<Integer, String> pair = HttpKt.execute(request3);
        int status2 = ((Number)pair.component1()).intValue();
        String content = (String)pair.component2();
        switch (status2) {
            case 200: {
                Object $this$authenticateWithXbox_u24lambda_u240;
                object = this;
                try {
                    $this$authenticateWithXbox_u24lambda_u240 = object;
                    boolean bl = false;
                    Json this_$iv = JsonKt.getJSON();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    $this$authenticateWithXbox_u24lambda_u240 = Result.constructor-impl((Object)((MinecraftTokenResponse)this_$iv.decodeFromString((DeserializationStrategy)MinecraftTokenResponse.Companion.serializer(), content)));
                }
                catch (Throwable bl) {
                    $this$authenticateWithXbox_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$authenticateWithXbox_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break;
                Throwable it = throwable;
                boolean bl = false;
                throw new AuthenticationException.InvalidResponse(status2, content);
            }
            case 401: {
                throw new AuthenticationException.InvalidCredentials();
            }
            default: {
                Object $this$authenticateWithXbox_u24lambda_u242;
                Object object2 = this;
                try {
                    $this$authenticateWithXbox_u24lambda_u242 = object2;
                    boolean bl = false;
                    Json this_$iv = JsonKt.getJSON();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    $this$authenticateWithXbox_u24lambda_u242 = Result.constructor-impl((Object)((MinecraftAuthenticationErrorResponse)this_$iv.decodeFromString((DeserializationStrategy)MinecraftAuthenticationErrorResponse.Companion.serializer(), content)));
                }
                catch (Throwable bl) {
                    $this$authenticateWithXbox_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$authenticateWithXbox_u24lambda_u242;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw new AuthenticationException.InvalidResponse(status2, content);
                }
                MinecraftAuthenticationErrorResponse body = (MinecraftAuthenticationErrorResponse)object2;
                throw new MinecraftAuthenticationException.Failed(body);
            }
        }
        return (MinecraftTokenResponse)object;
    }

    @NotNull
    public final MinecraftProfileResponse getProfile(@NotNull String accessToken) throws MinecraftAuthenticationException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Request request2 = new Request.Builder().url(PROFILE_URI).addHeader("Authorization", "Bearer " + accessToken).addHeader("Accept", "application/json").get().build();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"build(...)");
        Pair<Integer, String> pair = HttpKt.execute(request2);
        int status2 = ((Number)pair.component1()).intValue();
        String content = (String)pair.component2();
        switch (status2) {
            case 200: {
                Object $this$getProfile_u24lambda_u244;
                object = this;
                try {
                    $this$getProfile_u24lambda_u244 = object;
                    boolean bl = false;
                    Json this_$iv = JsonKt.getJSON();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    $this$getProfile_u24lambda_u244 = Result.constructor-impl((Object)((MinecraftProfileResponse)this_$iv.decodeFromString((DeserializationStrategy)MinecraftProfileResponse.Companion.serializer(), content)));
                }
                catch (Throwable bl) {
                    $this$getProfile_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$getProfile_u24lambda_u244;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break;
                Throwable it = throwable;
                boolean bl = false;
                throw new AuthenticationException.InvalidResponse(status2, content);
            }
            case 401: {
                throw new AuthenticationException.InvalidCredentials();
            }
            default: {
                Object $this$getProfile_u24lambda_u246;
                Object object2 = this;
                try {
                    $this$getProfile_u24lambda_u246 = object2;
                    boolean bl = false;
                    Json this_$iv = JsonKt.getJSON();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    $this$getProfile_u24lambda_u246 = Result.constructor-impl((Object)((MinecraftAuthenticationErrorResponse)this_$iv.decodeFromString((DeserializationStrategy)MinecraftAuthenticationErrorResponse.Companion.serializer(), content)));
                }
                catch (Throwable bl) {
                    $this$getProfile_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$getProfile_u24lambda_u246;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw new AuthenticationException.InvalidResponse(status2, content);
                }
                MinecraftAuthenticationErrorResponse body = (MinecraftAuthenticationErrorResponse)object2;
                if (Intrinsics.areEqual((Object)body.getError(), (Object)"NOT_FOUND")) {
                    throw new MinecraftAuthenticationException.ProfileNotFound();
                }
                throw new MinecraftAuthenticationException.Failed(body);
            }
        }
        return (MinecraftProfileResponse)object;
    }
}

