/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.minecraftauth.minecraft.session;

import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.minecraftauth.exception.AuthenticationException;
import gg.essential.minecraftauth.exception.MinecraftAuthenticationException;
import gg.essential.minecraftauth.minecraft.response.MinecraftAuthenticationErrorResponse;
import gg.essential.minecraftauth.minecraft.session.request.JoinServerRequest;
import gg.essential.minecraftauth.util.HttpKt;
import gg.essential.minecraftauth.util.JsonKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgg/essential/minecraftauth/minecraft/session/MinecraftSessionService;", "", "()V", "JOIN_URI", "", "joinServer", "", "accessToken", "uuid", "Ljava/util/UUID;", "serverId", "minecraft-auth"})
@SourceDebugExtension(value={"SMAP\nMinecraftSessionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftSessionService.kt\ngg/essential/minecraftauth/minecraft/session/MinecraftSessionService\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,70:1\n113#2:71\n1#3:72\n96#4:73\n*S KotlinDebug\n*F\n+ 1 MinecraftSessionService.kt\ngg/essential/minecraftauth/minecraft/session/MinecraftSessionService\n*L\n48#1:71\n59#1:73\n*E\n"})
public final class MinecraftSessionService {
    @NotNull
    public static final MinecraftSessionService INSTANCE = new MinecraftSessionService();
    @NotNull
    private static final String JOIN_URI = System.getProperty("minecraft.api.session.host", "https://sessionserver.mojang.com") + "/session/minecraft/join";

    private MinecraftSessionService() {
    }

    public final void joinServer(@NotNull String accessToken, @NotNull UUID uuid, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        JoinServerRequest request2 = new JoinServerRequest(accessToken, StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null), serverId);
        Request.Builder builder = new Request.Builder().url(JOIN_URI);
        MediaType mediaType = HttpKt.getJSON_MEDIA_TYPE();
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.getJSON();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        Request request3 = builder.post(RequestBody.create(mediaType, $this$encodeToString$iv.encodeToString((SerializationStrategy)JoinServerRequest.Companion.serializer(), (Object)request2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)request3, (String)"build(...)");
        Pair<Integer, String> pair = HttpKt.execute(request3);
        int status2 = ((Number)pair.component1()).intValue();
        String content = (String)pair.component2();
        switch (status2) {
            case 204: {
                break;
            }
            case 429: {
                throw new AuthenticationException.Ratelimited();
            }
            default: {
                Object $this$joinServer_u24lambda_u240;
                Object object = this;
                try {
                    $this$joinServer_u24lambda_u240 = object;
                    boolean bl = false;
                    Json this_$iv = JsonKt.getJSON();
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    $this$joinServer_u24lambda_u240 = Result.constructor-impl((Object)((MinecraftAuthenticationErrorResponse)this_$iv.decodeFromString((DeserializationStrategy)MinecraftAuthenticationErrorResponse.Companion.serializer(), content)));
                }
                catch (Throwable bl) {
                    $this$joinServer_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$joinServer_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw new AuthenticationException.InvalidResponse(status2, content);
                }
                MinecraftAuthenticationErrorResponse body = (MinecraftAuthenticationErrorResponse)object;
                object = body.getError();
                if (Intrinsics.areEqual((Object)object, (Object)"InsufficientPrivilegesException")) {
                    throw new MinecraftAuthenticationException.InsufficientPrivileges();
                }
                if (Intrinsics.areEqual((Object)object, (Object)"ForbiddenOperationException")) {
                    throw new AuthenticationException.InvalidCredentials();
                }
                throw new MinecraftAuthenticationException.Failed(body);
            }
        }
    }
}

