/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.minecraftauth.xbox;

import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.minecraftauth.exception.AuthenticationException;
import gg.essential.minecraftauth.exception.XboxLiveAuthenticationException;
import gg.essential.minecraftauth.util.HttpKt;
import gg.essential.minecraftauth.util.JsonKt;
import gg.essential.minecraftauth.xbox.request.XboxLiveAuthenticationRequest;
import gg.essential.minecraftauth.xbox.response.XboxLiveAuthenticationErrorResponse;
import gg.essential.minecraftauth.xbox.response.XboxLiveTokenResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/minecraftauth/xbox/XboxLiveAuthenticationService;", "", "()V", "XBL_AUTHENTICATION_URI", "", "XSTS_AUTHENTICATION_URI", "authenticateWithXSTS", "Lkotlin/Pair;", "Lgg/essential/minecraftauth/xbox/response/XboxLiveTokenResponse;", "xblToken", "authenticateWithXboxLive", "accessToken", "makeRequest", "uri", "request", "Lgg/essential/minecraftauth/xbox/request/XboxLiveAuthenticationRequest;", "minecraft-auth"})
@SourceDebugExtension(value={"SMAP\nXboxLiveAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XboxLiveAuthenticationService.kt\ngg/essential/minecraftauth/xbox/XboxLiveAuthenticationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,101:1\n1#2:102\n113#3:103\n96#4:104\n96#4:105\n*S KotlinDebug\n*F\n+ 1 XboxLiveAuthenticationService.kt\ngg/essential/minecraftauth/xbox/XboxLiveAuthenticationService\n*L\n79#1:103\n83#1:104\n94#1:105\n*E\n"})
public final class XboxLiveAuthenticationService {
    @NotNull
    public static final XboxLiveAuthenticationService INSTANCE = new XboxLiveAuthenticationService();
    @NotNull
    private static final String XBL_AUTHENTICATION_URI = "https://user.auth.xboxlive.com/user/authenticate";
    @NotNull
    private static final String XSTS_AUTHENTICATION_URI = "https://xsts.auth.xboxlive.com/xsts/authorize";

    private XboxLiveAuthenticationService() {
    }

    @NotNull
    public final XboxLiveTokenResponse authenticateWithXboxLive(@NotNull String accessToken) throws XboxLiveAuthenticationException {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        return this.makeRequest(XBL_AUTHENTICATION_URI, XboxLiveAuthenticationRequest.Companion.xboxLiveUser(accessToken));
    }

    @NotNull
    public final Pair<XboxLiveTokenResponse, String> authenticateWithXSTS(@NotNull String xblToken) throws XboxLiveAuthenticationException {
        List<Map<String, String>> list;
        XboxLiveTokenResponse response;
        block5: {
            block4: {
                Object object;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)xblToken, (String)"xblToken");
                    response = this.makeRequest(XSTS_AUTHENTICATION_URI, XboxLiveAuthenticationRequest.Companion.xsts(xblToken));
                    list = response.getDisplayClaims().get("xui");
                    if (list == null) break block4;
                    for (Map it : (Iterable)list) {
                        boolean bl = false;
                        String string = (String)it.get("uhs");
                        if (string == null) continue;
                        object = string;
                        break block3;
                    }
                    object = list = null;
                }
                if (object != null) break block5;
            }
            throw new XboxLiveAuthenticationException.MissingXboxLiveClaims();
        }
        List<Map<String, String>> userHash = list;
        return new Pair((Object)response, userHash);
    }

    private final XboxLiveTokenResponse makeRequest(String uri, XboxLiveAuthenticationRequest request2) throws XboxLiveAuthenticationException {
        Object $this$makeRequest_u24lambda_u243;
        Request.Builder builder = new Request.Builder().url(uri).header("Accept", "application/json");
        MediaType mediaType = HttpKt.getJSON_MEDIA_TYPE();
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.getJSON();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        Request request3 = builder.post(RequestBody.create(mediaType, $this$encodeToString$iv.encodeToString((SerializationStrategy)XboxLiveAuthenticationRequest.Companion.serializer(), (Object)request2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)request3, (String)"build(...)");
        Pair<Integer, String> pair = HttpKt.execute(request3);
        int status2 = ((Number)pair.component1()).intValue();
        String content = (String)pair.component2();
        if (status2 == 200) {
            Object $this$makeRequest_u24lambda_u241;
            Object object = this;
            try {
                $this$makeRequest_u24lambda_u241 = object;
                boolean bl = false;
                Json this_$iv = JsonKt.getJSON();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $this$makeRequest_u24lambda_u241 = Result.constructor-impl((Object)((XboxLiveTokenResponse)this_$iv.decodeFromString((DeserializationStrategy)XboxLiveTokenResponse.Companion.serializer(), content)));
            }
            catch (Throwable bl) {
                $this$makeRequest_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$makeRequest_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw new AuthenticationException.InvalidResponse(status2, content);
            }
            return (XboxLiveTokenResponse)object;
        }
        if (((CharSequence)content).length() == 0) {
            throw new AuthenticationException.InvalidCredentials();
        }
        Object object = this;
        try {
            $this$makeRequest_u24lambda_u243 = object;
            boolean bl = false;
            Json this_$iv = JsonKt.getJSON();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            $this$makeRequest_u24lambda_u243 = Result.constructor-impl((Object)((XboxLiveAuthenticationErrorResponse)this_$iv.decodeFromString((DeserializationStrategy)XboxLiveAuthenticationErrorResponse.Companion.serializer(), content)));
        }
        catch (Throwable bl) {
            $this$makeRequest_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$makeRequest_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new AuthenticationException.InvalidResponse(status2, content);
        }
        XboxLiveAuthenticationErrorResponse response = (XboxLiveAuthenticationErrorResponse)object;
        throw new XboxLiveAuthenticationException.XboxLiveError(response.getErrorCode());
    }
}

