/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.impl.client.gui;

import gg.essential.Essential;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.PixelConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.elementa.utils.TriConsumer;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.event.gui.GuiMouseReleaseEvent;
import gg.essential.gui.effects.AlphaEffect;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.transformers.client.gui.EntryListWidgetAccessor;
import gg.essential.mixins.transformers.client.gui.PackScreenAccessor;
import gg.essential.universal.UMath;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.USound;
import gg.essential.util.AdvancedDrawContext;
import gg.essential.util.HelpersKt;
import gg.essential.util.RenderGuiRenderStateToRenderTargetKt;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_11246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3281;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4267;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_521;
import net.minecraft.class_5352;
import net.minecraft.class_5369;
import net.minecraft.class_5375;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDragDropEntryHandler<E extends class_4280.class_4281<E>> {
    private final E indicatorEntry;
    private final class_437 screen;
    private final AlphaEffect alphaEffect = new AlphaEffect((State<Float>)new BasicState((Object)Float.valueOf(0.7f)));
    private final UIBlock alphaBlock = new UIBlock();
    private final Consumer<ScreenPosition> indicatorPositionUpdater;
    private final Consumer<GuiDrawScreenEvent> draggedEntryDrawAction;
    private final Runnable mouseReleaseAction;
    private final Runnable runForDrawChange;
    private final BiConsumer<E, Integer> onRevertedDrag;
    public final Runnable runForDataChange;
    public final Runnable runToUnselectEntries;
    private ResourceEntryDragState<E> draggedEntryState = null;
    private ResourceEntryDragState<E> pendingDraggedEntryState = null;
    private long prevTime = System.currentTimeMillis();
    private float deltaTimeLimitedByDragTime = 0.0f;

    public GuiDragDropEntryHandler(class_437 screen, Runnable runForDataChange, Runnable runForDrawChange, Runnable mouseReleaseAction, Consumer<ScreenPosition> indicatorPositionUpdater, Consumer<GuiDrawScreenEvent> draggedEntryDrawAction, BiConsumer<E, Integer> onRevertedDrag, Runnable runToUnselectEntries, E indicatorEntry) {
        this.indicatorEntry = indicatorEntry;
        this.runForDataChange = runForDataChange;
        this.runForDrawChange = runForDrawChange;
        this.screen = screen;
        this.onRevertedDrag = onRevertedDrag;
        this.runToUnselectEntries = runToUnselectEntries;
        this.alphaBlock.setParent((UIComponent)new Window(ElementaVersion.V7));
        this.alphaEffect.bindComponent((UIComponent)this.alphaBlock);
        this.alphaEffect.setup();
        this.draggedEntryDrawAction = draggedEntryDrawAction;
        this.indicatorPositionUpdater = indicatorPositionUpdater;
        this.mouseReleaseAction = mouseReleaseAction;
        Essential.EVENT_BUS.register(this);
    }

    @Subscribe
    private void onGuiMouseReleaseEvent(GuiMouseReleaseEvent event) {
        if (this.screen == event.getScreen()) {
            if (this.isDraggingEntry()) {
                this.mouseReleaseAction.run();
            } else if (this.isPendingDrag()) {
                this.pendingDraggedEntryState = null;
            }
        }
    }

    @Subscribe
    private void onGuiDrawScreenEvent(GuiDrawScreenEvent.Priority event) {
        if (event.isPost() && this.screen == event.getScreen()) {
            if (this.isPendingDrag() && this.pendingDraggedEntryState.hasMouseMoved(event.getMouseX(), event.getMouseY())) {
                this.promotePendingDrag();
            }
            if (this.isDraggingEntry()) {
                this.processDeltaTimeForScrolling();
                this.draggedEntryDrawAction.accept(event);
            }
        }
    }

    public void processDeltaTimeForScrolling() {
        long currentTime = System.currentTimeMillis();
        this.deltaTimeLimitedByDragTime = (float)(currentTime - this.prevTime) / 1000.0f * UMath.clampFloat((float)(this.draggedEntryState.getDragTimeSeconds() / 1.25f), (float)0.0f, (float)1.0f);
        this.prevTime = currentTime;
    }

    public void close(@Nullable List<?> list, @Nullable List<?> otherList) {
        if (this.isDraggingEntry()) {
            this.revertDraggedEntryToOriginalContainer(list, otherList);
        }
        Essential.EVENT_BUS.unregister(this);
    }

    public boolean isIndicatorEntry(Object entry2) {
        return this.indicatorEntry == entry2;
    }

    public void setPendingDraggedEntryState(E entry2, List<E> originalContainer, double mouseXOffset, double mouseYOffset, int originalIndex, double mouseX, double mouseY, boolean mustReturnToOriginalList) {
        this.pendingDraggedEntryState = new ResourceEntryDragState<E>(entry2, originalContainer, mouseXOffset, mouseYOffset, originalIndex, mouseX, mouseY, mustReturnToOriginalList);
    }

    private void promotePendingDrag() {
        this.draggedEntryState = this.pendingDraggedEntryState;
        this.pendingDraggedEntryState = null;
        this.draggedEntryState.setStartTime();
        this.indicatorEntry.method_73383(this.draggedEntryState.entry.method_25364());
        this.draggedEntryState.originalContainer.set(this.draggedEntryState.originalIndex, this.indicatorEntry);
        this.runToUnselectEntries.run();
        this.runForDrawChange.run();
    }

    public boolean isDraggingEntry() {
        return this.draggedEntryState != null;
    }

    private boolean isPendingDrag() {
        return this.pendingDraggedEntryState != null;
    }

    public void placeDraggedEntryAtIndicatorOrReleaseToOrigin(@NotNull List<E> list, @Nullable List<E> otherList, @NotNull DataChangeReflector<E> dataChangeReflector, @NotNull TriConsumer<Boolean, E, Integer> setSelected) {
        List destination;
        if (list.contains(this.indicatorEntry)) {
            destination = list;
        } else if (otherList != null && otherList.contains(this.indicatorEntry)) {
            destination = otherList;
        } else {
            this.draggedEntryState.revertToOriginalContainer(this.onRevertedDrag);
            boolean toLeftList = this.draggedEntryState.originalContainer == list;
            Object entry2 = this.draggedEntryState.entry;
            int index2 = this.draggedEntryState.originalIndex;
            this.endDrag(false);
            setSelected.accept((Object)toLeftList, entry2, (Object)index2);
            return;
        }
        int index3 = destination.indexOf(this.indicatorEntry);
        destination.set(index3, this.draggedEntryState.entry);
        dataChangeReflector.reflectChanges(this.draggedEntryState.entry, this.draggedEntryState.originalIndex, index3, this.draggedEntryState.originalContainer == list, destination == list);
        Object entry3 = this.draggedEntryState.entry;
        this.endDrag(destination != this.draggedEntryState.originalContainer || index3 != this.draggedEntryState.originalIndex);
        setSelected.accept((Object)(destination == list ? 1 : 0), entry3, (Object)index3);
    }

    public void revertDraggedEntryToOriginalContainer(@Nullable List<?> list, @Nullable List<?> otherList) {
        this.draggedEntryState.revertToOriginalContainer(this.onRevertedDrag);
        this.clearListIndicators(list, otherList);
        this.endDrag(false);
    }

    private void endDrag(boolean dataChangesMade) {
        this.draggedEntryState.playDropSoundIfAllowed();
        this.draggedEntryState = null;
        if (dataChangesMade) {
            this.runForDataChange.run();
        }
        this.runForDrawChange.run();
    }

    public void drawDraggedEntryWithinBounds(GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int xBound, int yBound, int x2Bound, int y2Bound) {
        int x = event.getMouseX() - (int)this.draggedEntryState.mouseHoldOffset.x();
        int y = event.getMouseY() - (int)this.draggedEntryState.mouseHoldOffset.y();
        if (x < xBound) {
            x = xBound;
        }
        if (y < yBound) {
            y = yBound;
        }
        int x2 = x + width2 - 8 + padUIBlockWidth;
        int y2 = y + height2 + 2;
        if (x2 > x2Bound) {
            x = x2Bound - width2 + 8 - padUIBlockWidth;
            x2 = x2Bound;
        }
        if (y2 > y2Bound) {
            y = y2Bound - height2 - 2;
            y2 = y2Bound;
        }
        this.drawDraggedEntry(event, width2, height2, padUIBlockWidth, padEntryRenderWidth, x, y, x2, y2);
    }

    private void drawDraggedEntry(GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int x, int y, int x2, int y2) {
        ScreenPosition newDragCenter = new ScreenPosition((double)x + (double)width2 / 2.0, (double)y + (double)height2 / 2.0);
        boolean posChanged = this.draggedEntryState.updatePos(newDragCenter);
        AdvancedDrawContext.INSTANCE.drawImmediate(event.getDrawContext().getMc(), (Function1<? super UMatrixStack, Unit>)((Function1)matrixStack -> {
            this.doDrawDraggedEntry((UMatrixStack)matrixStack, event, width2, height2, padUIBlockWidth, padEntryRenderWidth, x, y, x2, y2);
            return Unit.INSTANCE;
        }));
        if (posChanged) {
            this.indicatorPositionUpdater.accept(this.getDragCenterPos());
        }
    }

    private void doDrawDraggedEntry(UMatrixStack matrixStack, GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int x, int y, int x2, int y2) {
        this.setUIBlockConstraints(this.alphaBlock, x - 2, y - 2, x + width2 - 8 + padUIBlockWidth, y + height2 + 2);
        this.alphaEffect.beforeDraw(matrixStack);
        Color backgroundColor2 = new Color(138, 178, 255, 72);
        Color outlineColor2 = new Color(229, 229, 229, 255);
        GuiDragDropEntryHandler.renderBackgroundWithBorder(width2, height2, padUIBlockWidth, x, y, x2, y2, matrixStack, backgroundColor2, outlineColor2);
        width2 += padEntryRenderWidth;
        class_11246 guiRenderState = new class_11246();
        class_332 context = new class_332(class_310.method_1551(), guiRenderState);
        int orgX = this.draggedEntryState.entry.method_46426();
        int orgY = this.draggedEntryState.entry.method_46427();
        int orgWidth = this.draggedEntryState.entry.method_25368();
        int orgHeight = this.draggedEntryState.entry.method_25364();
        this.draggedEntryState.entry.method_46421(x - 2);
        this.draggedEntryState.entry.method_46419(y - 2);
        this.draggedEntryState.entry.method_73381(width2 + 4);
        this.draggedEntryState.entry.method_73383(height2 + 4);
        this.draggedEntryState.entry.method_25343(context, event.getMouseX(), event.getMouseY(), true, event.getPartialTicks());
        this.draggedEntryState.entry.method_46421(orgX);
        this.draggedEntryState.entry.method_46419(orgY);
        this.draggedEntryState.entry.method_73381(orgWidth);
        this.draggedEntryState.entry.method_73383(orgHeight);
        RenderGuiRenderStateToRenderTargetKt.renderGuiRenderStateToRenderTarget(matrixStack, guiRenderState);
        this.alphaEffect.afterDraw(matrixStack);
    }

    private static void renderBackgroundWithBorder(int width2, int height2, int padWidth, int x, int y, int x2, int y2, UMatrixStack matrixStack, Color backgroundColor2, Color outlineColor2) {
        UIBlock.Companion.drawBlock(matrixStack, backgroundColor2, (double)(x - 1), (double)(y - 1), (double)(x + width2 - 9 + padWidth), (double)(y + height2 + 1));
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, (double)(x - 1), (double)(y - 2), (double)(x2 - 1), (double)(y - 1));
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, (double)(x - 1), (double)(y2 - 1), (double)(x2 - 1), (double)y2);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, (double)(x - 2), (double)(y - 2), (double)(x - 1), (double)y2);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, (double)(x2 - 1), (double)(y - 2), (double)x2, (double)y2);
    }

    public void scrollIfDraggingNearTopOrBottom(double yPos, class_350 list) {
        boolean canScrollDown;
        boolean canScrollUp = list.method_44387() > 0.0;
        boolean bl = canScrollDown = list.method_44387() < (double)list.method_44390();
        if (!canScrollUp && !canScrollDown) {
            return;
        }
        int top = list.method_46427();
        int bottom = list.method_55443();
        int itemHeight = ((EntryListWidgetAccessor)list).essential$getItemHeight();
        float scrollAreaSize = (int)((float)itemHeight * 1.3f);
        float scrollAreaBottom = UMath.clampFloat((float)(scrollAreaSize / (float)(bottom - top)), (float)0.0f, (float)0.5f);
        float scrollAreaTop = 1.0f - scrollAreaBottom;
        float gradientTopToBottom = (float)class_3532.method_15350((double)((yPos - (double)top) / (double)(bottom - top)), (double)0.0, (double)1.0);
        if (gradientTopToBottom > scrollAreaTop || gradientTopToBottom < scrollAreaBottom) {
            if (canScrollUp && gradientTopToBottom < scrollAreaBottom) {
                float edgeProximityScaledAmount = (gradientTopToBottom - scrollAreaBottom) * 8.0f - 1.0f;
                edgeProximityScaledAmount *= edgeProximityScaledAmount * this.deltaTimeLimitedByDragTime * 64.0f;
                list.method_44382(list.method_44387() - (double)edgeProximityScaledAmount);
                this.indicatorPositionUpdater.accept(this.getDragCenterPos());
            } else if (canScrollDown && gradientTopToBottom > scrollAreaTop) {
                float edgeProximityScaledAmount = (gradientTopToBottom - scrollAreaTop) * 8.0f + 1.0f;
                edgeProximityScaledAmount *= edgeProximityScaledAmount * this.deltaTimeLimitedByDragTime * 64.0f;
                list.method_44382(list.method_44387() + (double)edgeProximityScaledAmount);
                this.indicatorPositionUpdater.accept(this.getDragCenterPos());
            }
        }
    }

    private void setUIBlockConstraints(UIBlock block, float x, float y, float x2, float y2) {
        block.setX((XConstraint)new PixelConstraint(x, false, false));
        block.setY((YConstraint)new PixelConstraint(y, false, false));
        block.setWidth((WidthConstraint)new PixelConstraint(x2 - x, false, false));
        block.setHeight((HeightConstraint)new PixelConstraint(y2 - y, false, false));
    }

    public void handleIndicatorForNonReorderingList(List<E> listThatWontReorder, @Nullable List<E> otherList) {
        if (this.draggedEntryState.mustReturnToOriginalList && listThatWontReorder != this.draggedEntryState.originalContainer) {
            if (this.clearListIndicators(listThatWontReorder, otherList)) {
                this.runForDrawChange.run();
            }
            this.draggedEntryState.allowDropSound();
            return;
        }
        if (listThatWontReorder.contains(this.indicatorEntry)) {
            return;
        }
        this.draggedEntryState.allowDropSound();
        this.clearListIndicators(listThatWontReorder, otherList);
        if (listThatWontReorder == this.draggedEntryState.originalContainer) {
            listThatWontReorder.add(this.draggedEntryState.originalIndex, this.indicatorEntry);
        } else {
            listThatWontReorder.add(0, this.indicatorEntry);
        }
        this.runForDrawChange.run();
    }

    public void placeIndicatorInListAtIndex(List<E> list, int index2, @Nullable List<E> otherList, int immovableEntryCountStart, int immovableEntryCountEnd) {
        if (this.draggedEntryState.mustReturnToOriginalList && list != this.draggedEntryState.originalContainer) {
            if (this.clearListIndicators(list, otherList)) {
                this.runForDrawChange.run();
            }
            this.draggedEntryState.allowDropSound();
            return;
        }
        if (index2 == -1 || index2 >= list.size() - immovableEntryCountEnd) {
            index2 = list.size() - (list.contains(this.indicatorEntry) ? 1 : 0) - immovableEntryCountEnd;
        }
        if (index2 >= immovableEntryCountStart && index2 <= list.size()) {
            if (index2 < list.size() && this.indicatorEntry.equals(list.get(index2))) {
                return;
            }
            this.clearListIndicators(list, otherList);
            this.draggedEntryState.allowDropSound();
            if (index2 <= list.size() - immovableEntryCountEnd) {
                list.add(index2, this.indicatorEntry);
            }
            this.runForDrawChange.run();
        } else {
            if (this.clearListIndicators(list, otherList)) {
                this.runForDrawChange.run();
            }
            this.draggedEntryState.allowDropSound();
        }
    }

    public void placeIndicatorWhenOutsideOfLists(@Nullable List<?> list, @Nullable List<?> otherList) {
        this.draggedEntryState.allowDropSound();
        if (this.draggedEntryState.originalContainer.size() == this.draggedEntryState.originalIndex || this.draggedEntryState.originalContainer.get(this.draggedEntryState.originalIndex) != this.indicatorEntry) {
            this.clearListIndicators(list, otherList);
            this.draggedEntryState.originalContainer.add(this.draggedEntryState.originalIndex, this.indicatorEntry);
            this.runForDrawChange.run();
        }
    }

    private boolean clearListIndicators(@Nullable List<?> list, @Nullable List<?> otherList) {
        return (list != null && list.remove(this.indicatorEntry)) | (otherList != null && otherList.remove(this.indicatorEntry));
    }

    public ScreenPosition getDragCenterPos() {
        return this.draggedEntryState.getDragCenterPos();
    }

    public boolean isThisListTheDragOrigin(List<E> list) {
        return this.draggedEntryState != null && this.draggedEntryState.originalContainer == list;
    }

    public static class_4267.class_504 initServerIndicator(class_500 screen, class_4267 list) {
        class_4267 class_42672 = list;
        Objects.requireNonNull(class_42672);
        return new class_4267.class_4270(class_42672, screen, new class_642("nil", "nil", class_642.class_8678.field_45611)){
            {
                class_4267 class_42672 = x0;
                Objects.requireNonNull(class_42672);
                super(class_42672, screen, server);
            }

            public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            }
        };
    }

    public static class_521.class_4271 initResourcePackIndicator(class_5375 screen) {
        class_521 list;
        class_521 class_5212 = list = ((PackScreenAccessor)screen).essential$getAvailablePackList();
        Objects.requireNonNull(class_5212);
        return new class_521.class_4271(class_5212, class_310.method_1551(), list, new FakeIPack()){
            {
                class_521 class_5212 = x0;
                Objects.requireNonNull(class_5212);
                super(class_5212, client, widget, pack);
            }

            public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            }
        };
    }

    private static class ResourceEntryDragState<E extends class_4280.class_4281<E>> {
        private final E entry;
        private final ScreenPosition mouseHoldOffset;
        private final ScreenPosition mouseStartPos;
        private final List<E> originalContainer;
        private final int originalIndex;
        private long dragStartTime = -1L;
        private final boolean mustReturnToOriginalList;
        private boolean playDropSound = false;
        private ScreenPosition dragCenterPos;

        public ScreenPosition getDragCenterPos() {
            return this.dragCenterPos;
        }

        private ResourceEntryDragState(E entry2, List<E> originalContainer, double mouseXHoldOffset, double mouseYHoldOffset, int originalIndex, double mouseX, double mouseY, boolean mustReturnToOriginalList) {
            this.entry = entry2;
            this.originalContainer = originalContainer;
            this.mouseHoldOffset = new ScreenPosition(mouseXHoldOffset, mouseYHoldOffset);
            this.originalIndex = originalIndex;
            this.dragCenterPos = new ScreenPosition(mouseX, mouseY);
            this.mouseStartPos = new ScreenPosition(mouseX, mouseY);
            this.mustReturnToOriginalList = mustReturnToOriginalList;
        }

        public void allowDropSound() {
            this.playDropSound = true;
        }

        public void playDropSoundIfAllowed() {
            if (this.playDropSound) {
                USound.INSTANCE.playButtonPress();
            }
        }

        private void setStartTime() {
            this.dragStartTime = System.currentTimeMillis();
        }

        private boolean updatePos(ScreenPosition newPos) {
            if (!this.dragCenterPos.equals(newPos)) {
                this.dragCenterPos = newPos;
                return true;
            }
            return false;
        }

        private void revertToOriginalContainer(BiConsumer<E, Integer> onRevertedDrag) {
            this.originalContainer.add(this.originalIndex, this.entry);
            onRevertedDrag.accept(this.entry, this.originalIndex);
        }

        private boolean hasMouseMoved(double mouseX, double mouseY) {
            return !this.mouseStartPos.equalsInts((int)mouseX, (int)mouseY);
        }

        private float getDragTimeSeconds() {
            return (float)(System.currentTimeMillis() - this.dragStartTime) / 1000.0f;
        }
    }

    public static interface DataChangeReflector<E extends class_4280.class_4281<E>> {
        public void reflectChanges(E var1, int var2, int var3, boolean var4, boolean var5);
    }

    public static class ScreenPosition {
        private final double x;
        private final double y;

        public ScreenPosition(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScreenPosition that = (ScreenPosition)o;
            return this.x == that.x && this.y == that.y;
        }

        public boolean equalsInts(int x, int y) {
            return (int)this.x == x && (int)this.y == y;
        }
    }

    private static class FakeIPack
    implements class_5369.class_5371 {
        private FakeIPack() {
        }

        public class_2960 method_30286() {
            return HelpersKt.identifier("essential_dummy:drag_indicator");
        }

        public class_3281 method_29648() {
            return class_3281.field_14224;
        }

        public class_2561 method_29650() {
            return HelpersKt.textLiteral("essential$indicator");
        }

        public class_2561 method_29651() {
            return HelpersKt.textLiteral("essential$indicator");
        }

        public String method_48276() {
            return "nil";
        }

        public class_5352 method_29652() {
            return class_5352.field_25347;
        }

        public boolean method_29654() {
            return false;
        }

        public boolean method_29655() {
            return false;
        }

        public void method_29656() {
        }

        public void method_29657() {
        }

        public void method_29658() {
        }

        public void method_29659() {
        }

        public boolean method_29660() {
            return false;
        }

        public boolean method_29663() {
            return false;
        }

        public boolean method_29664() {
            return false;
        }
    }
}

