/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.bones;

import gg.essential.model.Bone;
import gg.essential.model.Bones;
import gg.essential.model.EnumPart;
import gg.essential.model.Side;
import gg.essential.model.Vector3;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.bones.BakedAnimations;
import gg.essential.model.bones.PoseKt;
import gg.essential.model.util.Quaternion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006\""}, d2={"Lgg/essential/model/bones/BedrockModelState;", "", "playerPose", "Lgg/essential/model/backend/PlayerPose;", "bakedAnimations", "Lgg/essential/model/bones/BakedAnimations;", "userOffset", "Lgg/essential/model/Vector3;", "side", "Lgg/essential/model/Side;", "hiddenBones", "", "", "visibleParts", "Lgg/essential/model/EnumPart;", "(Lgg/essential/model/backend/PlayerPose;Lgg/essential/model/bones/BakedAnimations;Lgg/essential/model/Vector3;Lgg/essential/model/Side;Ljava/util/Set;Ljava/util/Set;)V", "getBakedAnimations", "()Lgg/essential/model/bones/BakedAnimations;", "getHiddenBones", "()Ljava/util/Set;", "getPlayerPose", "()Lgg/essential/model/backend/PlayerPose;", "getSide", "()Lgg/essential/model/Side;", "getUserOffset", "()Lgg/essential/model/Vector3;", "getVisibleParts", "apply", "", "bones", "Lgg/essential/model/Bones;", "applyVisibility", "reset", "resetVisibility", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nBedrockModelState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockModelState.kt\ngg/essential/model/bones/BedrockModelState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1741#2,3:99\n1#3:102\n*S KotlinDebug\n*F\n+ 1 BedrockModelState.kt\ngg/essential/model/bones/BedrockModelState\n*L\n51#1:99,3\n*E\n"})
public final class BedrockModelState {
    @NotNull
    private final PlayerPose playerPose;
    @NotNull
    private final BakedAnimations bakedAnimations;
    @NotNull
    private final Vector3 userOffset;
    @Nullable
    private final Side side;
    @NotNull
    private final Set<String> hiddenBones;
    @NotNull
    private final Set<EnumPart> visibleParts;

    public BedrockModelState(@NotNull PlayerPose playerPose, @NotNull BakedAnimations bakedAnimations, @NotNull Vector3 userOffset, @Nullable Side side, @NotNull Set<String> hiddenBones, @NotNull Set<? extends EnumPart> visibleParts) {
        Intrinsics.checkNotNullParameter((Object)playerPose, (String)"playerPose");
        Intrinsics.checkNotNullParameter((Object)bakedAnimations, (String)"bakedAnimations");
        Intrinsics.checkNotNullParameter((Object)userOffset, (String)"userOffset");
        Intrinsics.checkNotNullParameter(hiddenBones, (String)"hiddenBones");
        Intrinsics.checkNotNullParameter(visibleParts, (String)"visibleParts");
        this.playerPose = playerPose;
        this.bakedAnimations = bakedAnimations;
        this.userOffset = userOffset;
        this.side = side;
        this.hiddenBones = hiddenBones;
        this.visibleParts = visibleParts;
    }

    @NotNull
    public final PlayerPose getPlayerPose() {
        return this.playerPose;
    }

    @NotNull
    public final BakedAnimations getBakedAnimations() {
        return this.bakedAnimations;
    }

    @NotNull
    public final Vector3 getUserOffset() {
        return this.userOffset;
    }

    @Nullable
    public final Side getSide() {
        return this.side;
    }

    @NotNull
    public final Set<String> getHiddenBones() {
        return this.hiddenBones;
    }

    @NotNull
    public final Set<EnumPart> getVisibleParts() {
        return this.visibleParts;
    }

    public final void apply(@NotNull Bones bones) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)bones, (String)"bones");
            PoseKt.applyPose(bones, this.playerPose);
            this.bakedAnimations.apply(bones);
            if (!Intrinsics.areEqual((Object)this.userOffset, (Object)Vector3.ZERO)) {
                for (Bone bone : bones.getByPart().values()) {
                    if (bone.getPart() == EnumPart.ROOT) continue;
                    bone.setUserOffsetX(this.userOffset.x);
                    bone.setUserOffsetY(this.userOffset.y);
                    bone.setUserOffsetZ(this.userOffset.z);
                }
            }
            this.applyVisibility(bones);
            Iterable $this$any$iv = this.bakedAnimations.getBakedBones();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BakedAnimations.BakedBone it = (BakedAnimations.BakedBone)element$iv;
                    boolean bl2 = false;
                    if (!it.getGimbal()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            Quaternion it = this.bakedAnimations.getEntityRotation();
            boolean bl3 = false;
            Quaternion entityRotation = Quaternion.copy$default(it, -it.getX(), -it.getY(), 0.0f, 0.0f, 12, null);
            bones.getRoot().propagateGimbal(Quaternion.Companion.getIdentity(), entityRotation);
        }
    }

    public final void reset(@NotNull Bones bones) {
        Intrinsics.checkNotNullParameter((Object)bones, (String)"bones");
        this.bakedAnimations.reset(bones);
        if (!Intrinsics.areEqual((Object)this.userOffset, (Object)Vector3.ZERO)) {
            for (Bone bone : bones.getByPart().values()) {
                if (bone.getPart() == EnumPart.ROOT) continue;
                bone.setUserOffsetX(0.0f);
                bone.setUserOffsetY(0.0f);
                bone.setUserOffsetZ(0.0f);
            }
        }
        this.resetVisibility(bones);
    }

    private final void applyVisibility(Bones bones) {
        for (Map.Entry<EnumPart, Bone> entry2 : bones.getByPart().entrySet()) {
            EnumPart part = entry2.getKey();
            Bone bone = entry2.getValue();
            bone.setVisible(this.visibleParts.contains((Object)part));
        }
        for (String hiddenBone : this.hiddenBones) {
            Bone bone = bones.get(hiddenBone);
            if (bone == null) continue;
            bone.setVisible(false);
        }
        bones.getRoot().propagateVisibility(true, this.side);
    }

    private final void resetVisibility(Bones bones) {
        Iterator<Object> iterator2 = bones.getByPart().entrySet().iterator();
        while (iterator2.hasNext()) {
            Bone bone = iterator2.next().getValue();
            bone.setVisible(null);
        }
        for (String hiddenBone : this.hiddenBones) {
            Bone bone = bones.get(hiddenBone);
            if (bone == null) continue;
            bone.setVisible(null);
        }
    }
}

