/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ClientConnectionDisconnectPacket;
import gg.essential.connectionmanager.common.packet.connection.ServerConnectionReconnectPacket;
import gg.essential.connectionmanager.common.packet.multiplayer.ServerMultiplayerJoinServerPacket;
import gg.essential.connectionmanager.common.packet.partner.ServerPartneredModsPopulatePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerUuidNameMapPacket;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.event.client.PostInitializationEvent;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.wardrobe.Wardrobe;
import gg.essential.handlers.MojangSkinManager;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mod.Skin;
import gg.essential.network.client.MinecraftHook;
import gg.essential.network.connectionmanager.CloseReason;
import gg.essential.network.connectionmanager.Connection;
import gg.essential.network.connectionmanager.ConnectionManagerKt;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.coins.CoinsManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.cosmetics.EmoteWheelManager;
import gg.essential.network.connectionmanager.cosmetics.OutfitManager;
import gg.essential.network.connectionmanager.cosmetics.PacketHandlers;
import gg.essential.network.connectionmanager.features.DisabledFeaturesManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ClientConnectionDisconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ServerConnectionReconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.mojang.ServerUuidNameMapPacketHandler;
import gg.essential.network.connectionmanager.handler.multiplayer.ServerMultiplayerJoinServerPacketHandler;
import gg.essential.network.connectionmanager.ice.IceManager;
import gg.essential.network.connectionmanager.ice.IceManagerMcImpl;
import gg.essential.network.connectionmanager.knownservers.KnownServersManager;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.network.connectionmanager.notices.CosmeticNotices;
import gg.essential.network.connectionmanager.notices.FriendRequestToastNoticeListener;
import gg.essential.network.connectionmanager.notices.GiftedCosmeticNoticeListener;
import gg.essential.network.connectionmanager.notices.NoticeBannerManager;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.connectionmanager.notices.PersistentToastNoticeListener;
import gg.essential.network.connectionmanager.notices.SaleNoticeManager;
import gg.essential.network.connectionmanager.notices.SocialMenuNewFriendRequestNoticeManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.profile.SuspensionDisconnectHandler;
import gg.essential.network.connectionmanager.relationship.RelationshipManager;
import gg.essential.network.connectionmanager.serverdiscovery.NewServerDiscoveryManager;
import gg.essential.network.connectionmanager.serverdiscovery.ServerDiscoveryManager;
import gg.essential.network.connectionmanager.skins.PlayerSkinLookup;
import gg.essential.network.connectionmanager.skins.SkinItem;
import gg.essential.network.connectionmanager.skins.SkinsManager;
import gg.essential.network.connectionmanager.social.RulesManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.network.connectionmanager.suspension.McSuspensionManager;
import gg.essential.network.connectionmanager.suspension.SuspensionManager;
import gg.essential.network.connectionmanager.telemetry.TelemetryManager;
import gg.essential.sps.McIntegratedServerManager;
import gg.essential.util.ModLoaderUtil;
import gg.essential.util.Multithreading;
import gg.essential.util.USession;
import gg.essential.util.lwjgl3.Lwjgl3Loader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionManager
extends ConnectionManagerKt {
    @NotNull
    final PacketHandlers packetHandlers = new PacketHandlers();
    @NotNull
    private final ReferenceHolder refHolder = new ReferenceHolderImpl();
    @NotNull
    private final MinecraftHook minecraftHook;
    @NotNull
    private final List<NetworkedManager> managers = new ArrayList<NetworkedManager>();
    @NotNull
    private final NoticesManager noticesManager;
    @NotNull
    private final DisabledFeaturesManager disabledFeaturesManager;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final RelationshipManager relationshipManager;
    @NotNull
    private final CosmeticsManager cosmeticsManager;
    @NotNull
    private final ChatManager chatManager;
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    @NotNull
    private final ServerDiscoveryManager serverDiscoveryManager;
    @NotNull
    private final SocialManager socialManager;
    @NotNull
    private final IceManager iceManager;
    @NotNull
    private final ScreenshotManager screenshotManager;
    @NotNull
    private final TelemetryManager telemetryManager;
    private CoinsManager coinsManager;
    private SkinsManager skinsManager;
    @NotNull
    private final OutfitManager outfitManager;
    @NotNull
    private final EmoteWheelManager emoteWheelManager;
    private NewServerDiscoveryManager newServerDiscoveryManager;
    private KnownServersManager knownServersManager;
    @NotNull
    private final CosmeticNotices cosmeticNotices;
    @NotNull
    private final SaleNoticeManager saleNoticeManager;
    @NotNull
    private final SocialMenuNewFriendRequestNoticeManager socialMenuNewFriendRequestNoticeManager;
    @NotNull
    private final NoticeBannerManager noticeBannerManager;
    private SuspensionManager suspensionManager;
    private RulesManager rulesManager;
    private boolean modsSent = false;
    private int previouslyConnectedProtocol = 1;

    public ConnectionManager(@NotNull MinecraftHook minecraftHook, File baseDir, Lwjgl3Loader lwjgl3, State<@Nullable McIntegratedServerManager> integratedServerManager) {
        this.minecraftHook = minecraftHook;
        this.subscriptionManager = new SubscriptionManager(this);
        this.managers.add(this.subscriptionManager);
        this.registerPacketHandler(ClientConnectionDisconnectPacket.class, new ClientConnectionDisconnectPacketHandler());
        this.registerPacketHandler(ServerConnectionReconnectPacket.class, new ServerConnectionReconnectPacketHandler());
        this.registerPacketHandler(ServerMultiplayerJoinServerPacket.class, new ServerMultiplayerJoinServerPacketHandler());
        this.registerPacketHandler(ServerUuidNameMapPacket.class, new ServerUuidNameMapPacketHandler());
        this.registerPacketHandler(ServerPartneredModsPopulatePacket.class, packet2 -> {
            ModLoaderUtil.populatePartnerMods(packet2.getMods());
            return Unit.INSTANCE;
        });
        this.noticesManager = new NoticesManager(this);
        this.managers.add(this.noticesManager);
        this.noticeBannerManager = new NoticeBannerManager(this.noticesManager);
        this.noticesManager.register(this.noticeBannerManager);
        this.noticesManager.register(new PersistentToastNoticeListener(this.noticesManager));
        this.disabledFeaturesManager = new DisabledFeaturesManager(this);
        this.managers.add(this.disabledFeaturesManager);
        this.cosmeticsManager = new CosmeticsManager(this, baseDir);
        this.managers.add(this.cosmeticsManager);
        this.managers.add(this.cosmeticsManager.getInfraEquippedOutfitsManager());
        this.cosmeticNotices = new CosmeticNotices(this.noticesManager, this.cosmeticsManager.getCosmeticsData());
        this.noticesManager.register(this.cosmeticNotices);
        this.saleNoticeManager = new SaleNoticeManager();
        this.noticesManager.register(this.saleNoticeManager);
        this.noticesManager.register(new GiftedCosmeticNoticeListener(this.noticesManager, this.cosmeticsManager.getCosmeticsData()));
        this.relationshipManager = new RelationshipManager(this);
        this.managers.add(this.relationshipManager);
        this.chatManager = new ChatManager(this);
        this.managers.add(this.chatManager);
        this.profileManager = new ProfileManager(this);
        this.managers.add(this.profileManager);
        this.spsManager = new SPSManager(this);
        this.managers.add(this.spsManager);
        this.serverDiscoveryManager = new ServerDiscoveryManager(this);
        this.managers.add(this.serverDiscoveryManager);
        this.socialManager = new SocialManager(this);
        this.managers.add(this.socialManager);
        this.noticesManager.register(new FriendRequestToastNoticeListener(this, this.noticesManager));
        this.socialMenuNewFriendRequestNoticeManager = new SocialMenuNewFriendRequestNoticeManager(this.noticesManager);
        this.noticesManager.register(this.socialMenuNewFriendRequestNoticeManager);
        this.iceManager = new IceManagerMcImpl(this, baseDir.toPath(), integratedServerManager, (Function1<? super UUID, Boolean>)((Function1)uuid -> {
            if (this.spsManager.getInvitedUsers().contains(uuid)) {
                return true;
            }
            McIntegratedServerManager server = (McIntegratedServerManager)integratedServerManager.getUntracked();
            if (server != null) {
                Set<UUID> whitelist = server.getWhitelist().getUntracked();
                return whitelist != null && whitelist.contains(uuid);
            }
            return false;
        }));
        this.screenshotManager = new ScreenshotManager(this, baseDir, lwjgl3);
        this.managers.add(this.screenshotManager);
        this.telemetryManager = new TelemetryManager(this);
        this.managers.add(this.telemetryManager);
        this.coinsManager = new CoinsManager(this);
        this.managers.add(this.coinsManager);
        this.skinsManager = new SkinsManager(this);
        this.managers.add(this.skinsManager);
        this.outfitManager = new OutfitManager(this, this.cosmeticsManager.getCosmeticsData(), this.cosmeticsManager.getUnlockedCosmetics(), this.cosmeticsManager.getInfraEquippedOutfitsManager(), StateKt.map(this.skinsManager.getSkins(), map2 -> MapsKt.mapValues((Map)map2, it -> ((SkinItem)it.getValue()).getSkin())));
        this.managers.add(this.outfitManager);
        gg.essential.gui.elementa.state.v2.StateKt.effect(this.refHolder, (Function1<? super Observer, Unit>)((Function1)observer -> {
            Skin skin2 = this.outfitManager.getEquippedSkin().get((Observer)observer);
            if (skin2 == null) {
                return Unit.INSTANCE;
            }
            USession session = USession.Companion.activeNow();
            PlayerSkinLookup.INSTANCE.put(session.getUuid(), skin2);
            MojangSkinManager skinManager = Essential.getInstance().getSkinManager();
            skinManager.queueSkin(session.getUuid(), skin2);
            if (Wardrobe.getInstance() == null) {
                skinManager.flushChangesAsync();
            }
            return Unit.INSTANCE;
        }));
        this.emoteWheelManager = new EmoteWheelManager(this, this.cosmeticsManager.getUnlockedCosmetics());
        this.managers.add(this.emoteWheelManager);
        this.knownServersManager = new KnownServersManager(this);
        this.managers.add(this.knownServersManager);
        this.newServerDiscoveryManager = new NewServerDiscoveryManager(this, this.knownServersManager, this.telemetryManager::enqueue);
        this.managers.add(this.newServerDiscoveryManager);
        this.suspensionManager = new McSuspensionManager(this);
        this.managers.add(this.suspensionManager);
        this.rulesManager = new RulesManager(this);
        this.managers.add(this.rulesManager);
        SuspensionDisconnectHandler.INSTANCE.setupEffects(this);
        PlayerSkinLookup.INSTANCE.register(this);
    }

    @NotNull
    public MinecraftHook getMinecraftHook() {
        return this.minecraftHook;
    }

    @NotNull
    public NoticesManager getNoticesManager() {
        return this.noticesManager;
    }

    @NotNull
    public DisabledFeaturesManager getDisabledFeaturesManager() {
        return this.disabledFeaturesManager;
    }

    @NotNull
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @NotNull
    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    @NotNull
    public CosmeticsManager getCosmeticsManager() {
        return this.cosmeticsManager;
    }

    @NotNull
    public ChatManager getChatManager() {
        return this.chatManager;
    }

    @NotNull
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NotNull
    public SPSManager getSpsManager() {
        return this.spsManager;
    }

    @NotNull
    public SocialManager getSocialManager() {
        return this.socialManager;
    }

    @NotNull
    public ScreenshotManager getScreenshotManager() {
        return this.screenshotManager;
    }

    @NotNull
    public IceManager getIceManager() {
        return this.iceManager;
    }

    @NotNull
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @NotNull
    public CoinsManager getCoinsManager() {
        return this.coinsManager;
    }

    @NotNull
    public SkinsManager getSkinsManager() {
        return this.skinsManager;
    }

    @NotNull
    public OutfitManager getOutfitManager() {
        return this.outfitManager;
    }

    @NotNull
    public EmoteWheelManager getEmoteWheelManager() {
        return this.emoteWheelManager;
    }

    @NotNull
    public NewServerDiscoveryManager getNewServerDiscoveryManager() {
        return this.newServerDiscoveryManager;
    }

    @NotNull
    public KnownServersManager getKnownServersManager() {
        return this.knownServersManager;
    }

    @NotNull
    public CosmeticNotices getCosmeticNotices() {
        return this.cosmeticNotices;
    }

    @NotNull
    public SaleNoticeManager getSaleNoticeManager() {
        return this.saleNoticeManager;
    }

    @NotNull
    public SocialMenuNewFriendRequestNoticeManager getSocialMenuNewFriendRequestNoticeManager() {
        return this.socialMenuNewFriendRequestNoticeManager;
    }

    @NotNull
    public NoticeBannerManager getNoticeBannerManager() {
        return this.noticeBannerManager;
    }

    @NotNull
    public SuspensionManager getSuspensionManager() {
        return this.suspensionManager;
    }

    @NotNull
    public RulesManager getRulesManager() {
        return this.rulesManager;
    }

    @Override
    public boolean isOpen() {
        Connection connection = this.connection;
        return connection != null && connection.isOpen();
    }

    public boolean isAuthenticated() {
        return this.connection != null;
    }

    @Override
    public void registerOnConnected(final @NotNull Function0<Unit> onConnected2) {
        this.managers.add(new NetworkedManager(){

            @Override
            public void onConnected() {
                onConnected2.invoke();
            }
        });
    }

    public <T extends Packet> void registerPacketHandler(Class<T> cls, PacketHandler<T> handler) {
        this.packetHandlers.register(cls, handler);
    }

    @Override
    public <T extends Packet> void registerPacketHandler(@NotNull Class<T> cls, final @NotNull Function1<? super T, Unit> handler) {
        this.registerPacketHandler(cls, new PacketHandler<T>(this){

            @Override
            protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull T packet2) {
                handler.invoke(packet2);
            }
        });
    }

    @Override
    protected void completeConnection(Connection connection) {
        this.connection = connection;
        this.getMutableConnectionUriState().set(connection.getURI().toString());
        for (NetworkedManager manager : this.managers) {
            manager.onConnected();
        }
        if (ModLoaderUtil.areModsLoaded.getUntracked().booleanValue() && !this.modsSent) {
            Multithreading.runAsync(() -> this.send(ModLoaderUtil.createModsAnnouncePacket()));
            this.modsSent = true;
        }
    }

    @Override
    protected void onClose() {
        if (this.connection != null) {
            this.previouslyConnectedProtocol = this.connection.getUsingProtocol();
            this.connection = null;
            this.getMutableConnectionUriState().set((String)((Function1)ignored -> null));
        }
        this.modsSent = false;
        JobKt.cancelChildren((CoroutineContext)this.getConnectionScope().getCoroutineContext(), (CancellationException)ExceptionsKt.CancellationException((String)"Connection closed.", null));
        for (NetworkedManager manager : this.managers) {
            manager.onDisconnect();
        }
    }

    @Deprecated
    public void send(@NotNull Packet packet2) {
        this.send(packet2, null);
    }

    @Override
    @Deprecated
    public void send(@NotNull Packet packet2, @Nullable Consumer<Optional<Packet>> responseCallback) {
        this.send(packet2, responseCallback, TimeUnit.SECONDS, 10L);
    }

    @Override
    @Deprecated
    public void send(@NotNull Packet packet2, @Nullable Consumer<Optional<Packet>> responseCallback, @Nullable TimeUnit timeoutUnit, @Nullable Long timeoutValue) {
        Connection connection = this.connection;
        if (connection == null || !connection.isOpen()) {
            if (responseCallback != null) {
                responseCallback.accept(Optional.empty());
            }
            return;
        }
        boolean wantsResponseHandling = responseCallback != null && timeoutUnit != null && timeoutValue != null;
        UUID packetId = packet2.getPacketUniqueId();
        packetId = wantsResponseHandling && packetId == null ? UUID.randomUUID() : packetId;
        packet2.setUniqueId(packetId);
        if (wantsResponseHandling) {
            this.packetHandlers.register(packetId, timeoutUnit, timeoutValue, responseCallback);
        }
        connection.send(packet2);
    }

    @Subscribe
    public void onPostInit(PostInitializationEvent event) {
        ModLoaderUtil.setModsLoaded();
        if (!this.modsSent && this.isAuthenticated()) {
            Multithreading.runAsync(() -> this.send(ModLoaderUtil.createModsAnnouncePacket()));
            this.modsSent = true;
        }
    }

    public ServerDiscoveryManager getServerDiscoveryManager() {
        return this.serverDiscoveryManager;
    }

    public void onTosRevokedOrEssentialDisabled() {
        if (this.isOpen()) {
            this.close(CloseReason.USER_TOS_REVOKED);
        }
        for (NetworkedManager manager : this.managers) {
            manager.resetState();
        }
    }

    @Override
    protected int getPreviouslyConnectedProtocol() {
        return this.previouslyConnectedProtocol;
    }

    public static enum Status {
        NO_TOS,
        ESSENTIAL_DISABLED,
        OUTDATED,
        USER_SUSPENDED,
        CANCELLED,
        ALREADY_CONNECTED,
        NO_RESPONSE,
        INVALID_RESPONSE,
        MOJANG_UNAUTHORIZED,
        GENERAL_FAILURE,
        SUCCESS;

    }
}

