/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.cosmetics;

import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsRevokePurchasePacket;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.mod.cosmetics.settings.CosmeticProperty;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ServerCosmeticsRevokePurchasePacketHandler
extends PacketHandler<ServerCosmeticsRevokePurchasePacket> {
    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticsRevokePurchasePacket packet2) {
        CosmeticsManager cosmeticsManager = connectionManager.getCosmeticsManager();
        cosmeticsManager.removeUnlockedCosmetics(packet2.getRevokedIds());
        for (String revokedId : packet2.getRevokedIds()) {
            Cosmetic cosmetic2 = cosmeticsManager.getCosmetic(revokedId);
            if (cosmetic2 == null) continue;
            Optional<CosmeticProperty> requiresUnlockAction = cosmetic2.getProperties().stream().filter(cosmeticSetting -> cosmeticSetting instanceof CosmeticProperty.RequiresUnlockAction).findFirst();
            if (requiresUnlockAction.isPresent()) {
                this.sendExternalActionRevokedToast(cosmetic2, (CosmeticProperty.RequiresUnlockAction)requiresUnlockAction.get());
                return;
            }
            ExtensionsKt.warning(Notifications.INSTANCE, "Cosmetic revoked", String.format("Access to %s has been revoked because of a refund or chargeback.", cosmetic2.getDisplayName("en_us")));
        }
    }

    private void sendExternalActionRevokedToast(Cosmetic cosmetic2, CosmeticProperty.RequiresUnlockAction property2) {
        CosmeticProperty.RequiresUnlockAction.Data data = property2.getData();
        if (data instanceof CosmeticProperty.RequiresUnlockAction.Data.OpenLink) {
            String linkAddress = ((CosmeticProperty.RequiresUnlockAction.Data.OpenLink)property2.getData()).getLinkAddress();
            switch (cosmetic2.getId()) {
                case "ESSENTIAL_DISCORD_CAPE": {
                    ExtensionsKt.warning(Notifications.INSTANCE, "Discord Cosmetics revoked", "Access to Discord cosmetics have been revoked. You left or unlinked your account.");
                }
            }
        }
    }
}

