/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.serverdiscovery;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.serverdiscovery.ClientServerDiscoveryRequestPopulatePacket;
import gg.essential.connectionmanager.common.packet.serverdiscovery.ServerServerDiscoveryPopulatePacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.serverdiscovery.handler.ServerServerDiscoveryPopulatePacketHandler;
import gg.essential.serverdiscovery.model.ServerDiscovery;
import gg.essential.util.MinecraftUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerDiscoveryManager
implements NetworkedManager,
Iterable<ServerDiscovery> {
    @NotNull
    private final Map<String, ServerDiscovery> servers = Maps.newConcurrentMap();
    private Map<String, ServerDiscovery> serversByAddress;
    private Map<Pattern, ServerDiscovery> serversByRegexAddress;
    private final ConnectionManager connectionManager;

    public ServerDiscoveryManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(ServerServerDiscoveryPopulatePacket.class, new ServerServerDiscoveryPopulatePacketHandler(this));
    }

    @NotNull
    public Map<String, ServerDiscovery> getServers() {
        return this.servers;
    }

    @Nullable
    public ServerDiscovery getServer(@Nullable String id2) {
        return this.servers.get(id2);
    }

    public void addServers(@NotNull Collection<ServerDiscovery> servers) {
        for (ServerDiscovery serverDiscovery : servers) {
            this.addServer(serverDiscovery);
        }
    }

    public void addServer(@NotNull ServerDiscovery serverDiscovery) {
        this.servers.put(serverDiscovery.getId(), serverDiscovery);
        this.serversByAddress = null;
        this.serversByRegexAddress = null;
    }

    @Override
    @NotNull
    public Iterator<ServerDiscovery> iterator() {
        return this.servers.values().iterator();
    }

    @Nullable
    public ServerDiscovery findServerByAddress(String address) {
        ServerDiscovery exactMatch;
        if (this.serversByAddress == null || this.serversByRegexAddress == null) {
            this.serversByAddress = Maps.newHashMap();
            this.serversByRegexAddress = Maps.newHashMap();
            for (ServerDiscovery server : this.servers.values()) {
                for (String serverAddress : server.getAddresses()) {
                    if (serverAddress.startsWith("^") && serverAddress.endsWith("$")) {
                        this.serversByRegexAddress.put(Pattern.compile(serverAddress), server);
                        continue;
                    }
                    this.serversByAddress.put(serverAddress, server);
                }
            }
        }
        if ((exactMatch = this.serversByAddress.get(address)) != null) {
            return exactMatch;
        }
        for (Map.Entry<Pattern, ServerDiscovery> entry2 : this.serversByRegexAddress.entrySet()) {
            if (!entry2.getKey().matcher(address).matches()) continue;
            return entry2.getValue();
        }
        return null;
    }

    @NotNull
    public String normalizeAddress(@NotNull String address) {
        ServerDiscovery serverDiscovery = this.findServerByAddress(address);
        return serverDiscovery != null ? serverDiscovery.getAddresses().get(0) : address;
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.send(new ClientServerDiscoveryRequestPopulatePacket(MinecraftUtils.getCurrentProtocolVersion()));
    }

    @Override
    public void resetState() {
        this.servers.clear();
        this.serversByAddress = null;
        this.serversByRegexAddress = null;
    }
}

