/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.social;

import gg.essential.connectionmanager.common.model.profile.ProfilePunishmentStatus;
import gg.essential.gui.elementa.state.v2.ObservedInstant;
import gg.essential.network.connectionmanager.common.model.profile.PunishmentType;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lgg/essential/network/connectionmanager/social/ProfileSuspension;", "", "user", "Ljava/util/UUID;", "getUser", "()Ljava/util/UUID;", "isActive", "", "now", "Lgg/essential/gui/elementa/state/v2/ObservedInstant;", "isActiveNow", "Companion", "PermanentBan", "SocialBan", "Lgg/essential/network/connectionmanager/social/ProfileSuspension$PermanentBan;", "Lgg/essential/network/connectionmanager/social/ProfileSuspension$SocialBan;", "essential-gui-essential"})
public interface ProfileSuspension {
    @NotNull
    public static final Companion Companion = gg.essential.network.connectionmanager.social.ProfileSuspension$Companion.$$INSTANCE;

    @NotNull
    public UUID getUser();

    public boolean isActive(@NotNull ObservedInstant var1);

    public boolean isActiveNow();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lgg/essential/network/connectionmanager/social/ProfileSuspension$Companion;", "", "()V", "fromInfra", "Lgg/essential/network/connectionmanager/social/ProfileSuspension;", "user", "Ljava/util/UUID;", "punishment", "Lgg/essential/connectionmanager/common/model/profile/ProfilePunishmentStatus;", "essential-gui-essential"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ProfileSuspension fromInfra(@NotNull UUID user, @NotNull ProfilePunishmentStatus punishment) {
            ProfileSuspension profileSuspension;
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)punishment, (String)"punishment");
            PunishmentType punishmentType = punishment.getPunishmentType();
            switch (punishmentType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[punishmentType.ordinal()]) {
                case 1: {
                    profileSuspension = new PermanentBan(user);
                    break;
                }
                case 2: {
                    Long l = punishment.getExpiresAt();
                    if (l == null) {
                        l = 0L;
                    }
                    Instant instant = Instant.ofEpochMilli(((Number)l).longValue());
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                    profileSuspension = new SocialBan(user, instant);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return profileSuspension;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PunishmentType.values().length];
                try {
                    nArray[PunishmentType.PERMANENT_BAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PunishmentType.SOCIAL_BAN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lgg/essential/network/connectionmanager/social/ProfileSuspension$PermanentBan;", "Lgg/essential/network/connectionmanager/social/ProfileSuspension;", "user", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "getUser", "()Ljava/util/UUID;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isActive", "now", "Lgg/essential/gui/elementa/state/v2/ObservedInstant;", "isActiveNow", "toString", "", "essential-gui-essential"})
    public static final class PermanentBan
    implements ProfileSuspension {
        @NotNull
        private final UUID user;

        public PermanentBan(@NotNull UUID user) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            this.user = user;
        }

        @Override
        @NotNull
        public UUID getUser() {
            return this.user;
        }

        @Override
        public boolean isActive(@NotNull ObservedInstant now2) {
            Intrinsics.checkNotNullParameter((Object)now2, (String)"now");
            return true;
        }

        @Override
        public boolean isActiveNow() {
            return true;
        }

        @NotNull
        public final UUID component1() {
            return this.user;
        }

        @NotNull
        public final PermanentBan copy(@NotNull UUID user) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            return new PermanentBan(user);
        }

        public static /* synthetic */ PermanentBan copy$default(PermanentBan permanentBan, UUID uUID, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = permanentBan.user;
            }
            return permanentBan.copy(uUID);
        }

        @NotNull
        public String toString() {
            return "PermanentBan(user=" + this.user + ')';
        }

        public int hashCode() {
            return this.user.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PermanentBan)) {
                return false;
            }
            PermanentBan permanentBan = (PermanentBan)other;
            return Intrinsics.areEqual((Object)this.user, (Object)permanentBan.user);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lgg/essential/network/connectionmanager/social/ProfileSuspension$SocialBan;", "Lgg/essential/network/connectionmanager/social/ProfileSuspension;", "user", "Ljava/util/UUID;", "expiresAt", "Ljava/time/Instant;", "(Ljava/util/UUID;Ljava/time/Instant;)V", "getExpiresAt", "()Ljava/time/Instant;", "getUser", "()Ljava/util/UUID;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "isActive", "now", "Lgg/essential/gui/elementa/state/v2/ObservedInstant;", "isActiveNow", "toString", "", "essential-gui-essential"})
    public static final class SocialBan
    implements ProfileSuspension {
        @NotNull
        private final UUID user;
        @NotNull
        private final Instant expiresAt;

        public SocialBan(@NotNull UUID user, @NotNull Instant expiresAt) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)expiresAt, (String)"expiresAt");
            this.user = user;
            this.expiresAt = expiresAt;
        }

        @Override
        @NotNull
        public UUID getUser() {
            return this.user;
        }

        @NotNull
        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public boolean isActive(@NotNull ObservedInstant now2) {
            Intrinsics.checkNotNullParameter((Object)now2, (String)"now");
            return now2.isBefore(this.expiresAt);
        }

        @Override
        public boolean isActiveNow() {
            return this.expiresAt.isAfter(Instant.now());
        }

        @NotNull
        public final UUID component1() {
            return this.user;
        }

        @NotNull
        public final Instant component2() {
            return this.expiresAt;
        }

        @NotNull
        public final SocialBan copy(@NotNull UUID user, @NotNull Instant expiresAt) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)expiresAt, (String)"expiresAt");
            return new SocialBan(user, expiresAt);
        }

        public static /* synthetic */ SocialBan copy$default(SocialBan socialBan, UUID uUID, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = socialBan.user;
            }
            if ((n & 2) != 0) {
                instant = socialBan.expiresAt;
            }
            return socialBan.copy(uUID, instant);
        }

        @NotNull
        public String toString() {
            return "SocialBan(user=" + this.user + ", expiresAt=" + this.expiresAt + ')';
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = result * 31 + this.expiresAt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SocialBan)) {
                return false;
            }
            SocialBan socialBan = (SocialBan)other;
            if (!Intrinsics.areEqual((Object)this.user, (Object)socialBan.user)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiresAt, (Object)socialBan.expiresAt);
        }
    }
}

