/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.util.GuiEssentialPlatform;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgg/essential/util/AddressUtil;", "", "()V", "LOCAL_SERVER", "", "SINGLEPLAYER", "isLanOrLocalAddress", "", "address", "isSpecialFormattedAddress", "removeDefaultPort", "essential-gui-essential"})
public final class AddressUtil {
    @NotNull
    public static final AddressUtil INSTANCE = new AddressUtil();
    @NotNull
    public static final String SINGLEPLAYER = "Singleplayer";
    @NotNull
    public static final String LOCAL_SERVER = "Local Server";

    private AddressUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String removeDefaultPort(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return StringsKt.removeSuffix((String)address, (CharSequence)":25565");
    }

    @JvmStatic
    public static final boolean isLanOrLocalAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String host = (String)GuiEssentialPlatform.DefaultImpls.splitHostAndPort$default(GuiEssentialPlatform.Companion.getPlatform(), address, 0, 2, null).getFirst();
        if (StringsKt.equals((String)host, (String)"localhost", (boolean)true)) {
            return true;
        }
        InetAddress inetAddress = GuiEssentialPlatform.Companion.getPlatform().parseIpAddress(host);
        if (inetAddress != null) {
            InetAddress inetAddress2 = inetAddress;
            boolean bl = false;
            if (inetAddress2.isSiteLocalAddress() || inetAddress2.isLoopbackAddress()) {
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    public static final boolean isSpecialFormattedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return Intrinsics.areEqual((Object)address, (Object)SINGLEPLAYER) || Intrinsics.areEqual((Object)address, (Object)LOCAL_SERVER);
    }
}

