/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import gg.essential.event.render.RenderTickEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.util.AdvancedDrawContext;
import gg.essential.util.TemporaryTextureAllocator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_10366;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11278;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lgg/essential/util/AdvancedDrawContext;", "Ljava/lang/AutoCloseable;", "<init>", "()V", "", "close", "Lnet/minecraft/class_332;", "context", "Lgg/essential/util/TemporaryTextureAllocator$TextureAllocation;", "texture", "draw", "(Lnet/minecraft/class_332;Lgg/essential/util/TemporaryTextureAllocator$TextureAllocation;)V", "Lkotlin/Function1;", "Lgg/essential/universal/UMatrixStack;", "block", "drawImmediate", "(Lnet/minecraft/class_332;Lkotlin/jvm/functions/Function1;)V", "drawToTexture", "(Lgg/essential/util/TemporaryTextureAllocator$TextureAllocation;Lkotlin/jvm/functions/Function1;)V", "Lgg/essential/event/render/RenderTickEvent;", "event", "nextFrame", "(Lgg/essential/event/render/RenderTickEvent;)V", "Lnet/minecraft/class_11278;", "allocatedProjectionMatrix", "Lnet/minecraft/class_11278;", "Lgg/essential/util/TemporaryTextureAllocator;", "textureAllocator", "Lgg/essential/util/TemporaryTextureAllocator;", "getTextureAllocator", "()Lgg/essential/util/TemporaryTextureAllocator;", "Essential 1.21.9-fabric"})
public final class AdvancedDrawContext
implements AutoCloseable {
    @NotNull
    public static final AdvancedDrawContext INSTANCE = new AdvancedDrawContext();
    @Nullable
    private static class_11278 allocatedProjectionMatrix;
    @NotNull
    private static final TemporaryTextureAllocator textureAllocator;

    private AdvancedDrawContext() {
    }

    @NotNull
    public final TemporaryTextureAllocator getTextureAllocator() {
        return textureAllocator;
    }

    public final void drawImmediate(@NotNull class_332 context, @NotNull Function1<? super UMatrixStack, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int width2 = UResolution.getViewportWidth();
        int height2 = UResolution.getViewportHeight();
        TemporaryTextureAllocator.TextureAllocation texture = textureAllocator.allocate(width2, height2);
        this.drawToTexture(texture, block);
        this.draw(context, texture);
    }

    public final void drawToTexture(@NotNull TemporaryTextureAllocator.TextureAllocation texture, @NotNull Function1<? super UMatrixStack, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int width2 = texture.getWidth();
        int height2 = texture.getHeight();
        float scaleFactor = (float)UResolution.getScaleFactor();
        class_11278 projectionMatrix = allocatedProjectionMatrix;
        if (projectionMatrix == null) {
            allocatedProjectionMatrix = projectionMatrix = new class_11278("pre-rendered screen", 1000.0f, 21000.0f, true);
        }
        GpuBufferSlice orgProjectionMatrixBuffer = RenderSystem.getProjectionMatrixBuffer();
        class_10366 orgProjectionType = RenderSystem.getProjectionType();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)projectionMatrix.method_71092((float)width2 / scaleFactor, (float)height2 / scaleFactor), (class_10366)class_10366.field_54954);
        GpuTextureView orgOutputColorTextureOverride = RenderSystem.outputColorTextureOverride;
        GpuTextureView orgOutputDepthTextureOverride = RenderSystem.outputDepthTextureOverride;
        RenderSystem.outputColorTextureOverride = texture.getTextureView();
        RenderSystem.outputDepthTextureOverride = texture.getDepthTextureView();
        UMatrixStack matrixStack = new UMatrixStack();
        matrixStack.translate(0.0f, 0.0f, -10000.0f);
        block.invoke((Object)matrixStack);
        RenderSystem.outputColorTextureOverride = orgOutputColorTextureOverride;
        RenderSystem.outputDepthTextureOverride = orgOutputDepthTextureOverride;
        RenderSystem.setProjectionMatrix((GpuBufferSlice)orgProjectionMatrixBuffer, (class_10366)orgProjectionType);
    }

    public final void draw(@NotNull class_332 context, @NotNull TemporaryTextureAllocator.TextureAllocation texture) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        int width2 = texture.getWidth();
        int height2 = texture.getHeight();
        float scaleFactor = (float)UResolution.getScaleFactor();
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_2960 identifier2 = class_2960.method_60655((String)"universalcraft", (String)"__tmp_texture__");
        textureManager.method_4616(identifier2, new class_1044(texture){
            {
                this.field_60597 = $texture.getTextureView();
            }

            public void close() {
            }
        });
        context.method_51448().pushMatrix();
        context.method_51448().scale(1.0f / scaleFactor, 1.0f / scaleFactor);
        context.method_25302(class_10799.field_59968, identifier2, 0, 0, 0.0f, (float)height2, width2, height2, width2, -height2, width2, height2);
        context.method_51448().popMatrix();
        textureManager.method_4615(identifier2);
    }

    @Subscribe
    public final void nextFrame(@NotNull RenderTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isPre()) {
            return;
        }
        textureAllocator.nextFrame();
    }

    @Override
    public void close() {
        textureAllocator.close();
    }

    public static final /* synthetic */ class_11278 access$getAllocatedProjectionMatrix$p() {
        return allocatedProjectionMatrix;
    }

    public static final /* synthetic */ void access$setAllocatedProjectionMatrix$p(class_11278 class_112782) {
        allocatedProjectionMatrix = class_112782;
    }

    static {
        textureAllocator = new TemporaryTextureAllocator((Function0<Unit>)((Function0)textureAllocator.1.INSTANCE));
    }
}

