/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.function.LongFunction;
import net.minecraft.class_2338;

public class Position2FloatMap {
    private final float defaultValue;
    private final LongFunction<float[]> defaultFunction;
    private final Long2ObjectMap<float[]> map = new Long2ObjectOpenHashMap();
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private float[] lastChunk = null;

    public Position2FloatMap() {
        this(0.0f);
    }

    public Position2FloatMap(float defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultFunction = defaultValue == 0.0f ? k -> new float[4096] : k -> {
            float[] array = new float[4096];
            Arrays.fill(array, defaultValue);
            return array;
        };
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public float get(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        float[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return this.defaultValue;
        }
        return array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16];
    }

    public void put(int x, int y, int z, float v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, yC, zC);
        array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16] = v;
    }

    public float add(int x, int y, int z, float v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, yC, zC);
        int n = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16;
        float f = array[n] + v;
        array[n] = f;
        return f;
    }

    public boolean min(int x, int y, int z, float v) {
        int index;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, yC, zC);
        if (v < array[index = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public boolean max(int x, int y, int z, float v) {
        int index;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, yC, zC);
        if (v > array[index = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    @Deprecated
    public void addAll(Position2FloatMap other) {
        for (Long2ObjectMap.Entry entry : other.map.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            float[] otherArray = (float[])entry.getValue();
            float[] thisArray = (float[])this.map.get(pos);
            if (thisArray == null) {
                this.map.put(pos, (Object)otherArray);
                continue;
            }
            for (int i = 0; i < 4096; ++i) {
                int n = i;
                thisArray[n] = thisArray[n] + otherArray[i];
            }
        }
    }

    public void forEachEntry(EntryConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
            float[] array = (float[])entry.getValue();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        float v;
                        if ((v = array[index++]) == this.defaultValue) continue;
                        consumer.consume(cx + x, cy + y, cz + z, v);
                    }
                }
            }
        }
    }

    public void forEachEntryUnary(EntryUnary unary) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
            float[] array = (float[])entry.getValue();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        float v = array[index];
                        if (v != this.defaultValue) {
                            array[index] = unary.apply(cx + x, cy + y, cz + z, v);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    @Deprecated
    public Long2ObjectMap<float[]> unsafeGetRawMap() {
        return this.map;
    }

    public float[] getChunk(int xC, int yC, int zC) {
        return this.getChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public float[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            float[] chunk = (float[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public float[] getOrCreateChunk(int xC, int yC, int zC) {
        return this.getOrCreateChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public float[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            float[] chunk = (float[])this.map.computeIfAbsent(pos, this.defaultFunction);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void consume(int var1, int var2, int var3, float var4);
    }

    @FunctionalInterface
    public static interface EntryUnary {
        public float apply(int var1, int var2, int var3, float var4);
    }
}

