/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.function.LongFunction;
import net.minecraft.class_1923;

public class Position2dToIntMap {
    private final int defaultValue;
    private final LongFunction<int[]> defaultFunction;
    private final Long2ObjectMap<int[]> map;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private int[] lastChunk = null;

    public Position2dToIntMap() {
        this(0);
    }

    public Position2dToIntMap(int defaultValue) {
        this(defaultValue, (Long2ObjectMap<int[]>)new Long2ObjectOpenHashMap());
    }

    public Position2dToIntMap(int defaultValue, Long2ObjectMap<int[]> map) {
        this.defaultValue = defaultValue;
        this.map = map;
        this.defaultFunction = defaultValue == 0 ? k -> new int[256] : k -> {
            int[] array = new int[256];
            Arrays.fill(array, defaultValue);
            return array;
        };
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public Position2dToIntMap copy() {
        Position2dToIntMap copy = new Position2dToIntMap(this.defaultValue);
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int[] array = (int[])entry.getValue();
            copy.map.put(entry.getLongKey(), (Object)Arrays.copyOf(array, array.length));
        }
        return copy;
    }

    @Deprecated
    public Long2ObjectMap<int[]> unsafeGetMap() {
        return this.map;
    }

    public int get(int x, int z) {
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getChunk(xC, zC);
        if (array == null) {
            return this.defaultValue;
        }
        return array[(x & 0xF) + (z & 0xF) * 16];
    }

    public void put(int x, int z, int v) {
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, zC);
        array[(x & 0xF) + (z & 0xF) * 16] = v;
    }

    public int add(int x, int z, int v) {
        if (v == 0) {
            return this.get(x, z);
        }
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, zC);
        int n = (x & 0xF) + (z & 0xF) * 16;
        int n2 = array[n] + v;
        array[n] = n2;
        return n2;
    }

    public int binaryAnd(int x, int z, int v) {
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, zC);
        int n = (x & 0xF) + (z & 0xF) * 16;
        int n2 = array[n] & v;
        array[n] = n2;
        return n2;
    }

    public boolean min(int x, int z, int v) {
        int index;
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, zC);
        if (v < array[index = (x & 0xF) + (z & 0xF) * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public boolean max(int x, int z, int v) {
        int index;
        int xC = x >> 4;
        int zC = z >> 4;
        int[] array = this.getOrCreateChunk(xC, zC);
        if (v > array[index = (x & 0xF) + (z & 0xF) * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public void forEachEntry(TriIntConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int cz = class_1923.method_8332((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int v = ((int[])entry.getValue())[index++];
                    if (v == this.defaultValue) continue;
                    consumer.accept(cx + x, cz + z, v);
                }
            }
        }
    }

    public boolean removeIf(TriIntPredicate predicate) {
        boolean modified = false;
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int cz = class_1923.method_8332((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int[] array = (int[])entry.getValue();
                    int v = array[index];
                    if (v != this.defaultValue && predicate.test(cx + x, cz + z, v)) {
                        array[index] = this.defaultValue;
                        modified = true;
                    }
                    ++index;
                }
            }
        }
        return modified;
    }

    public class_1923 getLastChunk() {
        if (this.lastChunk != null && this.lastChunkPos != PositionUtils.MIN_POSITION_LONG) {
            return new class_1923(this.lastChunkPos);
        }
        if (!this.map.isEmpty()) {
            return new class_1923(this.map.keySet().iterator().nextLong());
        }
        return new class_1923(0, 0);
    }

    public int[] getChunk(int xC, int zC) {
        return this.getChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public int[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            int[] chunk = (int[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public int[] getOrCreateChunk(int xC, int zC) {
        return this.getOrCreateChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public int[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            int[] chunk = (int[])this.map.computeIfAbsent(pos, this.defaultFunction);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }
}

