/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.core_rendering;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomShader;
import com.moulberry.axiom.core_rendering.AxiomUniform;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_10789;
import net.minecraft.class_10799;
import net.minecraft.class_11219;
import net.minecraft.class_11282;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL11;

public class AxiomRenderer {
    private static final BlendFunction blendFunctionOneZeroOneZero = new BlendFunction(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
    private static final BlendFunction blendFunctionOneOneMinusSrcAlpha = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    private static GpuBufferSlice lastDynamicUniforms = null;
    private static float lastLineWidth = 1.0f;
    private static final Vector4f colour = new Vector4f();
    private static final class_11219 scissorState = new class_11219();

    public static void dirtyDynamicUniforms() {
        lastDynamicUniforms = null;
    }

    public static void setShaderColour(float r, float g2, float b, float a) {
        colour.set(r, g2, b, a);
        AxiomRenderer.dirtyDynamicUniforms();
    }

    public static void enableScissor(int x, int y, int width, int height) {
        scissorState.method_70814(x, y, width, height);
    }

    public static void disableScissor() {
        scissorState.method_70813();
    }

    private static void updateDynamicUniforms() {
        float currentLineWidth = RenderSystem.getShaderLineWidth();
        if (lastDynamicUniforms == null || lastLineWidth != currentLineWidth) {
            lastDynamicUniforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colour, (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        }
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, class_9801 meshData, boolean closeMeshData) {
        if (target == null) {
            target = class_310.method_1551().method_1522();
        }
        AxiomRenderer.renderPipelineWithUniforms(pipeline, target.method_71639(), target.field_1478 ? target.method_71640() : null, meshData, closeMeshData, Map.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderPipelineWithUniforms(AxiomRenderPipeline pipeline, GpuTextureView target, GpuTextureView depthTarget, class_9801 meshData, boolean closeMeshData, Map<String, AxiomUniform> uniforms) {
        if (meshData == null) {
            return;
        }
        try {
            VertexFormat.class_5595 indexType;
            GpuBuffer indexBuffer;
            VertexFormat vertexFormat = meshData.method_60822().comp_749();
            RenderPipeline renderPipeline = AxiomRenderer.setupPipeline(pipeline, vertexFormat, meshData.method_60822().comp_752());
            GpuBuffer vertexBuffer = vertexFormat.uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                indexBuffer = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                indexBuffer = vertexFormat.uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
            AxiomRenderer.updateDynamicUniforms();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Axiom Renderer", target, OptionalInt.empty(), depthTarget, OptionalDouble.empty());){
                renderPass.setPipeline(renderPipeline);
                renderPass.setVertexBuffer(0, vertexBuffer);
                AxiomRenderer.applyScissor(renderPass);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setUniform("DynamicTransforms", lastDynamicUniforms);
                for (int i = 0; i < 12; ++i) {
                    GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)i);
                    if (gpuTexture == null) continue;
                    renderPass.bindSampler("Sampler" + i, gpuTexture);
                }
                for (Map.Entry<String, AxiomUniform> entry : uniforms.entrySet()) {
                    renderPass.setUniform(entry.getKey(), entry.getValue().value());
                }
                renderPass.setIndexBuffer(indexBuffer, indexType);
                renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751(), 1);
            }
            AxiomRenderer.finish(pipeline);
        }
        finally {
            if (closeMeshData) {
                meshData.close();
            }
        }
    }

    private static void applyScissor(RenderPass renderPass) {
        if (scissorState.method_72091()) {
            renderPass.enableScissor(scissorState.method_72092(), scissorState.method_72093(), scissorState.method_72094(), scissorState.method_72095());
        }
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, AxiomDrawBuffer axiomDrawBuffer) {
        VertexFormat.class_5595 indexType;
        GpuBuffer indexBuffer;
        if (axiomDrawBuffer.vertexBuffer == null) {
            return;
        }
        if (target == null) {
            target = class_310.method_1551().method_1522();
        }
        RenderPipeline renderPipeline = AxiomRenderer.setupPipeline(pipeline, axiomDrawBuffer.vertexFormat, axiomDrawBuffer.vertexFormatMode);
        GpuBuffer vertexBuffer = axiomDrawBuffer.vertexBuffer;
        if (axiomDrawBuffer.indexBuffer == null) {
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)axiomDrawBuffer.vertexFormatMode);
            indexBuffer = autoStorageIndexBuffer.method_68274(axiomDrawBuffer.indexCount);
            indexType = autoStorageIndexBuffer.method_31924();
        } else {
            indexBuffer = axiomDrawBuffer.indexBuffer;
            indexType = axiomDrawBuffer.indexType;
        }
        AxiomRenderer.updateDynamicUniforms();
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Axiom Renderer", target.method_71639(), OptionalInt.empty(), target.field_1478 ? target.method_71640() : null, OptionalDouble.empty());){
            renderPass.setPipeline(renderPipeline);
            renderPass.setVertexBuffer(0, vertexBuffer);
            AxiomRenderer.applyScissor(renderPass);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", lastDynamicUniforms);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)i);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, gpuTexture);
            }
            renderPass.setIndexBuffer(indexBuffer, indexType);
            renderPass.drawIndexed(0, 0, axiomDrawBuffer.indexCount, 1);
        }
        AxiomRenderer.finish(pipeline);
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, List<AxiomDraw> axiomDraws) {
        if (axiomDraws.isEmpty()) {
            return;
        }
        if (target == null) {
            target = class_310.method_1551().method_1522();
        }
        ArrayList<RenderPass.class_10884> draws = new ArrayList<RenderPass.class_10884>();
        int maxSequentialIndex = 0;
        VertexFormat vertexFormat = null;
        VertexFormat.class_5596 vertexFormatMode = null;
        ArrayList<class_11282.class_11283> transforms = new ArrayList<class_11282.class_11283>();
        boolean hasIndividualUploads = true;
        for (AxiomDraw axiomDraw : axiomDraws) {
            VertexFormat.class_5595 indexType;
            GpuBuffer indexBuffer;
            AxiomDrawBuffer drawBuffer = axiomDraw.drawBuffer();
            if (drawBuffer.vertexBuffer == null) continue;
            vertexFormat = drawBuffer.vertexFormat;
            vertexFormatMode = drawBuffer.vertexFormatMode;
            if (drawBuffer.indexBuffer == null) {
                maxSequentialIndex = Math.max(maxSequentialIndex, drawBuffer.indexCount);
                indexBuffer = null;
                indexType = null;
            } else {
                indexBuffer = drawBuffer.indexBuffer;
                indexType = drawBuffer.indexType;
            }
            BiConsumer<GpuBufferSlice[], RenderPass.class_10885> consumer = null;
            if (axiomDraw.modelViewMatrix() != null || axiomDraw.modelOffset() != null) {
                transforms.add(new class_11282.class_11283((Matrix4fc)(axiomDraw.modelViewMatrix() != null ? axiomDraw.modelViewMatrix() : RenderSystem.getModelViewMatrix()), (Vector4fc)colour, (Vector3fc)(axiomDraw.modelOffset() != null ? axiomDraw.modelOffset() : new Vector3f()), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth()));
                int index = transforms.size() - 1;
                consumer = (slices, uploader) -> uploader.upload("DynamicTransforms", slices[index]);
            } else {
                hasIndividualUploads = false;
            }
            draws.add(new RenderPass.class_10884(0, drawBuffer.vertexBuffer, indexBuffer, indexType, 0, drawBuffer.indexCount, consumer));
        }
        if (draws.isEmpty()) {
            return;
        }
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer(vertexFormatMode);
        GpuBuffer fallbackIndexBuffer = maxSequentialIndex == 0 ? null : autoStorageIndexBuffer.method_68274(maxSequentialIndex);
        VertexFormat.class_5595 fallbackIndexType = maxSequentialIndex == 0 ? null : autoStorageIndexBuffer.method_31924();
        RenderPipeline renderPipeline = AxiomRenderer.setupPipeline(pipeline, vertexFormat, vertexFormatMode);
        if (!hasIndividualUploads) {
            AxiomRenderer.updateDynamicUniforms();
        }
        GpuBufferSlice[] gpuBufferSlices = RenderSystem.getDynamicUniforms().method_71107(transforms.toArray(new class_11282.class_11283[0]));
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Axiom Renderer", target.method_71639(), OptionalInt.empty(), target.field_1478 ? target.method_71640() : null, OptionalDouble.empty());){
            renderPass.setPipeline(renderPipeline);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)i);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, gpuTexture);
            }
            AxiomRenderer.applyScissor(renderPass);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            if (!hasIndividualUploads) {
                renderPass.setUniform("DynamicTransforms", lastDynamicUniforms);
            }
            renderPass.drawMultipleIndexed(draws, fallbackIndexBuffer, fallbackIndexType, gpuBufferSlices.length == 0 ? List.of() : List.of("DynamicTransforms"), (Object)gpuBufferSlices);
        }
        AxiomRenderer.finish(pipeline);
    }

    private static RenderPipeline setupPipeline(AxiomRenderPipeline pipeline, VertexFormat vertexFormat, VertexFormat.class_5596 mode) {
        RenderPipeline renderPipeline = pipeline.renderPipelines.get(mode);
        if (renderPipeline == null) {
            RenderPipeline.Builder builder;
            if (pipeline.shader == AxiomShader.LINES && mode != VertexFormat.class_5596.field_27377 && mode != VertexFormat.class_5596.field_27378) {
                throw new IllegalStateException("Lines shader must use LINES VertexFormat.Mode");
            }
            RenderPipeline.Snippet legacyWithColorSnippet = class_10799.field_60125;
            RenderPipeline.Snippet legacyWithoutColorSnippet = class_10799.field_60125;
            switch (pipeline.shader) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BLIT_SCREEN_OLD: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader(class_2960.method_60654((String)"axiom:core/blit_screen_old")).withFragmentShader(class_2960.method_60654((String)"axiom:core/blit_screen_old")).withSampler("Sampler0").withColorWrite(true, false).withVertexFormat(class_290.field_1585, mode);
                    break;
                }
                case LINES: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859});
                    break;
                }
                case POSITION_COLOR: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(class_290.field_1576, mode);
                    break;
                }
                case POSITION_TEX: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withSampler("Sampler0").withVertexFormat(class_290.field_1585, mode);
                    break;
                }
                case AXIOM_BLOCK: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader(class_2960.method_60654((String)"axiom:core/block")).withFragmentShader(class_2960.method_60654((String)"axiom:core/block")).withSampler("Sampler0").withVertexFormat(AxiomVertexFormats.AXIOM_BLOCK, mode);
                    break;
                }
                case POSITION_TEX_COLOR: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withSampler("Sampler0").withVertexFormat(class_290.field_1575, mode);
                    break;
                }
                case TERRAIN_SOLID: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853});
                    break;
                }
                case TERRAIN_CUTOUT: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853});
                    break;
                }
                case TERRAIN_CUTOUT_MIPPED: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853});
                    break;
                }
                case TERRAIN_TRANSLUCENT: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853}).withBlend(BlendFunction.TRANSLUCENT);
                    break;
                }
                case TERRAIN_TRIPWIRE: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56853}).withBlend(BlendFunction.TRANSLUCENT);
                    break;
                }
                case POSITION_COLOR_NO_VERTEX_COLOR: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithColorSnippet}).withVertexShader(class_2960.method_60654((String)"axiom:core/position_color_no_vertex_color")).withFragmentShader(class_2960.method_60654((String)"axiom:core/position_color_no_vertex_color")).withVertexFormat(class_290.field_1576, mode);
                    break;
                }
                case BIOME_OVERLAY: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithoutColorSnippet}).withVertexShader(class_2960.method_60654((String)"axiom:core/border")).withFragmentShader(class_2960.method_60654((String)"axiom:core/border")).withVertexFormat(AxiomVertexFormats.BORDER_VERTEX_FORMAT, mode);
                    break;
                }
                case COLLISION_MESH_OVERLAY: {
                    RenderPipeline.Builder builder2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{legacyWithoutColorSnippet}).withVertexShader(class_2960.method_60654((String)"axiom:core/collision_mesh")).withFragmentShader(class_2960.method_60654((String)"axiom:core/collision_mesh")).withVertexFormat(AxiomVertexFormats.COLLISION_MESH_VERTEX_FORMAT, mode);
                    break;
                }
                case BRIGHTEN_LIGHT_TEXTURE: {
                    RenderPipeline.Builder builder2 = builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withVertexShader("core/blit_screen").withFragmentShader(class_2960.method_60654((String)"axiom:core/brighten_lightmap")).withSampler("Sampler0").withUniform("MinBrightnessUBO", class_10789.field_60031).withVertexFormat(AxiomVertexFormats.BLIT_SCREEN, mode);
                }
            }
            if (pipeline.shader == AxiomShader.TERRAIN_SOLID || pipeline.shader == AxiomShader.TERRAIN_CUTOUT_MIPPED || pipeline.shader == AxiomShader.TERRAIN_TRANSLUCENT || pipeline.shader == AxiomShader.TERRAIN_TRIPWIRE) {
                textureManager = class_310.method_1551().method_1531();
                textureManager.method_4619(class_1059.field_5275).method_4527(false, true);
                AxiomRenderer.setTexture(0, class_1059.field_5275);
            } else if (pipeline.shader == AxiomShader.TERRAIN_CUTOUT) {
                textureManager = class_310.method_1551().method_1531();
                textureManager.method_4619(class_1059.field_5275).method_4527(false, false);
                AxiomRenderer.setTexture(0, class_1059.field_5275);
            }
            if (pipeline.polygonOffset != 0.0f) {
                builder.withDepthBias(pipeline.polygonOffset, pipeline.polygonOffset);
            }
            if (pipeline.blend) {
                switch (pipeline.blendFunction) {
                    case DEFAULT: {
                        builder.withBlend(BlendFunction.TRANSLUCENT);
                        break;
                    }
                    case ONE_ZERO: {
                        builder.withBlend(blendFunctionOneZeroOneZero);
                        break;
                    }
                    case ONE_ONE_MINUS_SRC_ALPHA: {
                        builder.withBlend(blendFunctionOneOneMinusSrcAlpha);
                    }
                }
            } else {
                builder.withoutBlend();
            }
            if ((double)pipeline.alphaCutout > 0.0) {
                builder.withShaderDefine("ALPHA_CUTOUT", pipeline.alphaCutout);
            }
            if (pipeline.depthTest) {
                if (pipeline.depthFunc == 519) {
                    builder.withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST);
                    builder.withDepthBias(-1000000.0f, -1000000.0f);
                } else {
                    DepthTestFunction function = switch (pipeline.depthFunc) {
                        case 514 -> DepthTestFunction.EQUAL_DEPTH_TEST;
                        case 513 -> DepthTestFunction.LESS_DEPTH_TEST;
                        case 516 -> DepthTestFunction.GREATER_DEPTH_TEST;
                        case 515 -> DepthTestFunction.LEQUAL_DEPTH_TEST;
                        default -> throw new RuntimeException("Unknown depthFunc: " + pipeline.depthFunc);
                    };
                    builder.withDepthTestFunction(function);
                }
            } else {
                builder.withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST);
            }
            builder.withDepthWrite(pipeline.depthWrite);
            builder.withCull(pipeline.cull);
            builder.withLocation(class_2960.method_60655((String)"axiom", (String)pipeline.name));
            renderPipeline = builder.build();
            if (!renderPipeline.getVertexFormat().equals((Object)vertexFormat)) {
                String error2 = "RenderPipeline has vertex format " + String.valueOf(renderPipeline.getVertexFormat()) + ", expected " + String.valueOf(vertexFormat);
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    throw new IllegalStateException(error2);
                }
                Axiom.LOGGER.error(error2);
            }
            pipeline.renderPipelines.put(mode, renderPipeline);
        }
        pipeline.shader.setupRenderState();
        if ((double)pipeline.lineWidth != 0.0) {
            RenderSystem.lineWidth((float)pipeline.lineWidth);
        }
        if (pipeline.disableFog) {
            RenderHelper.pushDisableFog();
        }
        if (pipeline.useLightLayer) {
            class_310.method_1551().field_1773.method_22974().method_3316();
        }
        GL11.glCullFace((int)pipeline.cullFace);
        return renderPipeline;
    }

    private static void finish(AxiomRenderPipeline pipeline) {
        pipeline.shader.clearRenderState();
        if (pipeline.disableFog) {
            RenderHelper.popDisableFog();
        }
        if (pipeline.useLightLayer) {
            class_310.method_1551().field_1773.method_22974().method_3315();
        }
        GL11.glCullFace((int)1029);
    }

    public static void setTexture(int binding, class_2960 resourceLocation) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        RenderSystem.setShaderTexture((int)binding, (GpuTextureView)textureManager.method_4619(resourceLocation).method_71659());
    }
}

