/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather.async;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.utils.Box;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class AsyncToolPatherUnique
implements AsyncToolPather {
    private final int[] sphere;
    private final int[][] cardinal;
    private final PositionSet positions;
    private final TriIntConsumer consumer;
    private final class_2338.class_2339 lastPosition = new class_2338.class_2339();
    protected final ArrayBlockingQueue<long[]> outputPositions = new ArrayBlockingQueue(128);

    public AsyncToolPatherUnique(BrushShape brushShape, TriIntConsumer consumer) {
        this.positions = new PositionSet();
        this.consumer = consumer;
        IntArrayList sphere = new IntArrayList();
        List<IntArrayList> cardinal = List.of(new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList(), new IntArrayList());
        Box bounding = brushShape.boundingBox();
        int minX = bounding.pos1().method_10263() - 1;
        int minY = bounding.pos1().method_10264() - 1;
        int minZ = bounding.pos1().method_10260() - 1;
        int maxX = bounding.pos2().method_10263() + 1;
        int maxY = bounding.pos2().method_10264() + 1;
        int maxZ = bounding.pos2().method_10260() + 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (brushShape.isInsideShape(x, y, z)) {
                        sphere.add(x);
                        sphere.add(y);
                        sphere.add(z);
                        continue;
                    }
                    for (class_2350 direction : class_2350.values()) {
                        int z2;
                        int y2;
                        int x2 = x - direction.method_10148();
                        if (!brushShape.isInsideShape(x2, y2 = y - direction.method_10164(), z2 = z - direction.method_10165())) continue;
                        IntList list = (IntList)cardinal.get(direction.method_10146());
                        list.add(x2);
                        list.add(y2);
                        list.add(z2);
                    }
                }
            }
        }
        this.sphere = sphere.toIntArray();
        this.cardinal = new int[6][];
        for (int i = 0; i < 6; ++i) {
            this.cardinal[i] = ((IntList)cardinal.get(i)).toIntArray();
        }
    }

    @Override
    public void update() {
        long[] positions;
        while ((positions = this.outputPositions.poll()) != null) {
            for (long position : positions) {
                this.consumer.accept(class_2338.method_10061((long)position), class_2338.method_10071((long)position), class_2338.method_10083((long)position));
            }
        }
    }

    @Override
    public void acceptInitial(long position) {
        int x = class_2338.method_10061((long)position);
        int y = class_2338.method_10071((long)position);
        int z = class_2338.method_10083((long)position);
        this.lastPosition.method_10103(x, y, z);
        LongArrayList outputs = new LongArrayList();
        for (int i = 0; i < this.sphere.length; i += 3) {
            int xo = this.sphere[i] + x;
            int yo = this.sphere[i + 1] + y;
            int zo = this.sphere[i + 2] + z;
            if (!this.positions.add(xo, yo, zo)) continue;
            outputs.add(class_2338.method_10064((int)xo, (int)yo, (int)zo));
        }
        if (!outputs.isEmpty()) {
            try {
                this.outputPositions.put(outputs.toLongArray());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(long[] positions) {
        int lastX = this.lastPosition.method_10263();
        int lastY = this.lastPosition.method_10264();
        int lastZ = this.lastPosition.method_10260();
        LongArrayList outputs = new LongArrayList();
        for (long position : positions) {
            int[] offsets;
            int x = class_2338.method_10061((long)position);
            int y = class_2338.method_10071((long)position);
            int z = class_2338.method_10083((long)position);
            int dx = x - lastX;
            int dy = y - lastY;
            int dz = z - lastZ;
            if (dx == 0) {
                if (dy == 0) {
                    if (dz == 1) {
                        offsets = this.cardinal[3];
                    } else {
                        if (dz != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[2];
                    }
                } else {
                    if (dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                    if (dy == 1) {
                        offsets = this.cardinal[1];
                    } else {
                        if (dy != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                        offsets = this.cardinal[0];
                    }
                }
            } else {
                if (dy != 0 || dz != 0) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                if (dx == 1) {
                    offsets = this.cardinal[5];
                } else {
                    if (dx != -1) throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
                    offsets = this.cardinal[4];
                }
            }
            for (int j = 0; j < offsets.length; j += 3) {
                int offsetX = offsets[j] + x;
                int offsetY = offsets[j + 1] + y;
                int offsetZ = offsets[j + 2] + z;
                if (!this.positions.add(offsetX, offsetY, offsetZ)) continue;
                outputs.add(class_2338.method_10064((int)offsetX, (int)offsetY, (int)offsetZ));
            }
            lastX = x;
            lastY = y;
            lastZ = z;
        }
        if (!outputs.isEmpty()) {
            try {
                this.outputPositions.put(outputs.toLongArray());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.lastPosition.method_10103(lastX, lastY, lastZ);
    }
}

