/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.ItemTransformAccessorExt;
import com.moulberry.axiom.hooks.LevelRendererExt;
import com.moulberry.axiom.hooks.MinecraftExt;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.InjectPoseVertexConsumer;
import com.moulberry.axiom.utils.EmptyBlockAndTintGetter;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_10868;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11687;
import net.minecraft.class_11788;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6367;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;

public class BlockRenderCache {
    private static final int MIN_CAPACITY = 32;
    private static final int MIN_AGE = 16;
    private static final int INFLOW_PER_TICK = 8;
    private static final int OUTFLOW_PER_TICK = 8;
    private static final List<class_6367> textureIdPool = new ArrayList<class_6367>();
    private static final Map<SizedBlock, RenderSlot> blockToRenderSlot = new HashMap<SizedBlock, RenderSlot>();
    private static RenderSlot head;
    private static RenderSlot tail;
    private static long currentTick;
    private static long nextTick;
    private static final Set<SizedBlock> desired;
    private static final Set<SizedBlock> desiredPriority;
    private static final class_1921 TRANSLUCENT;

    public static int request(CustomBlockState blockState, int width, int height, boolean priority) {
        GpuTextureView texture = BlockRenderCache.requestTexture(blockState, width, height, priority);
        return texture == null ? -1 : ((class_10868)texture.texture()).method_68427();
    }

    public static GpuTextureView requestTexture(CustomBlockState blockState, int width, int height, boolean priority) {
        SizedBlock sizedBlock = new SizedBlock(blockState.getVanillaState(), !(blockState instanceof class_2680), width, height);
        RenderSlot slot = blockToRenderSlot.get(sizedBlock);
        if (slot == null) {
            if (priority) {
                if (desiredPriority.size() >= 8) {
                    return null;
                }
                desiredPriority.add(sizedBlock);
                if (desiredPriority.size() + desired.size() > 8) {
                    Iterator<SizedBlock> iterator = desired.iterator();
                    iterator.next();
                    iterator.remove();
                }
            } else {
                if (desiredPriority.size() + desired.size() >= 8) {
                    return null;
                }
                desired.add(sizedBlock);
            }
            return null;
        }
        slot.lastRequestedTick = currentTick;
        if (slot != head) {
            slot.unlink();
            slot.next = head;
            BlockRenderCache.head.previous = slot;
            head = slot;
        }
        return slot.textureId.method_71639();
    }

    public static void tick() {
        ++nextTick;
    }

    public static void renderTick(class_332 guiGraphics) {
        if (currentTick == nextTick) {
            return;
        }
        currentTick = nextTick;
        RenderSystem.assertOnRenderThread();
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        desired.forEach(sizedBlock -> BlockRenderCache.renderSizedBlock(sizedBlock, guiGraphics));
        desiredPriority.forEach(sizedBlock -> BlockRenderCache.renderSizedBlock(sizedBlock, guiGraphics));
        desired.clear();
        desiredPriority.clear();
        int outflow = 0;
        while (outflow < 8 && blockToRenderSlot.size() > 32) {
            RenderSlot toRemove = tail;
            long age = currentTick - toRemove.lastRequestedTick;
            if (age >= -10L && age <= 16L) break;
            toRemove.unlink();
            RenderSlot removedSlot = blockToRenderSlot.remove(toRemove.key);
            if (removedSlot != toRemove) {
                throw new FaultyImplementationError();
            }
            textureIdPool.add(toRemove.textureId);
            ++outflow;
            int textureIdPoolSize = textureIdPool.size();
            if (textureIdPoolSize <= Math.max(32, blockToRenderSlot.size())) continue;
            for (int i = textureIdPoolSize - 1; i >= textureIdPoolSize / 2; --i) {
                class_6367 id = textureIdPool.remove(i);
                id.method_1238();
            }
        }
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }

    private static void renderItem(class_332 guiGraphics, class_1799 itemStack, class_4597.class_4598 multiBufferSource) {
        class_10444 itemStackRenderState = new class_10444();
        class_310 minecraft = class_310.method_1551();
        minecraft.method_65386().method_65598(itemStackRenderState, itemStack, class_811.field_4317, (class_1937)minecraft.field_1687, null, 0);
        if (!itemStackRenderState.method_65608()) {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
        } else {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
        }
        class_4587 poseStack = new class_4587();
        poseStack.method_46416(8.0f, 8.0f, 0.0f);
        poseStack.method_22905(16.0f, -16.0f, 16.0f);
        class_11661 storage = new class_11661();
        itemStackRenderState.method_65604(poseStack, (class_11659)storage, 0xF000F0, class_4608.field_21444, 0);
        for (class_11788 submitNodeCollection : storage.method_73532().values()) {
            new class_11687().method_73010(submitNodeCollection, multiBufferSource, null);
        }
        itemStackRenderState.method_65605();
    }

    private static void renderSizedBlock(SizedBlock sizedBlock, class_332 guiGraphics) {
        class_6367 target;
        if (textureIdPool.isEmpty()) {
            int w = sizedBlock.width;
            int h2 = sizedBlock.height;
            target = new class_6367(null, w, h2, true);
        } else {
            target = textureIdPool.remove(textureIdPool.size() - 1);
        }
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        bufferSource.method_22993();
        RenderHelper.tryFlush(guiGraphics);
        if (target.field_1482 != sizedBlock.width || target.field_1481 != sizedBlock.height) {
            int w = sizedBlock.width;
            int h3 = sizedBlock.height;
            target.method_1234(w, h3);
        }
        FramebufferUtils.clear((class_276)target, 0);
        ((MinecraftExt)class_310.method_1551()).axiom$pushMainRenderTarget((class_276)target);
        ((LevelRendererExt)class_310.method_1551().field_1769).axiom$pushTranslucentRenderTarget((class_276)target);
        class_1799 itemStack = new class_1799((class_1935)sizedBlock.state.method_26204().method_8389());
        ProjectionMatrixBackup projectionMatrixBackup = ProjectionMatrixBackup.create();
        RenderHelper.setOrthoProjectionMatrix(sizedBlock.width, sizedBlock.height);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        RenderHelper.pushModelViewStackWithIdentity();
        modelViewStack.translate(0.0f, 0.0f, -2000.0f);
        modelViewStack.scale((float)sizedBlock.width / 16.0f, (float)sizedBlock.height / 16.0f, 1.0f);
        RenderHelper.tryApplyModelViewMatrix();
        if (!sizedBlock.forceAsBlock && BlockRenderCache.shouldRenderAsItem(sizedBlock.state, itemStack)) {
            BlockRenderCache.renderItem(guiGraphics, itemStack, bufferSource);
        } else {
            try {
                BlockRenderCache.renderAsBlock(sizedBlock, bufferSource, modelViewStack);
            }
            catch (Exception e) {
                BlockRenderCache.renderItem(guiGraphics, itemStack, bufferSource);
            }
        }
        bufferSource.method_22993();
        RenderHelper.tryFlush(guiGraphics);
        RenderHelper.popModelViewStack();
        projectionMatrixBackup.restore();
        ((MinecraftExt)class_310.method_1551()).axiom$popMainRenderTarget();
        ((LevelRendererExt)class_310.method_1551().field_1769).axiom$popTranslucentRenderTarget();
        RenderSlot slot = new RenderSlot(sizedBlock, target, currentTick);
        if (head == null) {
            head = slot;
            tail = slot;
        } else {
            BlockRenderCache.head.previous = slot;
            slot.next = head;
            head = slot;
        }
        blockToRenderSlot.put(sizedBlock, slot);
    }

    private static void renderAsBlock(SizedBlock sizedBlock, class_4597.class_4598 bufferSource, Matrix4fStack modelViewStack) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(sizedBlock.state);
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        AxiomRenderer.setTexture(0, class_1059.field_5275);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        modelViewStack.translate(0.0f, 0.0f, 100.0f);
        modelViewStack.translate(8.0f, 8.0f, 0.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderHelper.tryApplyModelViewMatrix();
        class_4587 poseStack2 = new class_4587();
        poseStack2.method_22905(1.0f, -1.0f, 1.0f);
        class_804 transform = BlockRenderCache.getTransformsForBlock(sizedBlock.state);
        if (transform != class_804.field_4284) {
            transform.method_23075(false, poseStack2.method_23760());
            poseStack2.method_46416(0.5f, 0.5f, 0.5f);
        } else {
            poseStack2.method_22907((Quaternionfc)new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            poseStack2.method_22905(0.625f, 0.625f, 0.625f);
        }
        if (sizedBlock.state.method_26204() instanceof class_2510) {
            poseStack2.method_22907((Quaternionfc)new Quaternionf().rotateY(-1.5707964f));
        }
        poseStack2.method_46416(-0.5f, -0.5f, -0.5f);
        if (!BlockRenderCache.shouldShade(model, sizedBlock.state)) {
            RenderHelper.setupFlatLighting();
        }
        class_310.method_1551().method_1541().method_3353(sizedBlock.state, poseStack2, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444);
        bufferSource.method_22993();
        class_3610 fluid = sizedBlock.state.method_26227();
        if (!fluid.method_15769()) {
            class_1921 renderType = ChunkRenderOverrider.AxiomChunkOverrideLayer.fromVanilla((class_11515)class_4696.method_23680((class_3610)fluid)).isTranslucent ? TRANSLUCENT : class_1921.method_23577();
            class_4588 consumer = bufferSource.method_73477(renderType);
            class_310.method_1551().method_1541().method_3352(class_2338.field_10980, (class_1920)EmptyBlockAndTintGetter.INSTANCE, (class_4588)new InjectPoseVertexConsumer(poseStack2, consumer), sizedBlock.state, fluid);
        }
        bufferSource.method_22993();
        RenderHelper.setup3DLighting();
    }

    public static class_804 getTransformsForBlock(class_2680 blockState) {
        class_1792 item = blockState.method_26204().method_8389();
        if (item == class_1802.field_8162 || !(item instanceof class_1747)) {
            return class_804.field_4284;
        }
        class_1799 itemStack = new class_1799((class_1935)item);
        class_10444 itemStackRenderState = new class_10444();
        class_310.method_1551().method_65386().method_65598(itemStackRenderState, itemStack, class_811.field_4317, null, null, 0);
        return ((ItemTransformAccessorExt)itemStackRenderState).axiom$getTransform();
    }

    private static boolean shouldRenderAsItem(class_2680 state, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        if (state.method_31709() || state.method_26217() != class_2464.field_11458) {
            return true;
        }
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8638) {
            return false;
        }
        return state.method_28501().isEmpty() && state.method_26227().method_15769();
    }

    public static boolean shouldShade(class_1087 blockStateModel, class_2680 blockState) {
        class_5819 randomSource = class_5819.method_43047();
        for (class_10889 part : blockStateModel.method_68512(randomSource)) {
            for (class_2350 direction : class_2350.values()) {
                randomSource.method_43052(42L);
                for (class_777 quad : part.method_68509(direction)) {
                    if (!quad.comp_3725()) continue;
                    return true;
                }
            }
            randomSource.method_43052(42L);
            for (class_777 quad : part.method_68509(null)) {
                if (!quad.comp_3725()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        currentTick = 0L;
        nextTick = 0L;
        desired = new HashSet<SizedBlock>();
        desiredPriority = new HashSet<SizedBlock>();
        TRANSLUCENT = class_1921.method_24049((String)"axiom/block_render_cache/translucent", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)class_10799.field_56895, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23608(class_1921.field_21383).method_34577((class_4668.class_5939)class_1921.field_21376).method_23617(true));
    }

    private record SizedBlock(class_2680 state, boolean forceAsBlock, int width, int height) {
    }

    private static class RenderSlot {
        private RenderSlot previous;
        private RenderSlot next;
        private final SizedBlock key;
        private final class_6367 textureId;
        private long lastRequestedTick;

        public RenderSlot(SizedBlock key, class_6367 textureId, long lastRequestedTick) {
            this.key = key;
            this.textureId = textureId;
            this.lastRequestedTick = lastRequestedTick;
        }

        private void unlink() {
            if (this == head && this == tail) {
                head = null;
                tail = null;
            } else if (this == head) {
                this.next.previous = null;
                head = this.next;
            } else if (this == tail) {
                this.previous.next = null;
                tail = this.previous;
            } else {
                this.next.previous = this.previous;
                this.previous.next = this.next;
            }
            this.previous = null;
            this.next = null;
        }
    }
}

