/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.scaling;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import net.minecraft.class_2680;

public class Scale3x {
    private static boolean isSolid(class_2680 blockState) {
        return !blockState.method_45474();
    }

    private static boolean isSolidOrNonSolid(class_2680 blockState, boolean solid) {
        return !blockState.method_26215() && blockState.method_45474() != solid;
    }

    public static ChunkedBlockRegion scale3x(ChunkedBlockRegion in, boolean postProcessing) {
        ChunkedBlockRegion out = new ChunkedBlockRegion();
        PositionSet solid = new PositionSet();
        PositionSet nonSolid = new PositionSet();
        in.forEachEntry((x, y, z, block) -> {
            if (block.method_26215()) {
                return;
            }
            boolean isSolid = Scale3x.isSolid(block);
            PositionSet set = isSolid ? solid : nonSolid;
            boolean plusXAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x + 1, y, z), isSolid);
            boolean plusYAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y + 1, z), isSolid);
            boolean plusZAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y, z + 1), isSolid);
            boolean minusXAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x - 1, y, z), isSolid);
            boolean minusYAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y - 1, z), isSolid);
            boolean minusZAir = !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y, z - 1), isSolid);
            for (int xo = 0; xo < 3; ++xo) {
                for (int yo = 0; yo < 3; ++yo) {
                    for (int zo = 0; zo < 3; ++zo) {
                        set.add(x * 3 + xo, y * 3 + yo, z * 3 + zo);
                    }
                }
            }
            Scale3x.removeEdge(in, set, x, y, z, -1, 0, 0, 0, -1, 0, 0, 0, 1, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 1, 0, 0, 0, -1, 0, 0, 0, 1, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, -1, 0, 0, 0, 1, 0, 0, 0, 1, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 1, 0, 0, 0, 1, 0, 0, 0, 1, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, -1, 0, 0, 0, 0, -1, 0, 1, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 1, 0, 0, 0, 0, -1, 0, 1, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, -1, 0, 0, 0, 0, 1, 0, 1, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 1, 0, 0, 0, 0, 1, 0, 1, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 0, -1, 0, 0, 0, -1, 1, 0, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 0, 1, 0, 0, 0, -1, 1, 0, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 0, -1, 0, 0, 0, 1, 1, 0, 0, isSolid);
            Scale3x.removeEdge(in, set, x, y, z, 0, 1, 0, 0, 0, 1, 1, 0, 0, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, plusXAir, plusYAir, plusZAir, 1, 1, 1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, minusXAir, plusYAir, plusZAir, -1, 1, 1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, plusXAir, minusYAir, plusZAir, 1, -1, 1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, minusXAir, minusYAir, plusZAir, -1, -1, 1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, plusXAir, plusYAir, minusZAir, 1, 1, -1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, minusXAir, plusYAir, minusZAir, -1, 1, -1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, plusXAir, minusYAir, minusZAir, 1, -1, -1, isSolid);
            Scale3x.handleCorner(in, set, x, y, z, minusXAir, minusYAir, minusZAir, -1, -1, -1, isSolid);
        });
        PositionSet newSolid = new PositionSet();
        PositionSet newNonSolid = new PositionSet();
        in.forEachChunk((cx, cy, cz, blocks) -> {
            cx <<= 4;
            cy <<= 4;
            cz <<= 4;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 t2;
                        if ((t2 = blocks[index++]) == null || t2.method_26215()) {
                            Scale3x.addEdges(in, newSolid, cx + x, cy + y, cz + z, true);
                            Scale3x.addEdges(in, newNonSolid, cx + x, cy + y, cz + z, false);
                            continue;
                        }
                        if (!Scale3x.isSolid(t2)) {
                            Scale3x.addEdges(in, newSolid, cx + x, cy + y, cz + z, true);
                            continue;
                        }
                        Scale3x.addEdges(in, newNonSolid, cx + x, cy + y, cz + z, false);
                    }
                }
            }
        });
        newSolid.forEach(solid::add);
        newNonSolid.forEach(nonSolid::add);
        nonSolid.forEach((x, y, z) -> {
            class_2680 blockState = Scale3x.getBlockState(in, x, y, z, false);
            if (!blockState.method_26215()) {
                out.addBlockWithoutDirty(x, y, z, blockState);
            }
        });
        solid.forEach((x, y, z) -> {
            class_2680 blockState = Scale3x.getBlockState(in, x, y, z, true);
            if (!blockState.method_26215()) {
                out.addBlockWithoutDirty(x, y, z, blockState);
            }
        });
        out.dirtyAll();
        return out;
    }

    private static void addEdges(ChunkedBlockRegion in, PositionSet newSolid, int nx, int ny, int nz, boolean isSolid) {
        Scale3x.addEdge(in, newSolid, nx, ny, nz, -1, 0, 0, 0, -1, 0, 0, 0, 1, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 1, 0, 0, 0, -1, 0, 0, 0, 1, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, -1, 0, 0, 0, 1, 0, 0, 0, 1, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 1, 0, 0, 0, 1, 0, 0, 0, 1, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, -1, 0, 0, 0, 0, -1, 0, 1, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 1, 0, 0, 0, 0, -1, 0, 1, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, -1, 0, 0, 0, 0, 1, 0, 1, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 1, 0, 0, 0, 0, 1, 0, 1, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 0, -1, 0, 0, 0, -1, 1, 0, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 0, 1, 0, 0, 0, -1, 1, 0, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 0, -1, 0, 0, 0, 1, 1, 0, 0, isSolid);
        Scale3x.addEdge(in, newSolid, nx, ny, nz, 0, 1, 0, 0, 0, 1, 1, 0, 0, isSolid);
    }

    private static class_2680 getBlockState(ChunkedBlockRegion in, int x, int y, int z, boolean isSolid) {
        class_2680 state;
        int bx = Math.floorDiv(x, 3);
        int by = Math.floorDiv(y, 3);
        int bz = Math.floorDiv(z, 3);
        int xo = x - bx * 3 - 1;
        int yo = y - by * 3 - 1;
        int zo = z - bz * 3 - 1;
        class_2680 center = in.getBlockStateOrAir(bx, by, bz);
        int nonZero = Math.abs(xo) + Math.abs(yo) + Math.abs(zo);
        if (center.method_26215()) {
            if (nonZero == 1) {
                state = in.getBlockStateOrAir(bx + xo, by + yo, bz + zo);
                if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                    return state;
                }
            } else if (nonZero == 2) {
                class_2680 edge;
                class_2680 faceTwo;
                if (xo == 0) {
                    faceOne = in.getBlockStateOrAir(bx, by + yo, bz);
                    faceTwo = in.getBlockStateOrAir(bx, by, bz + zo);
                    edge = in.getBlockStateOrAir(bx, by + yo, bz + zo);
                } else if (yo == 0) {
                    faceOne = in.getBlockStateOrAir(bx + xo, by, bz);
                    faceTwo = in.getBlockStateOrAir(bx, by, bz + zo);
                    edge = in.getBlockStateOrAir(bx + xo, by, bz + zo);
                } else {
                    faceOne = in.getBlockStateOrAir(bx, by + yo, bz);
                    faceTwo = in.getBlockStateOrAir(bx + zo, by, bz);
                    edge = in.getBlockStateOrAir(bx + zo, by + yo, bz);
                }
                if (Scale3x.isSolidOrNonSolid(faceOne, isSolid) && faceOne == edge) {
                    return faceOne;
                }
                if (Scale3x.isSolidOrNonSolid(faceTwo, isSolid)) {
                    return faceTwo;
                }
                if (Scale3x.isSolidOrNonSolid(edge, isSolid)) {
                    return edge;
                }
            } else if (nonZero == 3) {
                neighborX = in.getBlockStateOrAir(bx + xo, by, bz);
                class_2680 neighborY = in.getBlockStateOrAir(bx, by + yo, bz);
                class_2680 neighborZ = in.getBlockStateOrAir(bx, by, bz + zo);
                if (Scale3x.isSolidOrNonSolid(neighborY, isSolid)) {
                    if (Scale3x.isSolidOrNonSolid(neighborX, isSolid) && neighborX == neighborZ) {
                        return neighborX;
                    }
                    return neighborY;
                }
                if (Scale3x.isSolidOrNonSolid(neighborX, isSolid)) {
                    return neighborX;
                }
                if (Scale3x.isSolidOrNonSolid(neighborZ, isSolid)) {
                    return neighborZ;
                }
            }
        } else if (nonZero == 2) {
            class_2680 edge;
            class_2680 faceTwo;
            if (xo == 0) {
                faceOne = in.getBlockStateOrAir(bx, by + yo, bz);
                faceTwo = in.getBlockStateOrAir(bx, by, bz + zo);
                edge = in.getBlockStateOrAir(bx, by + yo, bz + zo);
            } else if (yo == 0) {
                faceOne = in.getBlockStateOrAir(bx + xo, by, bz);
                faceTwo = in.getBlockStateOrAir(bx, by, bz + zo);
                edge = in.getBlockStateOrAir(bx + xo, by, bz + zo);
            } else {
                faceOne = in.getBlockStateOrAir(bx, by + yo, bz);
                faceTwo = in.getBlockStateOrAir(bx + zo, by, bz);
                edge = in.getBlockStateOrAir(bx + zo, by + yo, bz);
            }
            if (center == edge) {
                return center;
            }
            if (Scale3x.isSolidOrNonSolid(faceOne, isSolid) && faceOne == faceTwo) {
                return faceOne;
            }
        } else if (nonZero == 3) {
            neighborX = in.getBlockStateOrAir(bx + xo, by, bz);
            class_2680 neighborY = in.getBlockStateOrAir(bx, by + yo, bz);
            class_2680 neighborZ = in.getBlockStateOrAir(bx, by, bz + zo);
            if (center == neighborY || center == neighborX || center == neighborZ) {
                return center;
            }
            if (Scale3x.isSolidOrNonSolid(neighborY, isSolid)) {
                if (Scale3x.isSolidOrNonSolid(neighborX, isSolid) && neighborX == neighborZ) {
                    return neighborX;
                }
                if (neighborY == neighborX || neighborY == neighborZ) {
                    return neighborY;
                }
            } else if (Scale3x.isSolidOrNonSolid(neighborX, isSolid) && neighborX == neighborZ) {
                return neighborX;
            }
        }
        if (center.method_26215()) {
            state = in.getBlockStateOrAir(bx, by + 1, bz);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
            state = in.getBlockStateOrAir(bx, by - 1, bz);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
            state = in.getBlockStateOrAir(bx + 1, by, bz);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
            state = in.getBlockStateOrAir(bx - 1, by, bz);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
            state = in.getBlockStateOrAir(bx, by, bz + 1);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
            state = in.getBlockStateOrAir(bx, by, bz - 1);
            if (Scale3x.isSolidOrNonSolid(state, isSolid)) {
                return state;
            }
        }
        return center;
    }

    private static void handleCorner(ChunkedBlockRegion in, PositionSet set, int x, int y, int z, boolean airX, boolean airY, boolean airZ, int dirX, int dirY, int dirZ, boolean isSolid) {
        if (airX && airY && airZ && !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x, y + dirY, z + dirZ), isSolid) && !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x + dirX, y, z + dirZ), isSolid) && !Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x + dirX, y + dirY, z), isSolid)) {
            if (!Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(x + dirX, y + dirY, z + dirZ), isSolid)) {
                set.remove(x * 3 + 1 + dirX, y * 3 + 1 + dirY, z * 3 + 1 + dirZ);
            } else {
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX + 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX - 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY + 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY - 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY, z * 3 + 1 + dirZ + 1);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY, z * 3 + 1 + dirZ - 1);
                set.add(x * 3 + 1 + dirX + 1, y * 3 + 1 + dirY + 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX + 1, y * 3 + 1 + dirY - 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX - 1, y * 3 + 1 + dirY + 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX - 1, y * 3 + 1 + dirY - 1, z * 3 + 1 + dirZ);
                set.add(x * 3 + 1 + dirX + 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ + 1);
                set.add(x * 3 + 1 + dirX + 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ - 1);
                set.add(x * 3 + 1 + dirX - 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ + 1);
                set.add(x * 3 + 1 + dirX - 1, y * 3 + 1 + dirY, z * 3 + 1 + dirZ - 1);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY + 1, z * 3 + 1 + dirZ + 1);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY + 1, z * 3 + 1 + dirZ - 1);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY - 1, z * 3 + 1 + dirZ + 1);
                set.add(x * 3 + 1 + dirX, y * 3 + 1 + dirY - 1, z * 3 + 1 + dirZ - 1);
                set.add(x * 3 + 1 + 1, y * 3 + 1 + 1, z * 3 + 1);
                set.add(x * 3 + 1 + 1, y * 3 + 1 - 1, z * 3 + 1);
                set.add(x * 3 + 1 - 1, y * 3 + 1 + 1, z * 3 + 1);
                set.add(x * 3 + 1 - 1, y * 3 + 1 - 1, z * 3 + 1);
                set.add(x * 3 + 1 + 1, y * 3 + 1, z * 3 + 1 + 1);
                set.add(x * 3 + 1 + 1, y * 3 + 1, z * 3 + 1 - 1);
                set.add(x * 3 + 1 - 1, y * 3 + 1, z * 3 + 1 + 1);
                set.add(x * 3 + 1 - 1, y * 3 + 1, z * 3 + 1 - 1);
                set.add(x * 3 + 1, y * 3 + 1 + 1, z * 3 + 1 + 1);
                set.add(x * 3 + 1, y * 3 + 1 + 1, z * 3 + 1 - 1);
                set.add(x * 3 + 1, y * 3 + 1 - 1, z * 3 + 1 + 1);
                set.add(x * 3 + 1, y * 3 + 1 - 1, z * 3 + 1 - 1);
            }
        }
    }

    private static void addEdge(ChunkedBlockRegion in, PositionSet newSet, int nx, int ny, int nz, int edgeX1, int edgeY1, int edgeZ1, int edgeX2, int edgeY2, int edgeZ2, int edgeX3, int edgeY3, int edgeZ3, boolean isSolid) {
        if (Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1, ny + edgeY1, nz + edgeZ1), isSolid) && Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2, ny + edgeY2, nz + edgeZ2), isSolid)) {
            boolean minus1 = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 - edgeX3, ny + edgeY1 - edgeY3, nz + edgeZ1 - edgeZ3), isSolid);
            boolean minus2 = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2 - edgeX3, ny + edgeY2 - edgeY3, nz + edgeZ2 - edgeZ3), isSolid);
            boolean plus1 = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX3, ny + edgeY1 + edgeY3, nz + edgeZ1 + edgeZ3), isSolid);
            boolean plus2 = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2 + edgeX3, ny + edgeY2 + edgeY3, nz + edgeZ2 + edgeZ3), isSolid);
            if (!(minus1 && minus2 || plus1 && plus2)) {
                boolean minusBoth = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX2 - edgeX3, ny + edgeY1 + edgeY2 - edgeY3, nz + edgeZ1 + edgeZ2 - edgeZ3), isSolid);
                boolean plusBoth = Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX2 + edgeX3, ny + edgeY1 + edgeY2 + edgeY3, nz + edgeZ1 + edgeZ2 + edgeZ3), isSolid);
                if (!minusBoth && !plusBoth) {
                    newSet.add(nx * 3 + 1 + edgeX1 + edgeX2 - edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 - edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 - edgeZ3);
                    newSet.add(nx * 3 + 1 + edgeX1 + edgeX2, ny * 3 + 1 + edgeY1 + edgeY2, nz * 3 + 1 + edgeZ1 + edgeZ2);
                    newSet.add(nx * 3 + 1 + edgeX1 + edgeX2 + edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 + edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 + edgeZ3);
                    newSet.add(nx * 3 + 1 + edgeX1, ny * 3 + 1 + edgeY1, nz * 3 + 1 + edgeZ1);
                    newSet.add(nx * 3 + 1 + edgeX2, ny * 3 + 1 + edgeY2, nz * 3 + 1 + edgeZ2);
                    if (!minus1 && !plus1) {
                        newSet.add(nx * 3 + 1 + edgeX1 * 2 - edgeX3, ny * 3 + 1 + edgeY1 * 2 - edgeY3, nz * 3 + 1 + edgeZ1 * 2 - edgeZ3);
                        newSet.add(nx * 3 + 1 + edgeX1 * 2 + edgeX3, ny * 3 + 1 + edgeY1 * 2 + edgeY3, nz * 3 + 1 + edgeZ1 * 2 + edgeZ3);
                        newSet.add(nx * 3 + 1 + edgeX1 * 2 - edgeX2, ny * 3 + 1 + edgeY1 * 2 - edgeY2, nz * 3 + 1 + edgeZ1 * 2 - edgeZ2);
                    }
                    if (!minus2 && !plus2) {
                        newSet.add(nx * 3 + 1 + edgeX2 * 2 - edgeX3, ny * 3 + 1 + edgeY2 * 2 - edgeY3, nz * 3 + 1 + edgeZ2 * 2 - edgeZ3);
                        newSet.add(nx * 3 + 1 + edgeX2 * 2 + edgeX3, ny * 3 + 1 + edgeY2 * 2 + edgeY3, nz * 3 + 1 + edgeZ2 * 2 + edgeZ3);
                        newSet.add(nx * 3 + 1 + edgeX2 * 2 - edgeX1, ny * 3 + 1 + edgeY2 * 2 - edgeY1, nz * 3 + 1 + edgeZ2 * 2 - edgeZ1);
                    }
                    return;
                }
            }
            if (minus1 && minus2) {
                newSet.add(nx * 3 + 1 + edgeX1 + edgeX2 - edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 - edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 - edgeZ3);
            }
            newSet.add(nx * 3 + 1 + edgeX1 + edgeX2, ny * 3 + 1 + edgeY1 + edgeY2, nz * 3 + 1 + edgeZ1 + edgeZ2);
            if (plus1 && plus2) {
                newSet.add(nx * 3 + 1 + edgeX1 + edgeX2 + edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 + edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 + edgeZ3);
            }
        }
    }

    private static void removeEdge(ChunkedBlockRegion in, PositionSet set, int nx, int ny, int nz, int edgeX1, int edgeY1, int edgeZ1, int edgeX2, int edgeY2, int edgeZ2, int edgeX3, int edgeY3, int edgeZ3, boolean isSolid) {
        if (!(Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1, ny + edgeY1, nz + edgeZ1), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2, ny + edgeY2, nz + edgeZ2), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX2, ny + edgeY1 + edgeY2, nz + edgeZ1 + edgeZ2), isSolid))) {
            if (!(Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 - edgeX3, ny + edgeY1 - edgeY3, nz + edgeZ1 - edgeZ3), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2 - edgeX3, ny + edgeY2 - edgeY3, nz + edgeZ2 - edgeZ3), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX2 - edgeX3, ny + edgeY1 + edgeY2 - edgeY3, nz + edgeZ1 + edgeZ2 - edgeZ3), isSolid))) {
                set.remove(nx * 3 + 1 + edgeX1 + edgeX2 - edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 - edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 - edgeZ3);
            }
            set.remove(nx * 3 + 1 + edgeX1 + edgeX2, ny * 3 + 1 + edgeY1 + edgeY2, nz * 3 + 1 + edgeZ1 + edgeZ2);
            if (!(Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX3, ny + edgeY1 + edgeY3, nz + edgeZ1 + edgeZ3), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX2 + edgeX3, ny + edgeY2 + edgeY3, nz + edgeZ2 + edgeZ3), isSolid) || Scale3x.isSolidOrNonSolid(in.getBlockStateOrAir(nx + edgeX1 + edgeX2 + edgeX3, ny + edgeY1 + edgeY2 + edgeY3, nz + edgeZ1 + edgeZ2 + edgeZ3), isSolid))) {
                set.remove(nx * 3 + 1 + edgeX1 + edgeX2 + edgeX3, ny * 3 + 1 + edgeY1 + edgeY2 + edgeY3, nz * 3 + 1 + edgeZ1 + edgeZ2 + edgeZ3);
            }
        }
    }
}

