/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.script_brush;

import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.LuaHelper;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.script_brush.ScriptArgument;
import com.moulberry.axiom.tools.script_brush.ScriptBrushPresets;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.extension.texteditor.TextEditor;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

public class ScriptBrushTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final ChunkedBooleanRegion removeRegion = new ChunkedBooleanRegion();
    private boolean painting = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private final PresetWidget presetWidget = new PresetWidget(this::loadSettings, this::writeSettings, "script_brush", ScriptBrushPresets.getDefaultPresets());
    private final TextEditor luaEditor = new TextEditor();
    private String checkedScript = null;
    private Globals luaGlobals = null;
    private LuaFunction compiledScript = null;
    private final List<ScriptArgument> customArguments = new ArrayList<ScriptArgument>();
    private boolean executingOnce = false;
    private boolean ignoreMask = false;
    private long lastLuaCompile = 0L;
    private boolean luaDirty = false;
    public String luaExecutionError = null;
    private boolean scriptChanged = false;
    private static final String LUA_DESCRIPTION = "Create a brush using a Lua script\nFunction must return block\n\n" + LuaHelper.getAvailableLuaFunctions(true) + "\nCustom directives (put at start of script):\n$once$ -> apply the script to a specific point instead of a brush\n$ignoreMask$ -> affect all blocks regardless of mask (also ignores selection)\n";

    public ScriptBrushTool() {
        TextEditorLanguageDefinition lang = LuaHelper.createTextEditorLanguageDefinition(true);
        this.luaEditor.setLanguageDefinition(lang);
        this.luaEditor.setShowWhitespaces(false);
        this.luaEditor.setTabSize(4);
    }

    @Override
    public void reset() {
        if (this.painting) {
            this.painting = false;
            ChunkRenderOverrider.release("script_brush");
        }
        this.chunkedBlockRegion.clear();
        this.removeRegion.clear();
        this.luaGlobals = null;
        this.compiledScript = null;
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                if (this.checkedScript == null || this.checkedScript.isBlank()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!AxiomClient.hasPermission(AxiomPermission.CAN_IMPORT_BLOCKS) && this.checkedScript.replaceAll("local|function|return|if|for|then|end|and|or|nil|\\s", "").length() > 1000) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"The server has limited the maximum script brush size to 1000"), false);
                    return UserAction.ActionResult.USED_STOP;
                }
                this.compileScript();
                if (this.compiledScript == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.executingOnce) {
                    RayCaster.RaycastResult result = Tool.raycastBlock();
                    if (result != null) {
                        class_638 level = Objects.requireNonNull(class_310.method_1551().field_1687);
                        class_2680 blockState = level.method_8320(result.blockPos());
                        if (blockState.method_26204() == class_2246.field_10243) {
                            return UserAction.ActionResult.USED_STOP;
                        }
                        this.executeScriptAt(result.blockPos().method_10263(), result.blockPos().method_10264(), result.blockPos().method_10260(), null);
                        this.applyBlockRegionChange();
                        this.reset();
                    }
                } else {
                    AsyncToolPather pather = this.createToolPather(this.brushWidget.getBrushShape());
                    if (pather != null) {
                        if (!this.painting) {
                            this.painting = true;
                            ChunkRenderOverrider.acquire("script_brush");
                        }
                        this.pathProvider = new AsyncToolPathProvider(pather);
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.painting) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.luaGlobals != null) {
            LuaHelper.updateExtraVariables(this.luaGlobals);
        }
        if (!this.painting) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                if (!this.ignoreMask) {
                    Selection.render(camera, time, matrices, projection, 7);
                }
                return;
            }
            if (!this.ignoreMask) {
                Selection.render(camera, time, matrices, projection, 4);
            }
            if (this.executingOnce) {
                Tool.renderRaycastOverlay(result, matrices, camera);
            } else {
                this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
            }
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            this.applyBlockRegionChange();
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            if (!this.ignoreMask) {
                Selection.render(camera, time, matrices, projection, 4);
            }
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.removeRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
        }
    }

    private void compileScript() {
        this.compiledScript = null;
        this.luaGlobals = LuaHelper.createSandboxed();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        LuaHelper.initializeGeneric(this.luaGlobals, (x, y, z, blockState) -> {
            if (blockState.method_26215() && class_310.method_1551().field_1687 != null && !class_310.method_1551().field_1687.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z)).method_26215()) {
                ChunkRenderOverrider.setBlock(x, y, z, blockState);
                this.removeRegion.add(x, y, z);
            }
            this.chunkedBlockRegion.addBlock(x, y, z, blockState);
        });
        try {
            String resolvedScript = this.applyCustomArguments(this.checkedScript);
            this.compiledScript = LuaHelper.compile(resolvedScript, this.luaGlobals);
            this.luaExecutionError = null;
        }
        catch (LuaError luaError) {
            String message = luaError.getMessage();
            String[] splitMessage = message.split(":");
            this.luaExecutionError = splitMessage[splitMessage.length - 1];
        }
    }

    private void applyBlockRegionChange() {
        if (this.chunkedBlockRegion.isEmpty()) {
            return;
        }
        String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.modified", countString);
        RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription);
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        MaskElement destMask = this.ignoreMask ? new ConstantMaskElement(true) : MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (this.compiledScript != null) {
            return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                if (!destMask.test(maskContext.reset(), x, y, z) || this.compiledScript == null) {
                    return;
                }
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (blockState.method_26204() == class_2246.field_10243) {
                    return;
                }
                this.executeScriptAt(x, y, z, blockState);
            });
        }
        return null;
    }

    private void executeScriptAt(int x, int y, int z, class_2680 old) {
        LuaHelper.setPosition(this.luaGlobals, x, y, z);
        try {
            LuaValue value = this.compiledScript.call();
            if (value.isint()) {
                class_2680 outState = LuaHelper.internalIdToState(value.toint());
                if (outState != null) {
                    if (old != null && !old.method_26215() && outState.method_26215()) {
                        ChunkRenderOverrider.setBlock(x, y, z, outState);
                        this.removeRegion.add(x, y, z);
                    }
                    this.chunkedBlockRegion.addBlock(x, y, z, outState);
                }
            } else if (!value.isnil()) {
                this.luaExecutionError = "expected block or nil output, got " + value.typename() + " instead";
                this.reset();
            }
        }
        catch (LuaError luaError) {
            String message = luaError.getMessage();
            String[] splitMessage = message.split(":");
            this.luaExecutionError = splitMessage[splitMessage.length - 1];
            this.reset();
        }
    }

    @Override
    public void displayImguiOptions() {
        if (!this.executingOnce) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
            this.brushWidget.displayImgui();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(this.scriptChanged);
        this.scriptChanged = false;
        if (!this.customArguments.isEmpty()) {
            ImGuiHelper.separatorWithText("Arguments");
            for (int i = 0; i < this.customArguments.size(); ++i) {
                ScriptArgument customArgument = this.customArguments.get(i);
                customArgument.displayImgui(this.selectBlockWidget, i);
            }
        }
        this.renderLuaEditor();
    }

    private void renderLuaEditor() {
        long time;
        if (this.luaExecutionError != null) {
            ImGui.textColored(-16776961, "An error occurred while executing the script");
            ImGui.textWrapped(this.luaExecutionError);
            if (ImGui.button(AxiomI18n.get("axiom.generic.close"))) {
                this.luaExecutionError = null;
            }
            ImGui.separator();
        }
        ImGuiHelper.separatorWithText("Lua Script Brush (Hover for help)");
        ImGuiHelper.tooltip(LUA_DESCRIPTION);
        EditorUI.imguiGlfw.enableTabInput();
        this.luaEditor.render("TextEditor");
        EditorUI.imguiGlfw.disableTabInput();
        if (this.luaEditor.isTextChanged()) {
            this.luaDirty = true;
            this.scriptChanged = true;
        }
        if (this.luaDirty && (time = System.currentTimeMillis()) > this.lastLuaCompile + 250L) {
            this.lastLuaCompile = time;
            this.luaDirty = false;
            Globals globals = LuaHelper.createSandboxed();
            try {
                String script = this.luaEditor.getText();
                this.updateCustomArguments(script);
                String resolvedScript = this.applyCustomArguments(script);
                LuaValue luaValue = globals.load(resolvedScript, "main.lua");
                if (!luaValue.isfunction()) {
                    this.luaEditor.setErrorMarkers(Map.of(1, "not a function"));
                    this.checkedScript = null;
                } else {
                    this.luaEditor.setErrorMarkers(Map.of());
                    this.checkedScript = script;
                }
            }
            catch (LuaError luaError) {
                int totalLines;
                String message = luaError.getMessage();
                Pattern pattern = Pattern.compile(":(\\d+):");
                Matcher matcher = pattern.matcher(message);
                int line = 1;
                if (matcher.find()) {
                    line = Integer.parseInt(matcher.group(1));
                }
                if (line > (totalLines = this.luaEditor.getTotalLines())) {
                    line = totalLines;
                }
                String[] splitMessage = message.split(":");
                message = splitMessage[splitMessage.length - 1];
                this.luaEditor.setErrorMarkers(Map.of(line, message));
                this.checkedScript = null;
            }
        }
    }

    private void updateCustomArguments(String script) {
        this.executingOnce = script.contains("$once$");
        this.ignoreMask = script.contains("$ignoreMask$");
        Pattern pattern = Pattern.compile("\\$([^$()\n]+)(?:\\(([^$\n]*)\\))?\\$");
        Matcher matcher = pattern.matcher(script);
        int index = 0;
        while (matcher.find()) {
            ScriptArgument scriptArgument = ScriptArgument.parse(matcher.group(1), matcher.group(2));
            if (scriptArgument == null) continue;
            if (index >= this.customArguments.size()) {
                this.customArguments.add(scriptArgument);
            } else {
                ScriptArgument old = this.customArguments.get(index);
                if (old.type != scriptArgument.type || !old.name.equals(scriptArgument.name)) {
                    this.customArguments.set(index, scriptArgument);
                }
            }
            ++index;
        }
        while (this.customArguments.size() > index) {
            this.customArguments.remove(this.customArguments.size() - 1);
        }
    }

    private String applyCustomArguments(String script) {
        if (this.executingOnce) {
            script = script.replace("$once$", "-- $once$");
        }
        if (this.ignoreMask) {
            script = script.replace("$ignoreMask$", "-- $ignoreMask$");
        }
        Pattern pattern = Pattern.compile("\\$([^$()\n]+)(?:\\(([^$\n]*)\\))?\\$");
        Matcher matcher = pattern.matcher(script);
        AtomicInteger index = new AtomicInteger(0);
        return matcher.replaceAll(match -> {
            ScriptArgument defaultArgument = ScriptArgument.parse(matcher.group(1), matcher.group(2));
            if (defaultArgument != null) {
                int indexI = index.getAndIncrement();
                if (indexI >= this.customArguments.size()) {
                    return defaultArgument.toLuaString();
                }
                ScriptArgument customArgument = this.customArguments.get(indexI);
                if (customArgument.type == defaultArgument.type) {
                    return customArgument.toLuaString();
                }
                return defaultArgument.toLuaString();
            }
            return matcher.group().replace("$", "\\$");
        });
    }

    @Override
    public String listenForEsc() {
        if (!this.painting) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        if (this.executingOnce) {
            return false;
        }
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        if (this.executingOnce) {
            return mouseDelta;
        }
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.script_brush");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10582("Script", this.luaEditor.getText());
    }

    @Override
    public void loadSettings(class_2487 tag) {
        String script = tag.method_68564("Script", "");
        this.luaEditor.setText(script);
        this.customArguments.clear();
        this.executingOnce = false;
        this.luaDirty = true;
    }

    @Override
    public boolean showToolSmoothing() {
        return !this.executingOnce;
    }

    @Override
    public char iconChar() {
        return '\ue91f';
    }

    @Override
    public String keybindId() {
        return "script_brush";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_SCRIPTBRUSH, AxiomPermission.BUILD_SECTION);
    }
}

