/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.packets.AxiomServerboundRequestChunkData;
import com.moulberry.axiom.packets.AxiomServerboundRequestEntityData;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.modelling.ModellingTool;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.StringUtils;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.ChunkDataConsumer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.DispatchTask;
import com.moulberry.axiom.world_modification.DummyBuffer;
import com.moulberry.axiom.world_modification.EntityDataConsumer;
import com.moulberry.axiom.world_modification.HistoryBuffer;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.HistoryIO;
import com.moulberry.axiom.world_modification.UndoRedoTracer;
import com.moulberry.axiom.world_modification.undo.ModellingAdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8212;

public class Dispatcher {
    private static final long DATA_REQUEST_TIMEOUT_MILLIS = 60000L;
    private static final HistoryBuffer<SelectionHistoryElement> activeSelectionHistory = new HistoryBuffer();
    private static HistoryBuffer<BlockOrBiomeBuffer> history = new HistoryBuffer();
    private static int activeSelectionHistoryStart = 0;
    private static final Long2ObjectMap<ChunkDataConsumer> chunkDataCallbacks = new Long2ObjectOpenHashMap();
    private static final Long2LongOpenHashMap chunkDataTime = new Long2LongOpenHashMap();
    private static final Long2ObjectMap<PendingChunkData> pendingChunkData = new Long2ObjectOpenHashMap();
    private static final Long2ObjectMap<EntityDataConsumer> entityDataCallbacks = new Long2ObjectOpenHashMap();
    private static final Long2LongOpenHashMap entityDataTime = new Long2LongOpenHashMap();
    private static final Long2ObjectMap<PendingEntityData> pendingEntityData = new Long2ObjectOpenHashMap();
    private static final List<UndoRedoTracer> tracers = new ArrayList<UndoRedoTracer>();
    private static boolean shouldRemovePlacementOnStep;
    private static final List<DispatchTask> dispatchTasks;
    private static int availableDispatchSends;
    private static int delayDueToExhausedDispatchSends;
    public static String historyIdentifier;
    private static String pendingHistoryIdentifier;
    private static final boolean DO_DIRECT_SINGLEPLAYER_UPDATE = true;

    public static void reset() {
        pendingHistoryIdentifier = null;
        historyIdentifier = null;
        tracers.clear();
        history.clear();
        chunkDataCallbacks.clear();
        pendingChunkData.clear();
        activeSelectionHistory.clear();
        activeSelectionHistoryStart = 0;
        shouldRemovePlacementOnStep = false;
        dispatchTasks.clear();
        availableDispatchSends = 1;
        delayDueToExhausedDispatchSends = 0;
    }

    private static Path getHistoryPath() {
        return Axiom.getInstance().getConfigDirectory().resolve("history").resolve(StringUtils.sanitizePath(historyIdentifier));
    }

    public static void tryLoadHistory(String newHistoryIdentifier) {
        pendingHistoryIdentifier = newHistoryIdentifier;
    }

    private static void applyPendingHistory() {
        if (Objects.equals(pendingHistoryIdentifier, historyIdentifier)) {
            return;
        }
        historyIdentifier = pendingHistoryIdentifier;
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            history = HistoryIO.loadHistory(path);
        }
    }

    public static void addTracer(UndoRedoTracer tracer) {
        tracers.add(tracer);
    }

    public static void tick() {
        Dispatcher.applyPendingHistory();
        for (int i = 0; i < tracers.size(); ++i) {
            UndoRedoTracer tracer = tracers.get(i);
            if (!tracer.tick()) continue;
            tracers.remove(i);
            --i;
        }
        if (!chunkDataTime.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            LongArraySet removeWaitingChunks = new LongArraySet();
            for (Long2LongMap.Entry entry : chunkDataTime.long2LongEntrySet()) {
                long id = entry.getLongKey();
                if (!chunkDataCallbacks.containsKey(id)) {
                    removeWaitingChunks.add(id);
                    continue;
                }
                long time = entry.getLongValue();
                if (currentTime <= time) continue;
                removeWaitingChunks.add(id);
            }
            ObjectIterator objectIterator = removeWaitingChunks.iterator();
            while (objectIterator.hasNext()) {
                long id = (Long)objectIterator.next();
                pendingChunkData.remove(id);
                chunkDataCallbacks.remove(id);
                chunkDataTime.remove(id);
            }
            LongArraySet removeWaitingEntities = new LongArraySet();
            for (Long2LongMap.Entry entry : entityDataTime.long2LongEntrySet()) {
                long id = entry.getLongKey();
                if (!entityDataCallbacks.containsKey(id)) {
                    removeWaitingEntities.add(id);
                    continue;
                }
                long time = entry.getLongValue();
                if (currentTime <= time) continue;
                removeWaitingEntities.add(id);
            }
            ObjectIterator objectIterator2 = removeWaitingEntities.iterator();
            while (objectIterator2.hasNext()) {
                long id = (Long)objectIterator2.next();
                pendingEntityData.remove(id);
                entityDataCallbacks.remove(id);
                entityDataTime.remove(id);
            }
        }
        if (delayDueToExhausedDispatchSends > 0) {
            --delayDueToExhausedDispatchSends;
        } else {
            Dispatcher.runTasks();
        }
    }

    private static void addTask(DispatchTask dispatchTask) {
        dispatchTasks.add(dispatchTask);
        Dispatcher.runTasks();
    }

    public static void updateAvailableDispatchSends(int add, int max2) {
        availableDispatchSends = (int)Math.min((long)availableDispatchSends + (long)add, (long)max2);
    }

    private static void runTasks() {
        if (availableDispatchSends <= 0 || dispatchTasks.isEmpty()) {
            return;
        }
        delayDueToExhausedDispatchSends = 0;
        Iterator<DispatchTask> iterator = dispatchTasks.iterator();
        while (iterator.hasNext() && availableDispatchSends > 0) {
            DispatchTask dispatchTask = iterator.next();
            int sent = dispatchTask.tick(availableDispatchSends);
            availableDispatchSends -= sent;
            if (!dispatchTask.isDone()) break;
            iterator.remove();
        }
        if (availableDispatchSends <= 0) {
            delayDueToExhausedDispatchSends = 20;
        }
    }

    public static boolean exhaustedDispatchSends() {
        return availableDispatchSends <= 0 || delayDueToExhausedDispatchSends > 0;
    }

    public static void requestChunkData(LongSet blockEntities, LongSet chunkSections, boolean sendBlockEntitiesInChunks, ChunkDataConsumer callback) {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_CHUNK)) {
            callback.accept((Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectMap<class_2841<class_2680>>)new Long2ObjectOpenHashMap());
            return;
        }
        if (!AxiomClient.hasPermission(AxiomPermission.CHUNK_REQUESTBLOCKENTITY)) {
            blockEntities = LongSet.of();
            sendBlockEntitiesInChunks = false;
        }
        if (blockEntities.isEmpty() && chunkSections.isEmpty()) {
            callback.accept((Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectMap<class_2841<class_2680>>)new Long2ObjectOpenHashMap());
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            long id;
            while (chunkDataCallbacks.containsKey(id = ThreadLocalRandom.current().nextLong())) {
            }
            new AxiomServerboundRequestChunkData(id, (class_5321<class_1937>)level.method_27983(), blockEntities, chunkSections, sendBlockEntitiesInChunks).send();
            chunkDataCallbacks.put(id, (Object)callback);
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void finishRequestChunkData(long id, boolean finished, Long2ObjectMap<CompressedBlockEntity> compressedBlockEntityMap, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
        if (finished) {
            PendingChunkData pending = (PendingChunkData)pendingChunkData.remove(id);
            ChunkDataConsumer callback = (ChunkDataConsumer)chunkDataCallbacks.remove(id);
            chunkDataTime.remove(id);
            if (callback == null) {
                return;
            }
            if (pending != null) {
                pending.compressedBlockEntityMap.putAll(compressedBlockEntityMap);
                pending.chunkSections.putAll(chunkSections);
                callback.accept(pending.compressedBlockEntityMap, pending.chunkSections);
            } else {
                callback.accept(compressedBlockEntityMap, chunkSections);
            }
        } else if (pendingChunkData.containsKey(id)) {
            PendingChunkData pending = (PendingChunkData)pendingChunkData.get(id);
            pending.compressedBlockEntityMap.putAll(compressedBlockEntityMap);
            pending.chunkSections.putAll(chunkSections);
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        } else {
            pendingChunkData.put(id, (Object)new PendingChunkData(compressedBlockEntityMap, chunkSections));
            chunkDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void requestEntityData(List<UUID> entities, EntityDataConsumer callback) {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_ENTITY)) {
            callback.accept(new HashMap<UUID, class_2487>());
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            long id;
            while (entityDataCallbacks.containsKey(id = ThreadLocalRandom.current().nextLong())) {
            }
            new AxiomServerboundRequestEntityData(id, entities).send();
            entityDataCallbacks.put(id, (Object)callback);
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void finishRequestEntityData(long id, boolean finished, Map<UUID, class_2487> entityData) {
        if (finished) {
            PendingEntityData pending = (PendingEntityData)pendingEntityData.remove(id);
            EntityDataConsumer callback = (EntityDataConsumer)entityDataCallbacks.remove(id);
            entityDataTime.remove(id);
            if (callback == null) {
                return;
            }
            if (pending != null) {
                pending.entityData.putAll(entityData);
                callback.accept(pending.entityData);
            } else {
                callback.accept(entityData);
            }
        } else if (pendingEntityData.containsKey(id)) {
            PendingEntityData pending = (PendingEntityData)pendingEntityData.get(id);
            pending.entityData.putAll(entityData);
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        } else {
            pendingEntityData.put(id, (Object)new PendingEntityData(new HashMap<UUID, class_2487>(entityData)));
            entityDataTime.put(id, System.currentTimeMillis() + 60000L);
        }
    }

    public static void clear() {
        Dispatcher.applyPendingHistory();
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            HistoryIO.clear(path);
        }
        history.clear();
        Dispatcher.clearActiveSelectionHistory();
    }

    public static void push(HistoryEntry<BlockOrBiomeBuffer> entry) {
        Dispatcher.applyPendingHistory();
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (ClientEvents.c == 0) {
            String c = new String(new byte[]{104, 116, 116, 112, 115, 58, 47, 47, 97, 120, 105, 111, 109, 46, 109, 111, 117, 108, 98, 101, 114, 114, 121, 46, 99, 111, 109, 47, 97, 112, 105, 47, 109, 99, 97, 117, 116, 104, 47, 104, 97, 115, 95, 99, 111, 109, 109, 101, 114, 99, 105, 97, 108, 95, 108, 105, 99, 101, 110, 115, 101});
            ClientEvents.c = c.intern() == c ? 18000 : -1;
        }
        if (!AxiomClient.hasPermission(AxiomPermission.BUILD_SECTION)) {
            ChatUtils.error("Server hasn't given you permission to place blocks with Axiom");
            return;
        }
        int oldSize = history.getSize();
        history.push(entry);
        if (historyIdentifier != null) {
            Path path = Dispatcher.getHistoryPath();
            HistoryIO.pushEntry(path, entry, history.getPosition(), oldSize);
        }
        shouldRemovePlacementOnStep = entry.hasModifier(HistoryEntry.MODIFIER_CUT);
        Dispatcher.apply(entry.forwards(), false);
        Dispatcher.clearActiveSelectionHistory();
    }

    public static void pushActiveSelection(HistoryEntry<SelectionHistoryElement> entry) {
        if (activeSelectionHistory.getSize() == 0) {
            activeSelectionHistoryStart = history.getPosition();
        }
        activeSelectionHistory.push(entry);
        Selection.setShouldRenderSelection(true);
    }

    public static void clearActiveSelectionHistory() {
        activeSelectionHistory.clear();
    }

    private static int getActiveSelectionHistoryStart() {
        if (activeSelectionHistoryStart >= history.getSize()) {
            activeSelectionHistoryStart = history.getSize() - 1;
        }
        return activeSelectionHistoryStart;
    }

    public static int getHistoryPosition() {
        int selectionPosition = activeSelectionHistory.getPosition();
        if (selectionPosition >= 0) {
            return Dispatcher.getActiveSelectionHistoryStart() + selectionPosition + 1;
        }
        return history.getPosition();
    }

    public static void setHistoryPosition(int position) {
        block5: {
            int delta;
            block4: {
                delta = position - Dispatcher.getHistoryPosition();
                if (delta >= 0) break block4;
                if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
                    Placement.INSTANCE.stopPlacement();
                }
                for (int i = 0; i < -delta; ++i) {
                    Dispatcher.undo(false, false, false);
                }
                break block5;
            }
            if (delta <= 0) break block5;
            if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
                Placement.INSTANCE.stopPlacement();
            }
            for (int i = 0; i < delta; ++i) {
                Dispatcher.redo(false, false);
            }
        }
    }

    public static long getHistoryBytes() {
        return history.getSizeInBytes();
    }

    public static int getHistoryDataCount() {
        return activeSelectionHistory.getSize() + history.getSize();
    }

    public static HistoryData getHistoryData(int index) {
        if (index < 0) {
            return null;
        }
        int activeStart = Dispatcher.getActiveSelectionHistoryStart();
        if (index > activeStart) {
            int selectionIndex = index - activeStart - 1;
            if (selectionIndex >= activeSelectionHistory.getSize()) {
                index -= activeSelectionHistory.getSize();
            } else {
                return new HistoryData(activeSelectionHistory.getHistoryEntry(selectionIndex), selectionIndex, true);
            }
        }
        if (index >= history.getSize()) {
            return null;
        }
        return new HistoryData(history.getHistoryEntry(index), index, false);
    }

    public static void renderTracers(class_4587 matrices, class_4184 camera, float partialTick) {
        for (UndoRedoTracer tracer : tracers) {
            tracer.render(matrices, camera, partialTick);
        }
    }

    public static UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case UNDO: {
                Dispatcher.undo(true, true, !EditorUI.isActive());
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                Dispatcher.redo(true, !EditorUI.isActive());
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static void undo(boolean allowPlacement, boolean allowSelection, boolean fromIngame) {
        Dispatcher.applyPendingHistory();
        if (!AxiomClient.hasPermission(AxiomPermission.BUILD_SECTION)) {
            ChatUtils.error("Server hasn't given you permission to place blocks with Axiom");
            return;
        }
        if (shouldRemovePlacementOnStep) {
            Placement.INSTANCE.stopPlacement();
            shouldRemovePlacementOnStep = false;
        } else if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
            Placement.INSTANCE.stopPlacement();
            return;
        }
        HistoryEntry<SelectionHistoryElement> selectionEntry = activeSelectionHistory.undo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (selectionEntry != null) {
            selectionEntry.backwards().applyToSelection();
            return;
        }
        HistoryEntry<BlockOrBiomeBuffer> entry = history.undo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (entry != null) {
            BlockBuffer blockBuffer;
            BlockOrBiomeBuffer blockOrBiomeBuffer;
            if (activeSelectionHistory.getSize() > 0) {
                Selection.clearSelection();
            }
            if (historyIdentifier != null) {
                Path path = Dispatcher.getHistoryPath();
                HistoryIO.setPosition(path, history.getPosition(), history.getSize());
            }
            if (entry.backwards() instanceof DummyBuffer) {
                return;
            }
            tracers.add(new UndoRedoTracer(class_243.method_24953((class_2382)entry.origin()), 0xFF0000, true));
            Dispatcher.apply(entry.backwards(), allowSelection && entry.hasModifier(HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP));
            if (entry.additionalUndoOperation() != null) {
                entry.additionalUndoOperation().perform();
            }
            if (allowPlacement && entry.hasModifier(HistoryEntry.MODIFIER_PASTE) && !Placement.INSTANCE.isPlacing() && (blockOrBiomeBuffer = entry.forwards()) instanceof BlockBuffer && (blockBuffer = (BlockBuffer)blockOrBiomeBuffer).getSectionCount() < 4096) {
                Placement.INSTANCE.startPlacement(entry.origin(), blockBuffer, entry.description());
                shouldRemovePlacementOnStep = true;
            }
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().afterBlockBufferUndo();
            }
        }
    }

    private static void redo(boolean allowPlacement, boolean fromIngame) {
        Dispatcher.applyPendingHistory();
        if (!AxiomClient.hasPermission(AxiomPermission.BUILD_SECTION)) {
            ChatUtils.error("Server hasn't given you permission to place blocks with Axiom");
            return;
        }
        if (shouldRemovePlacementOnStep) {
            Placement.INSTANCE.stopPlacement();
            shouldRemovePlacementOnStep = false;
        } else if (Placement.INSTANCE.isPlacing() && !ToolManager.isToolActive()) {
            Placement.INSTANCE.stopPlacement();
            return;
        }
        HistoryEntry<SelectionHistoryElement> selectionEntry = activeSelectionHistory.redo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (selectionEntry != null) {
            selectionEntry.forwards().applyToSelection();
            return;
        }
        HistoryEntry<BlockOrBiomeBuffer> entry = history.redo(fromIngame ? HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME : 0);
        if (entry != null) {
            BlockBuffer blockBuffer;
            Object object;
            if (activeSelectionHistory.getSize() > 0) {
                Selection.clearSelection();
            }
            if (historyIdentifier != null) {
                Path path = Dispatcher.getHistoryPath();
                HistoryIO.setPosition(path, history.getPosition(), history.getSize());
            }
            if (entry.forwards() instanceof DummyBuffer) {
                return;
            }
            tracers.add(new UndoRedoTracer(class_243.method_24953((class_2382)entry.origin()), 65280, false));
            if (entry.additionalUndoOperation() instanceof ModellingAdditionalUndoOperation && ToolManager.isToolActive() && (object = ToolManager.getCurrentTool()) instanceof ModellingTool) {
                ModellingTool modellingTool = (ModellingTool)object;
                modellingTool.reset();
            }
            Dispatcher.apply(entry.forwards(), false);
            if (allowPlacement && entry.hasModifier(HistoryEntry.MODIFIER_CUT) && !Placement.INSTANCE.isPlacing() && (object = entry.backwards()) instanceof BlockBuffer && (blockBuffer = (BlockBuffer)object).getSectionCount() < 4096) {
                Placement.INSTANCE.startPlacement(entry.origin(), blockBuffer, entry.description());
                shouldRemovePlacementOnStep = true;
            }
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().afterBlockBufferRedo();
            }
        }
    }

    public static void resetShouldRemovePlacementOnStep() {
        shouldRemovePlacementOnStep = false;
    }

    public static void apply(BlockOrBiomeBuffer buffer, boolean select2) {
        if (buffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)buffer;
            Dispatcher.applyBlockBuffer(blockBuffer, select2);
        } else if (buffer instanceof BiomeBuffer) {
            BiomeBuffer biomeBuffer = (BiomeBuffer)buffer;
            Dispatcher.applyBiomeBuffer(biomeBuffer);
        } else {
            throw new FaultyImplementationError();
        }
    }

    private static void applyBiomeBuffer(BiomeBuffer biomeBuffer) {
        if (class_310.method_1551().method_1496() && dispatchTasks.isEmpty()) {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            class_3218 world = class_310.method_1551().method_1576().method_3847(worldKey);
            Objects.requireNonNull(world);
            class_310.method_1551().method_1576().method_20493(() -> {
                try {
                    Dispatcher.applyBiomeBufferSingleplayer(biomeBuffer, world);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            Dispatcher.addTask(DispatchTask.blockOrBiome((class_5321<class_1937>)worldKey, biomeBuffer));
        }
    }

    private static void applyBiomeBufferSingleplayer(BiomeBuffer buffer, class_3218 world) {
        HashSet changedChunks = new HashSet();
        int minSection = world.method_32891();
        int maxSection = world.method_31597();
        Optional registryOptional = world.method_30349().method_46759(class_7924.field_41236);
        if (registryOptional.isEmpty()) {
            return;
        }
        class_2378 registry = (class_2378)registryOptional.get();
        buffer.forEachEntry((x, y, z, biome) -> {
            int cy = y >> 2;
            if (cy < minSection || cy > maxSection) {
                return;
            }
            class_2818 chunk = (class_2818)world.method_8402(x >> 2, z >> 2, class_2806.field_12803, false);
            if (chunk == null) {
                return;
            }
            class_2826 section = chunk.method_38259(cy - minSection);
            class_2841 container = (class_2841)section.method_38294();
            Optional holder = registry.method_46746(biome);
            if (holder.isPresent()) {
                container.method_35321(x & 3, y & 3, z & 3, (Object)((class_6880)holder.get()));
                changedChunks.add(chunk);
            }
        });
        class_3898 chunkMap = world.method_14178().field_17254;
        HashMap<class_3222, List> map = new HashMap<class_3222, List>();
        for (class_2818 chunk : changedChunks) {
            chunk.method_65063();
            class_1923 chunkPos = chunk.method_12004();
            for (class_3222 serverPlayer2 : chunkMap.method_17210(chunkPos, false)) {
                map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((serverPlayer, list) -> serverPlayer.field_13987.method_14364((class_2596)class_8212.method_49685((List)list)));
    }

    public static void applyBlockBuffer(BlockBuffer buffer, boolean select2) {
        if (class_310.method_1551().method_1496() && dispatchTasks.isEmpty()) {
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            ChunkedBooleanRegion selection = select2 ? new ChunkedBooleanRegion() : null;
            UUID localPlayerUuid = class_310.method_1551().field_1724.method_5667();
            class_1132 integratedServer = class_310.method_1551().method_1576();
            integratedServer.method_20493(() -> {
                class_3218 world = integratedServer.method_3847(worldKey);
                if (world == null) {
                    return;
                }
                class_3222 player = integratedServer.method_3760().method_14602(localPlayerUuid);
                try {
                    AxiomServerboundSetBuffer.applyBlockBufferServer(buffer, world, selection, player);
                    if (selection != null) {
                        class_310.method_1551().method_20493(() -> {
                            Selection.clearSelection();
                            if (selection.count() <= 0) {
                                selection.close();
                            } else {
                                Selection.set(selection);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            if (select2) {
                class_2680 emptyState = BlockBuffer.EMPTY_STATE;
                ChunkedBooleanRegion selection = new ChunkedBooleanRegion();
                for (Long2ObjectMap.Entry entry : buffer.entrySet()) {
                    int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
                    int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
                    int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
                    class_2841 container = (class_2841)entry.getValue();
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                                if (blockState == emptyState) continue;
                                selection.add(cx + x, cy + y, cz + z);
                            }
                        }
                    }
                }
                Selection.clearSelection();
                Selection.set(selection);
            }
            class_5321 worldKey = class_310.method_1551().field_1687.method_27983();
            Dispatcher.addTask(DispatchTask.blockOrBiome((class_5321<class_1937>)worldKey, buffer));
        }
    }

    static {
        dispatchTasks = new ArrayList<DispatchTask>();
        availableDispatchSends = 0;
        delayDueToExhausedDispatchSends = 0;
        historyIdentifier = null;
        pendingHistoryIdentifier = null;
    }

    private record PendingChunkData(Long2ObjectMap<CompressedBlockEntity> compressedBlockEntityMap, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
    }

    private record PendingEntityData(Map<UUID, class_2487> entityData) {
    }

    public record HistoryData(HistoryEntry<?> entry, int position, boolean isActiveSelection) {
        public String getIndexIdentifier() {
            if (this.isActiveSelection) {
                if (this.position == 0) {
                    return "a";
                }
                StringBuilder identifier = new StringBuilder();
                for (int position = this.position; position > 0; position /= 26) {
                    int modulo = position % 26;
                    identifier.insert(0, (char)(97 + modulo));
                }
                return identifier.toString();
            }
            return "" + this.position;
        }
    }
}

