/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class HistoryBuffer<T> {
    private final List<HistoryEntry<T>> entries = new ArrayList<HistoryEntry<T>>();
    private int position = -1;
    private long sizeInBytes = 0L;

    public int getPosition() {
        return this.position;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Deprecated
    public void unsafeSetPosition(int position) {
        if (position < -1 || position > this.entries.size()) {
            throw new FaultyImplementationError();
        }
        this.position = position;
    }

    public int getSize() {
        return this.entries.size();
    }

    @Nullable
    public HistoryEntry<T> getHistoryEntry(int index) {
        return this.entries.get(index);
    }

    public void clear() {
        this.entries.clear();
        this.position = -1;
        this.sizeInBytes = 0L;
    }

    public void push(HistoryEntry<T> entry) {
        while (this.entries.size() - 1 > this.position) {
            HistoryEntry<T> removed = this.entries.remove(this.entries.size() - 1);
            this.sizeInBytes -= (long)removed.bytes();
        }
        this.entries.add(entry);
        this.sizeInBytes += (long)entry.bytes();
        ++this.position;
    }

    public boolean canUndo() {
        return this.position >= 0;
    }

    @Nullable
    public HistoryEntry<T> undo(int requiredModifiers) {
        if (!this.canUndo()) {
            return null;
        }
        HistoryEntry<T> entry = this.entries.get(this.position);
        if (requiredModifiers != 0 && !entry.hasModifier(requiredModifiers)) {
            return null;
        }
        --this.position;
        return entry;
    }

    public boolean canRedo() {
        return this.position < this.entries.size() - 1;
    }

    @Nullable
    public HistoryEntry<T> redo(int requiredModifiers) {
        if (!this.canRedo()) {
            return null;
        }
        HistoryEntry<T> entry = this.entries.get(this.position + 1);
        if (requiredModifiers != 0 && !entry.hasModifier(requiredModifiers)) {
            return null;
        }
        ++this.position;
        return entry;
    }
}

