/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.value;

import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.generators.noise_parameters.fade_functions.FadeFunction;
import de.articdive.jnoise.generators.noise_parameters.interpolation.Interpolation;
import org.jetbrains.annotations.NotNull;

public final class ValueNoiseGenerator
implements SeededNoiseGenerator {
    private final long seed;
    private final Interpolation interpolation;
    private final FadeFunction fadeFunction;

    private ValueNoiseGenerator(long seed, @NotNull Interpolation interpolation, @NotNull FadeFunction fadeFunction) {
        this.seed = seed;
        this.interpolation = interpolation;
        this.fadeFunction = fadeFunction;
    }

    @Override
    public double evaluateNoise(double x, long seed) {
        long iX = (long)Math.floor(x);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord1D((int)iX, seed), ValueNoiseGenerator.evaluateCoord1D((int)iX + 1, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    @Override
    public double evaluateNoise(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord2D((int)iX, (int)iY, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX + 1, (int)iY, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX, (int)iY + 1, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX + 1, (int)iY + 1, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY), this.fadeFunction.fade(z - (double)iZ)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord3D(iX, iY, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY + 1L, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY + 1L, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY + 1L, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY + 1L, iZ + 1L, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY), this.fadeFunction.fade(z - (double)iZ), this.fadeFunction.fade(w - (double)iW)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ + 1L, iW + 1L, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    @Override
    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    private static double evaluateCoord1D(long x, long seed) {
        int n = (int)(seed ^ 1619L * x);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord2D(long x, long y, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord3D(long x, long y, long z, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord4D(long x, long y, long z, long w, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        n = (int)((long)n ^ 1013L * w);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    @NotNull
    public static ValueNoiseBuilder newBuilder() {
        return new ValueNoiseBuilder();
    }

    public static final class ValueNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private Interpolation interpolation = Interpolation.LINEAR;
        private FadeFunction fadeFunction = FadeFunction.IMPROVED_PERLIN_NOISE;

        private ValueNoiseBuilder() {
        }

        @NotNull
        public ValueNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        @NotNull
        public ValueNoiseBuilder setInterpolation(Interpolation interpolation) {
            if (interpolation == null) {
                throw new IllegalArgumentException("Interpolation cannot be null.");
            }
            this.interpolation = interpolation;
            return this;
        }

        @NotNull
        public ValueNoiseBuilder setFadeFunction(FadeFunction fadeFunction) {
            if (fadeFunction == null) {
                throw new IllegalArgumentException("Fade function cannot be null.");
            }
            this.fadeFunction = fadeFunction;
            return this;
        }

        @Override
        @NotNull
        public ValueNoiseGenerator build() {
            return new ValueNoiseGenerator(this.seed, this.interpolation, this.fadeFunction);
        }
    }
}

