/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.font.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.elementa.font.data.Atlas;
import gg.essential.elementa.font.data.Glyph;
import gg.essential.elementa.font.data.Metrics;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lgg/essential/elementa/font/data/FontInfo;", "", "atlas", "Lgg/essential/elementa/font/data/Atlas;", "metrics", "Lgg/essential/elementa/font/data/Metrics;", "glyphs", "", "", "Lgg/essential/elementa/font/data/Glyph;", "(Lgg/essential/elementa/font/data/Atlas;Lgg/essential/elementa/font/data/Metrics;Ljava/util/Map;)V", "getAtlas", "()Lgg/essential/elementa/font/data/Atlas;", "getGlyphs", "()Ljava/util/Map;", "getMetrics", "()Lgg/essential/elementa/font/data/Metrics;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "Elementa"})
public final class FontInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Atlas atlas;
    @NotNull
    private final Metrics metrics;
    @NotNull
    private final Map<Integer, Glyph> glyphs;
    @NotNull
    private static final Gson gson = new Gson();

    public FontInfo(@NotNull Atlas atlas, @NotNull Metrics metrics, @NotNull Map<Integer, Glyph> glyphs) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter(glyphs, (String)"glyphs");
        this.atlas = atlas;
        this.metrics = metrics;
        this.glyphs = glyphs;
    }

    @NotNull
    public final Atlas getAtlas() {
        return this.atlas;
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public final Map<Integer, Glyph> getGlyphs() {
        return this.glyphs;
    }

    @NotNull
    public final Atlas component1() {
        return this.atlas;
    }

    @NotNull
    public final Metrics component2() {
        return this.metrics;
    }

    @NotNull
    public final Map<Integer, Glyph> component3() {
        return this.glyphs;
    }

    @NotNull
    public final FontInfo copy(@NotNull Atlas atlas, @NotNull Metrics metrics, @NotNull Map<Integer, Glyph> glyphs) {
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter(glyphs, (String)"glyphs");
        return new FontInfo(atlas, metrics, glyphs);
    }

    public static /* synthetic */ FontInfo copy$default(FontInfo fontInfo, Atlas atlas, Metrics metrics, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            atlas = fontInfo.atlas;
        }
        if ((n & 2) != 0) {
            metrics = fontInfo.metrics;
        }
        if ((n & 4) != 0) {
            map2 = fontInfo.glyphs;
        }
        return fontInfo.copy(atlas, metrics, map2);
    }

    @NotNull
    public String toString() {
        return "FontInfo(atlas=" + this.atlas + ", metrics=" + this.metrics + ", glyphs=" + this.glyphs + ')';
    }

    public int hashCode() {
        int result = this.atlas.hashCode();
        result = result * 31 + this.metrics.hashCode();
        result = result * 31 + ((Object)this.glyphs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FontInfo)) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)other;
        if (!Intrinsics.areEqual((Object)this.atlas, (Object)fontInfo.atlas)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metrics, (Object)fontInfo.metrics)) {
            return false;
        }
        return Intrinsics.areEqual(this.glyphs, fontInfo.glyphs);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgg/essential/elementa/font/data/FontInfo$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "fromJson", "Lgg/essential/elementa/font/data/FontInfo;", "json", "Lcom/google/gson/JsonObject;", "Elementa"})
    @SourceDebugExtension(value={"SMAP\nFontInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontInfo.kt\ngg/essential/elementa/font/data/FontInfo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1177#2,2:105\n1251#2,4:107\n*S KotlinDebug\n*F\n+ 1 FontInfo.kt\ngg/essential/elementa/font/data/FontInfo$Companion\n*L\n18#1:105,2\n18#1:107,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontInfo fromJson(@NotNull JsonObject json) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Atlas atlas = (Atlas)gson.fromJson((JsonElement)json.getAsJsonObject("atlas"), Atlas.class);
            Metrics metrics = (Metrics)gson.fromJson((JsonElement)json.getAsJsonObject("metrics"), Metrics.class);
            JsonArray jsonArray = json.getAsJsonArray("glyphs");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"json.getAsJsonArray(\"glyphs\")");
            Iterable $this$associate$iv = (Iterable)jsonArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                JsonElement glyphElement = (JsonElement)element$iv$iv;
                boolean bl = false;
                Glyph glyph = (Glyph)gson.fromJson(glyphElement, Glyph.class);
                Pair pair = TuplesKt.to((Object)glyph.getUnicode(), (Object)glyph);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map glyphs = destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)atlas, (String)"atlas");
            Intrinsics.checkNotNullExpressionValue((Object)metrics, (String)"metrics");
            return new FontInfo(atlas, metrics, glyphs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

