/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.universal.utils;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0013R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lgg/essential/universal/utils/TemporaryTextureAllocator;", "Ljava/lang/AutoCloseable;", "Lkotlin/Function0;", "", "allCleanedUp", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "", "width", "height", "Lgg/essential/universal/utils/TemporaryTextureAllocator$TextureAllocation;", "allocate", "(II)Lgg/essential/universal/utils/TemporaryTextureAllocator$TextureAllocation;", "close", "()V", "allocation", "free", "(Lgg/essential/universal/utils/TemporaryTextureAllocator$TextureAllocation;)V", "nextFrame", "Lkotlin/jvm/functions/Function0;", "", "reusableAllocations", "Ljava/util/List;", "usedAllocations", "TextureAllocation", "UniversalCraft 1.21.9-fabric"})
@SourceDebugExtension(value={"SMAP\nTemporaryTextureAllocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryTextureAllocator.kt\ngg/essential/universal/utils/TemporaryTextureAllocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1849#2,2:101\n*S KotlinDebug\n*F\n+ 1 TemporaryTextureAllocator.kt\ngg/essential/universal/utils/TemporaryTextureAllocator\n*L\n47#1:101,2\n*E\n"})
public final class TemporaryTextureAllocator
implements AutoCloseable {
    @NotNull
    private final Function0<Unit> allCleanedUp;
    @NotNull
    private final List<TextureAllocation> usedAllocations;
    @NotNull
    private final List<TextureAllocation> reusableAllocations;

    public TemporaryTextureAllocator(@NotNull Function0<Unit> allCleanedUp) {
        Intrinsics.checkNotNullParameter(allCleanedUp, (String)"allCleanedUp");
        this.allCleanedUp = allCleanedUp;
        this.usedAllocations = new ArrayList();
        this.reusableAllocations = new ArrayList();
    }

    public /* synthetic */ TemporaryTextureAllocator(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Unit>)function0);
    }

    @NotNull
    public final TextureAllocation allocate(int width, int height) {
        TextureAllocation texture2 = (TextureAllocation)CollectionsKt.removeLastOrNull(this.reusableAllocations);
        if (texture2 != null && (texture2.getWidth() != width || texture2.getHeight() != height)) {
            texture2.close();
            texture2 = null;
        }
        if (texture2 == null) {
            texture2 = new TextureAllocation(width, height);
        }
        GpuDevice device = RenderSystem.getDevice();
        device.createCommandEncoder().clearColorAndDepthTextures(texture2.getTexture(), 0, texture2.getDepthTexture(), 1.0);
        this.usedAllocations.add(texture2);
        return texture2;
    }

    public final void free(@NotNull TextureAllocation allocation) {
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        if (this.usedAllocations.remove(allocation)) {
            this.reusableAllocations.add(allocation);
        }
    }

    public final void nextFrame() {
        Iterable $this$forEach$iv = this.reusableAllocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureAllocation it = (TextureAllocation)element$iv;
            boolean bl = false;
            it.close();
        }
        this.reusableAllocations.clear();
        this.reusableAllocations.addAll((Collection<TextureAllocation>)this.usedAllocations);
        this.usedAllocations.clear();
        if (this.reusableAllocations.isEmpty()) {
            this.allCleanedUp.invoke();
        }
    }

    @Override
    public void close() {
        this.nextFrame();
        this.nextFrame();
        boolean bl = this.usedAllocations.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.reusableAllocations.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public TemporaryTextureAllocator() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR*\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R*\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\r\u001a\u0004\b \u0010\u000f\"\u0004\b!\u0010\u0011R*\u0010\"\u001a\n \u000b*\u0004\u0018\u00010\u00120\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0014\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b%\u0010\u001e\u00a8\u0006&"}, d2={"Lgg/essential/universal/utils/TemporaryTextureAllocator$TextureAllocation;", "Ljava/lang/AutoCloseable;", "", "width", "height", "<init>", "(II)V", "", "close", "()V", "Lcom/mojang/blaze3d/textures/GpuTexture;", "kotlin.jvm.PlatformType", "depthTexture", "Lcom/mojang/blaze3d/textures/GpuTexture;", "getDepthTexture", "()Lcom/mojang/blaze3d/textures/GpuTexture;", "setDepthTexture", "(Lcom/mojang/blaze3d/textures/GpuTexture;)V", "Lcom/mojang/blaze3d/textures/GpuTextureView;", "depthTextureView", "Lcom/mojang/blaze3d/textures/GpuTextureView;", "getDepthTextureView", "()Lcom/mojang/blaze3d/textures/GpuTextureView;", "setDepthTextureView", "(Lcom/mojang/blaze3d/textures/GpuTextureView;)V", "Lcom/mojang/blaze3d/systems/GpuDevice;", "gpuDevice", "Lcom/mojang/blaze3d/systems/GpuDevice;", "I", "getHeight", "()I", "texture", "getTexture", "setTexture", "textureView", "getTextureView", "setTextureView", "getWidth", "UniversalCraft 1.21.9-fabric"})
    @SourceDebugExtension(value={"SMAP\nTemporaryTextureAllocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryTextureAllocator.kt\ngg/essential/universal/utils/TemporaryTextureAllocator$TextureAllocation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    public static final class TextureAllocation
    implements AutoCloseable {
        private final int width;
        private final int height;
        private final GpuDevice gpuDevice;
        private GpuTexture texture;
        private GpuTexture depthTexture;
        private GpuTextureView textureView;
        private GpuTextureView depthTextureView;

        /*
         * WARNING - void declaration
         */
        public TextureAllocation(int width, int height) {
            void $this$texture_u24lambda_u241;
            GpuTexture gpuTexture;
            this.width = width;
            this.height = height;
            this.gpuDevice = RenderSystem.getDevice();
            GpuTexture gpuTexture2 = gpuTexture = this.gpuDevice.createTexture(TextureAllocation::texture$lambda$0, 8 | 4, TextureFormat.RGBA8, this.width, this.height, 1, 1);
            TextureAllocation textureAllocation = this;
            boolean bl = false;
            $this$texture_u24lambda_u241.setTextureFilter(FilterMode.NEAREST, false);
            textureAllocation.texture = gpuTexture;
            this.depthTexture = this.gpuDevice.createTexture(TextureAllocation::depthTexture$lambda$2, 8, TextureFormat.DEPTH32, this.width, this.height, 1, 1);
            this.textureView = this.gpuDevice.createTextureView(this.texture);
            this.depthTextureView = this.gpuDevice.createTextureView(this.depthTexture);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final GpuTexture getTexture() {
            return this.texture;
        }

        public final void setTexture(GpuTexture gpuTexture) {
            this.texture = gpuTexture;
        }

        public final GpuTexture getDepthTexture() {
            return this.depthTexture;
        }

        public final void setDepthTexture(GpuTexture gpuTexture) {
            this.depthTexture = gpuTexture;
        }

        public final GpuTextureView getTextureView() {
            return this.textureView;
        }

        public final void setTextureView(GpuTextureView gpuTextureView) {
            this.textureView = gpuTextureView;
        }

        public final GpuTextureView getDepthTextureView() {
            return this.depthTextureView;
        }

        public final void setDepthTextureView(GpuTextureView gpuTextureView) {
            this.depthTextureView = gpuTextureView;
        }

        @Override
        public void close() {
            this.depthTextureView.close();
            this.textureView.close();
            this.depthTexture.close();
            this.texture.close();
        }

        private static final String texture$lambda$0() {
            return "Pre-rendered texture";
        }

        private static final String depthTexture$lambda$2() {
            return "Pre-rendered depth texture";
        }
    }
}

