/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtReadView;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtWriteView;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11371;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbtView {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"malilib-NbtView");
    private static final class_8942 log = new class_8942.class_11340(LOGGER);
    private class_11368 reader;
    private class_11372 writer;

    private NbtView() {
    }

    public static NbtView getReader(class_2487 nbt, @Nonnull class_5455 registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = class_11352.method_71417((class_8942)log, (class_7225.class_7874)registry, (class_2487)nbt);
        wrapper.writer = null;
        return wrapper;
    }

    public static NbtView getWriter(@Nonnull class_5455 registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = null;
        wrapper.writer = class_11362.method_71459((class_8942)log, (class_7225.class_7874)registry);
        return wrapper;
    }

    public class_8942 getErrorReporter() {
        return log;
    }

    public boolean isReader() {
        return this.reader != null;
    }

    public boolean isWriter() {
        return this.writer != null;
    }

    @Nullable
    public class_11368 getReader() {
        return this.reader;
    }

    @Nullable
    public class_11372 getWriter() {
        return this.writer;
    }

    @Nullable
    public class_11352 asNbtReader() {
        return (class_11352)this.reader;
    }

    @Nullable
    public class_11362 asNbtWriter() {
        return (class_11362)this.writer;
    }

    @Nullable
    public class_11371 getReaderContext() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getContext();
        }
        LOGGER.error("getReaderContext(): Called from a Writer Context");
        return null;
    }

    @Nullable
    public DynamicOps<?> getWriterOps() {
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getOps();
        }
        LOGGER.error("getWriterOps(): Called from a Reader Context");
        return null;
    }

    @Nullable
    public class_2487 readNbt() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getNbt();
        }
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getNbt();
        }
        LOGGER.error("readNbt(): General failure");
        return null;
    }

    @Nullable
    public NbtView writeNbt(@Nonnull class_2487 nbtIn) {
        if (this.isReader()) {
            LOGGER.error("writeNbt(): Called from a Reader Context");
            return null;
        }
        for (String key : nbtIn.method_10541()) {
            Objects.requireNonNull(this.readNbt()).method_10566(key, nbtIn.method_10580(key));
        }
        return this;
    }

    public <T> Optional<T> readFlatMap(MapCodec<T> mapCodec) {
        if (this.isWriter()) {
            LOGGER.error("readFlatMap(): Called from a Writer Context");
            return Optional.empty();
        }
        return NbtUtils.readFlatMap(Objects.requireNonNullElse(this.readNbt(), new class_2487()), mapCodec);
    }

    public <T> Optional<T> readCodec(String key, Codec<T> codec) {
        if (this.isWriter()) {
            LOGGER.error("readCodec(): Called from a Writer Context");
            return Optional.empty();
        }
        try {
            return this.reader.method_71426(key, codec);
        }
        catch (Exception err) {
            LOGGER.warn("readCodec(): Exception reading from key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public <T> class_2487 writeFlatMap(MapCodec<T> mapCodec, T value) {
        if (this.isReader()) {
            LOGGER.error("writeFlatMap(): Called from a Reader Context");
            return new class_2487();
        }
        this.writeNbt(NbtUtils.writeFlatMap(mapCodec, value));
        return this.readNbt();
    }

    public <T> class_2487 writeCodec(String key, Codec<T> codec, T value) {
        if (this.isReader()) {
            LOGGER.error("writeCodec(): Called from a Reader Context");
            return new class_2487();
        }
        try {
            this.writer.method_71468(key, codec, value);
            return this.readNbt();
        }
        catch (Exception err) {
            LOGGER.warn("writeCodec(): Exception writing to key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return new class_2487();
        }
    }
}

