/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;

public class ChunkUpdateTypes {
    public static final int SORT = 1;
    public static final int REBUILD = 2;
    public static final int IMPORTANT = 4;
    public static final int INITIAL_BUILD = 8;

    public static int join(int from, int to) {
        return from | to;
    }

    public static boolean isSort(int type) {
        return (type & 1) != 0;
    }

    public static boolean isRebuild(int type) {
        return (type & 2) != 0;
    }

    public static boolean isImportant(int type) {
        return (type & 4) != 0;
    }

    public static boolean isInitialBuild(int type) {
        return (type & 8) != 0;
    }

    public static boolean isRebuildWithSort(int type) {
        return (ChunkUpdateTypes.isRebuild(type) || ChunkUpdateTypes.isInitialBuild(type)) && ChunkUpdateTypes.isSort(type);
    }

    public static TaskQueueType getQueueType(int type, TaskQueueType importantRebuildQueueType) {
        if (ChunkUpdateTypes.isInitialBuild(type)) {
            return TaskQueueType.INITIAL_BUILD;
        }
        if (ChunkUpdateTypes.isImportant(type)) {
            if (ChunkUpdateTypes.isRebuild(type)) {
                return importantRebuildQueueType;
            }
            return TaskQueueType.ZERO_FRAME_DEFER;
        }
        return TaskQueueType.ALWAYS_DEFER;
    }
}

