/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateTypes;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.RenderListProvider;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.RenderSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;

public abstract class SectionCollector
implements RenderListProvider,
RenderSectionVisitor {
    private final int frame;
    private final TaskQueueType importantRebuildQueueType;
    private final ObjectArrayList<ChunkRenderList> renderLists;
    private final EnumMap<TaskQueueType, ArrayDeque<RenderSection>> sortedTaskLists;
    private boolean needsRevisitForPendingUpdates = false;
    private static int[] sortItems = new int[256];

    public SectionCollector(int frame, TaskQueueType importantRebuildQueueType) {
        this.frame = frame;
        this.importantRebuildQueueType = importantRebuildQueueType;
        this.renderLists = new ObjectArrayList();
        this.sortedTaskLists = new EnumMap(TaskQueueType.class);
        for (TaskQueueType type : TaskQueueType.values()) {
            this.sortedTaskLists.put(type, new ArrayDeque());
        }
    }

    @Override
    public void visit(RenderSection section) {
        int pendingUpdate;
        if (section.getFlags() != 0) {
            RenderRegion region = section.getRegion();
            ChunkRenderList renderList = region.getRenderList();
            if (renderList.getLastVisibleFrame() != this.frame) {
                renderList.reset(this.frame, this.orderIsSorted());
                this.renderLists.add((Object)renderList);
            }
            renderList.add(section);
        }
        if ((pendingUpdate = section.getPendingUpdate()) != 0) {
            if (section.getTaskCancellationToken() != null) {
                this.needsRevisitForPendingUpdates = true;
                return;
            }
            TaskQueueType queueType = ChunkUpdateTypes.getQueueType(pendingUpdate, this.importantRebuildQueueType);
            Queue queue = this.sortedTaskLists.get((Object)queueType);
            if (queue.size() < queueType.queueSizeLimit()) {
                queue.add(section);
            }
        }
    }

    @Override
    public ObjectArrayList<ChunkRenderList> getUnsortedRenderLists() {
        return this.renderLists;
    }

    @Override
    public Map<TaskQueueType, ArrayDeque<RenderSection>> getTaskLists() {
        return this.sortedTaskLists;
    }

    @Override
    public boolean needsRevisitForPendingUpdates() {
        return this.needsRevisitForPendingUpdates;
    }

    @Override
    public void setCachedSortItems(int[] sortItems) {
        SectionCollector.sortItems = sortItems;
    }

    @Override
    public int[] getCachedSortItems() {
        return sortItems;
    }
}

