/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.exporting;

import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.moulberry.flashback.exporting.SaveableFramebuffer;
import com.moulberry.flashback.visuals.ShaderManager;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_1011;
import net.minecraft.class_276;
import org.jetbrains.annotations.Nullable;

public class SaveableFramebufferQueue
implements AutoCloseable {
    private final int width;
    private final int height;
    private static final int CAPACITY = 3;
    private final List<SaveableFramebuffer> available = new ArrayList<SaveableFramebuffer>();
    private final List<SaveableFramebuffer> waiting = new ArrayList<SaveableFramebuffer>();
    private final GpuTexture flipBuffer;
    private final GpuTextureView flipBufferView;

    public SaveableFramebufferQueue(int width, int height) {
        this.width = width;
        this.height = height;
        this.flipBuffer = RenderSystem.getDevice().createTexture(() -> "flip buffer", 9, TextureFormat.RGBA8, width, height, 1, 1);
        this.flipBuffer.setAddressMode(AddressMode.CLAMP_TO_EDGE);
        this.flipBufferView = RenderSystem.getDevice().createTextureView(this.flipBuffer);
        for (int i = 0; i < 3; ++i) {
            this.available.add(new SaveableFramebuffer());
        }
    }

    public SaveableFramebuffer take() {
        if (this.available.isEmpty()) {
            throw new IllegalStateException("No textures available!");
        }
        return this.available.removeFirst();
    }

    private void blitFlip(class_276 src, boolean supersampling) {
        FilterMode oldFilterMode = src.field_1483;
        if (supersampling) {
            src.method_58226(FilterMode.LINEAR);
        }
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "flashback flip pass", this.flipBufferView, OptionalInt.empty());){
            renderPass.setPipeline(ShaderManager.BLIT_SCREEN_FLIP);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.bindSampler("InSampler", src.method_71639());
            renderPass.draw(0, 3);
        }
        if (supersampling) {
            src.method_58226(oldFilterMode);
        }
    }

    public void startDownload(class_276 target, SaveableFramebuffer texture, boolean supersampling) {
        this.blitFlip(target, supersampling);
        texture.startDownload(this.flipBuffer, this.width, this.height);
        this.waiting.add(texture);
    }

    @Nullable
    public DownloadedFrame finishDownload(boolean drain) {
        if (this.waiting.isEmpty()) {
            return null;
        }
        if (!drain && !this.available.isEmpty()) {
            return null;
        }
        SaveableFramebuffer texture = this.waiting.removeFirst();
        class_1011 nativeImage = texture.finishDownload(this.width, this.height);
        FloatBuffer audioBuffer = texture.audioBuffer;
        texture.audioBuffer = null;
        this.available.add(texture);
        return new DownloadedFrame(nativeImage, audioBuffer);
    }

    @Override
    public void close() {
        for (SaveableFramebuffer texture : this.waiting) {
            texture.close();
        }
        for (SaveableFramebuffer texture : this.available) {
            texture.close();
        }
        this.waiting.clear();
        this.available.clear();
        this.flipBuffer.close();
    }

    record DownloadedFrame(class_1011 image, @Nullable FloatBuffer audioBuffer) {
    }
}

