/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.io;

import gg.essential.elementa.impl.dom4j.Branch;
import gg.essential.elementa.impl.dom4j.Document;
import gg.essential.elementa.impl.dom4j.DocumentFactory;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.Namespace;
import gg.essential.elementa.impl.dom4j.QName;
import gg.essential.elementa.impl.dom4j.tree.NamespaceStack;
import java.util.ArrayList;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMReader {
    private DocumentFactory factory;
    private NamespaceStack namespaceStack;

    public DOMReader() {
        this.factory = DocumentFactory.getInstance();
        this.namespaceStack = new NamespaceStack(this.factory);
    }

    public DOMReader(DocumentFactory factory) {
        this.factory = factory;
        this.namespaceStack = new NamespaceStack(factory);
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory docFactory) {
        this.factory = docFactory;
        this.namespaceStack.setDocumentFactory(this.factory);
    }

    public Document read(org.w3c.dom.Document domDocument) {
        if (domDocument instanceof Document) {
            return (Document)((Object)domDocument);
        }
        Document document = this.createDocument();
        this.clearNamespaceStack();
        NodeList nodeList = domDocument.getChildNodes();
        int size = nodeList.getLength();
        for (int i2 = 0; i2 < size; ++i2) {
            this.readTree(nodeList.item(i2), document);
        }
        return document;
    }

    protected void readTree(Node node2, Branch current) {
        Element element = null;
        Document document = null;
        if (current instanceof Element) {
            element = (Element)current;
        } else {
            document = (Document)current;
        }
        switch (node2.getNodeType()) {
            case 1: {
                this.readElement(node2, current);
                break;
            }
            case 7: {
                if (current instanceof Element) {
                    Element currentEl = (Element)current;
                    currentEl.addProcessingInstruction(node2.getNodeName(), node2.getNodeValue());
                    break;
                }
                Document currentDoc = (Document)current;
                currentDoc.addProcessingInstruction(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            case 8: {
                if (current instanceof Element) {
                    ((Element)current).addComment(node2.getNodeValue());
                    break;
                }
                ((Document)current).addComment(node2.getNodeValue());
                break;
            }
            case 10: {
                DocumentType domDocType = (DocumentType)node2;
                document.addDocType(domDocType.getName(), domDocType.getPublicId(), domDocType.getSystemId());
                break;
            }
            case 3: {
                element.addText(node2.getNodeValue());
                break;
            }
            case 4: {
                element.addCDATA(node2.getNodeValue());
                break;
            }
            case 5: {
                Node firstChild = node2.getFirstChild();
                if (firstChild != null) {
                    element.addEntity(node2.getNodeName(), firstChild.getNodeValue());
                    break;
                }
                element.addEntity(node2.getNodeName(), "");
                break;
            }
            case 6: {
                element.addEntity(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            default: {
                System.out.println("WARNING: Unknown DOM node type: " + node2.getNodeType());
            }
        }
    }

    protected void readElement(Node node2, Branch current) {
        Node attribute;
        NamedNodeMap attributeList;
        int previouslyDeclaredNamespaces = this.namespaceStack.size();
        String namespaceUri = node2.getNamespaceURI();
        String elementPrefix = node2.getPrefix();
        if (elementPrefix == null) {
            elementPrefix = "";
        }
        if ((attributeList = node2.getAttributes()) != null && namespaceUri == null && (attribute = attributeList.getNamedItem("xmlns")) != null) {
            namespaceUri = attribute.getNodeValue();
            elementPrefix = "";
        }
        QName qName = this.namespaceStack.getQName(namespaceUri, node2.getLocalName(), node2.getNodeName());
        Element element = current.addElement(qName);
        if (attributeList != null) {
            Node attribute2;
            int i2;
            int size = attributeList.getLength();
            ArrayList<Node> attributes = new ArrayList<Node>(size);
            for (i2 = 0; i2 < size; ++i2) {
                attribute2 = attributeList.item(i2);
                String name = attribute2.getNodeName();
                if (name.startsWith("xmlns")) {
                    String prefix = this.getPrefix(name);
                    String uri = attribute2.getNodeValue();
                    Namespace namespace = this.namespaceStack.addNamespace(prefix, uri);
                    element.add(namespace);
                    continue;
                }
                attributes.add(attribute2);
            }
            size = attributes.size();
            for (i2 = 0; i2 < size; ++i2) {
                attribute2 = (Node)attributes.get(i2);
                QName attributeQName = this.namespaceStack.getQName(attribute2.getNamespaceURI(), attribute2.getLocalName(), attribute2.getNodeName());
                element.addAttribute(attributeQName, attribute2.getNodeValue());
            }
        }
        NodeList children = node2.getChildNodes();
        int size = children.getLength();
        for (int i3 = 0; i3 < size; ++i3) {
            Node child = children.item(i3);
            this.readTree(child, element);
        }
        while (this.namespaceStack.size() > previouslyDeclaredNamespaces) {
            this.namespaceStack.pop();
        }
    }

    protected Namespace getNamespace(String prefix, String uri) {
        return this.getDocumentFactory().createNamespace(prefix, uri);
    }

    protected Document createDocument() {
        return this.getDocumentFactory().createDocument();
    }

    protected void clearNamespaceStack() {
        this.namespaceStack.clear();
        if (!this.namespaceStack.contains(Namespace.XML_NAMESPACE)) {
            this.namespaceStack.push(Namespace.XML_NAMESPACE);
        }
    }

    private String getPrefix(String xmlnsDecl) {
        int index = xmlnsDecl.indexOf(58, 5);
        if (index != -1) {
            return xmlnsDecl.substring(index + 1);
        }
        return "";
    }
}

