/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_768;

public class TickBoxControl
implements Control<Boolean> {
    private final Option<Boolean> option;

    public TickBoxControl(Option<Boolean> option) {
        this.option = option;
    }

    @Override
    public ControlElement<Boolean> createElement(Dim2i dim) {
        return new TickBoxControlElement(this.option, dim);
    }

    @Override
    public int getMaxWidth() {
        return 30;
    }

    @Override
    public Option<Boolean> getOption() {
        return this.option;
    }

    private static class TickBoxControlElement
    extends ControlElement<Boolean> {
        private final class_768 button;

        public TickBoxControlElement(Option<Boolean> option, Dim2i dim) {
            super(option, dim);
            this.button = new class_768(dim.getLimitX() - 16, dim.getCenterY() - 5, 10, 10);
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            boolean ticked;
            super.method_25394(graphics, mouseX, mouseY, delta);
            int x = this.button.method_3321();
            int y = this.button.method_3322();
            int w = x + this.button.method_3319();
            int h = y + this.button.method_3320();
            boolean enabled = this.option.isAvailable();
            boolean bl = ticked = enabled && (Boolean)this.option.getValue() != false;
            int color = enabled ? (ticked ? -7019309 : -1) : -5592406;
            if (ticked) {
                this.drawRect(graphics, x + 2, y + 2, w - 2, h - 2, color);
            }
            this.drawBorder(graphics, x, y, w, h, color);
        }

        public boolean method_25402(class_11909 event, boolean repeated) {
            if (this.option.isAvailable() && event.method_74245() == 0 && this.dim.containsCursor(event.comp_4798(), event.comp_4799())) {
                this.toggleControl();
                return true;
            }
            return false;
        }

        public boolean method_25404(class_11908 event) {
            if (!this.method_25370()) {
                return false;
            }
            if (event.method_74229()) {
                this.toggleControl();
                return true;
            }
            return false;
        }

        private void toggleControl() {
            this.playClickSound();
            this.option.setValue((Boolean)this.option.getValue() == false);
        }
    }
}

