/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class ModifySelection {
    private static Gizmo gizmo = null;
    private static ChunkedBooleanRegion selectionRegion = null;
    private static float lastScaleX = 1.0f;
    private static float lastScaleY = 1.0f;
    private static float lastScaleZ = 1.0f;
    private static float appliedScaleX = 1.0f;
    private static float appliedScaleY = 1.0f;
    private static float appliedScaleZ = 1.0f;
    private static ChunkedBooleanRegion scaledSelectionRegion = null;
    private static class_243 originalSelectionCenter = class_243.field_1353;
    private static boolean hasMutatedSelectionRegion = false;

    public static UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!ModifySelection.isModifyingSelection() || !EditorUI.isActive() || ToolManager.isToolActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case ROTATE_PLACEMENT: {
                ModifySelection.rotateY();
                break;
            }
            case FLIP_PLACEMENT: {
                class_243 lookDirection = Tool.getLookDirection();
                if (lookDirection == null) {
                    lookDirection = class_310.method_1551().method_1560().method_5720();
                }
                class_2350 direction = PositionUtils.orderedByNearest(lookDirection)[0];
                ModifySelection.flip(direction.method_10166());
                break;
            }
            case LEFT_MOUSE: {
                if (ModifySelection.leftClick()) break;
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollAmount = (UserAction.ScrollAmount)object;
                if (ModifySelection.handleScroll(scrollAmount.scrollX(), scrollAmount.scrollY())) break;
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: {
                gizmo = null;
                selectionRegion = null;
                break;
            }
            case REDO: {
                gizmo = null;
                selectionRegion = null;
                return Dispatcher.callAction(action, object);
            }
            case SAVE: 
            case ESCAPE: {
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case DELETE: {
                ModifySelection.cancelAndClearSelection();
                break;
            }
            case ENTER: 
            case PASTE: {
                ModifySelection.finish();
            }
        }
        return UserAction.ActionResult.USED_STOP;
    }

    private static boolean leftClick() {
        if (gizmo == null || EditorUI.isCtrlOrCmdDown() && !gizmo.isGrabbed()) {
            return false;
        }
        return gizmo.leftClick();
    }

    public static boolean handleScroll(int xScroll, int yScroll) {
        if (gizmo == null || EditorUI.isCtrlOrCmdDown() && !gizmo.isGrabbed()) {
            return false;
        }
        class_243 look = Tool.getLookDirection();
        if (look != null) {
            gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), look);
            return true;
        }
        return false;
    }

    public static void start() {
        if (ModifySelection.isModifyingSelection()) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || min2 == null || max2 == null) {
            return;
        }
        class_243 center = new class_243((double)(max2.method_10263() + min2.method_10263() + 1) * 0.5, (double)(max2.method_10264() + min2.method_10264() + 1) * 0.5, (double)(max2.method_10260() + min2.method_10260() + 1) * 0.5);
        class_2338 centerBlockPos = class_2338.method_49638((class_2374)center);
        class_243 offsetFromCenter = new class_243(center.field_1352 - ((double)centerBlockPos.method_10263() + 0.5), center.field_1351 - ((double)centerBlockPos.method_10264() + 0.5), center.field_1350 - ((double)centerBlockPos.method_10260() + 0.5));
        ToolManager.setToolSelected(false);
        gizmo = new Gizmo(centerBlockPos, offsetFromCenter);
        ModifySelection.gizmo.enableScale = true;
        hasMutatedSelectionRegion = false;
        originalSelectionCenter = center;
        if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            selectionRegion = new ChunkedBooleanRegion(set.selectionRegion.unsafeGetPositionSet());
        } else if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            int minX = aabb.min().method_10263();
            int minY = aabb.min().method_10264();
            int minZ = aabb.min().method_10260();
            int maxX = aabb.max().method_10263();
            int maxY = aabb.max().method_10264();
            int maxZ = aabb.max().method_10260();
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        region.add(x, y, z);
                    }
                }
            }
            selectionRegion = region;
        } else {
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            selectionBuffer.forEach(region::add);
            selectionRegion = region;
        }
        class_1297 camera = class_310.method_1551().method_1560();
        if (camera != null) {
            gizmo.setAxisDirections(camera.method_73189().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_73189().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_73189().field_1350 > (double)gizmo.getTargetPosition().method_10260());
        }
    }

    public static void cancelAndClearSelection() {
        if (gizmo != null) {
            gizmo = null;
            selectionRegion = null;
            scaledSelectionRegion = null;
            Selection.clearSelection();
        }
    }

    public static void finish() {
        if (gizmo != null) {
            ModifySelection.applyIfScaled();
            class_2338 offset = gizmo.getTargetPosition().method_10059((class_2382)class_2338.method_49638((class_2374)originalSelectionCenter));
            if (offset.equals((Object)class_2338.field_10980)) {
                if (hasMutatedSelectionRegion) {
                    Selection.set(selectionRegion);
                }
            } else {
                ChunkedBooleanRegion region = new ChunkedBooleanRegion();
                int xo = offset.method_10263();
                int yo = offset.method_10264();
                int zo = offset.method_10260();
                selectionRegion.forEach((x, y, z) -> region.add(x + xo, y + yo, z + zo));
                Selection.set(region);
            }
            selectionRegion = null;
            scaledSelectionRegion = null;
            gizmo = null;
        }
    }

    public static void applyIfScaled() {
        if (scaledSelectionRegion != null) {
            selectionRegion = scaledSelectionRegion;
            scaledSelectionRegion = null;
            appliedScaleX = 1.0f;
            appliedScaleY = 1.0f;
            appliedScaleZ = 1.0f;
            lastScaleX = 1.0f;
            lastScaleY = 1.0f;
            lastScaleZ = 1.0f;
        }
    }

    public static void rotateY() {
        ModifySelection.applyIfScaled();
        class_2338 offsetCurrent = gizmo.getTargetPosition();
        double negateOriginalX = ModifySelection.originalSelectionCenter.field_1352;
        double negateOriginalY = ModifySelection.originalSelectionCenter.field_1351;
        double negateOriginalZ = ModifySelection.originalSelectionCenter.field_1350;
        int offsetCurrentX = offsetCurrent.method_10263();
        int offsetCurrentY = offsetCurrent.method_10264();
        int offsetCurrentZ = offsetCurrent.method_10260();
        ChunkedBooleanRegion region = new ChunkedBooleanRegion();
        selectionRegion.forEach((x, y, z) -> region.add((int)Math.floor((double)offsetCurrentX - ((double)z + 0.5 - negateOriginalZ)), (int)Math.floor((double)(offsetCurrentY + y) + 0.5 - negateOriginalY), (int)Math.floor((double)(offsetCurrentZ + x) + 0.5 - negateOriginalX)));
        selectionRegion = region;
        originalSelectionCenter = originalSelectionCenter.method_1031((double)((int)Math.floor((double)offsetCurrentX + 0.5 - negateOriginalX)), (double)((int)Math.floor((double)offsetCurrentY + 0.5 - negateOriginalY)), (double)((int)Math.floor((double)offsetCurrentZ + 0.5 - negateOriginalZ)));
        hasMutatedSelectionRegion = true;
        class_243 offsetFromCenter = new class_243(ModifySelection.originalSelectionCenter.field_1352 - ((double)offsetCurrentX + 0.5), ModifySelection.originalSelectionCenter.field_1351 - ((double)offsetCurrentY + 0.5), ModifySelection.originalSelectionCenter.field_1350 - ((double)offsetCurrentZ + 0.5));
        gizmo.setOffsetInstantly(offsetFromCenter);
    }

    public static void flip(class_2350.class_2351 axis) {
        ModifySelection.applyIfScaled();
        class_2338 offsetCurrent = gizmo.getTargetPosition();
        double negateOriginalX = ModifySelection.originalSelectionCenter.field_1352;
        double negateOriginalY = ModifySelection.originalSelectionCenter.field_1351;
        double negateOriginalZ = ModifySelection.originalSelectionCenter.field_1350;
        int offsetCurrentX = offsetCurrent.method_10263();
        int offsetCurrentY = offsetCurrent.method_10264();
        int offsetCurrentZ = offsetCurrent.method_10260();
        ChunkedBooleanRegion region = new ChunkedBooleanRegion();
        switch (axis) {
            case field_11048: {
                selectionRegion.forEach((x, y, z) -> region.add((int)Math.floor((double)offsetCurrentX - ((double)x + 0.5 - negateOriginalX)), (int)Math.floor((double)offsetCurrentY + ((double)y + 0.5 - negateOriginalY)), (int)Math.floor((double)offsetCurrentZ + ((double)z + 0.5 - negateOriginalZ))));
                break;
            }
            case field_11052: {
                selectionRegion.forEach((x, y, z) -> region.add((int)Math.floor((double)offsetCurrentX + ((double)x + 0.5 - negateOriginalX)), (int)Math.floor((double)offsetCurrentY - ((double)y + 0.5 - negateOriginalY)), (int)Math.floor((double)offsetCurrentZ + ((double)z + 0.5 - negateOriginalZ))));
                break;
            }
            case field_11051: {
                selectionRegion.forEach((x, y, z) -> region.add((int)Math.floor((double)offsetCurrentX + ((double)x + 0.5 - negateOriginalX)), (int)Math.floor((double)offsetCurrentY + ((double)y + 0.5 - negateOriginalY)), (int)Math.floor((double)offsetCurrentZ - ((double)z + 0.5 - negateOriginalZ))));
            }
        }
        selectionRegion = region;
        originalSelectionCenter = originalSelectionCenter.method_1031((double)((int)Math.floor((double)offsetCurrentX + 0.5 - negateOriginalX)), (double)((int)Math.floor((double)offsetCurrentY + 0.5 - negateOriginalY)), (double)((int)Math.floor((double)offsetCurrentZ + 0.5 - negateOriginalZ)));
        hasMutatedSelectionRegion = true;
        class_243 offsetFromCenter = new class_243(ModifySelection.originalSelectionCenter.field_1352 - ((double)offsetCurrentX + 0.5), ModifySelection.originalSelectionCenter.field_1351 - ((double)offsetCurrentY + 0.5), ModifySelection.originalSelectionCenter.field_1350 - ((double)offsetCurrentZ + 0.5));
        gizmo.setOffsetInstantly(offsetFromCenter);
    }

    public static void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        Gizmo.GizmoScale peekedScale;
        Gizmo.GizmoScale poppedScale;
        boolean showGizmo;
        if (gizmo == null) {
            return;
        }
        if (!EditorUI.isActive() || ToolManager.isToolActive()) {
            ModifySelection.finish();
            return;
        }
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown(0);
        boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
        boolean bl = showGizmo = !isCtrlDown;
        if (lookDirection != null) {
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
        }
        if ((poppedScale = gizmo.popScale()) != null) {
            float scaleX = poppedScale.getScaleX();
            float scaleY = poppedScale.getScaleY();
            float scaleZ = poppedScale.getScaleZ();
            lastScaleX = appliedScaleX *= scaleX;
            lastScaleY = appliedScaleY *= scaleY;
            lastScaleZ = appliedScaleZ *= scaleZ;
            scaledSelectionRegion = ModifySelection.createScaled(appliedScaleX, appliedScaleY, appliedScaleZ);
        }
        if ((peekedScale = gizmo.peekScale()) != null) {
            float scaleX = peekedScale.getScaleX() * appliedScaleX;
            float scaleY = peekedScale.getScaleY() * appliedScaleY;
            float scaleZ = peekedScale.getScaleZ() * appliedScaleZ;
            if (scaleX != lastScaleX || scaleY != lastScaleY || scaleZ != lastScaleZ) {
                lastScaleX = scaleX;
                lastScaleY = scaleY;
                lastScaleZ = scaleZ;
                scaledSelectionRegion = ModifySelection.createScaled(scaleX, scaleY, scaleZ);
            }
        }
        if (scaledSelectionRegion != null) {
            class_243 translation = gizmo.getInterpPosition();
            translation = translation.method_1020(originalSelectionCenter);
            scaledSelectionRegion.render(camera, translation, matrices, projection, time, 7);
        } else {
            class_243 translation = gizmo.getInterpPosition();
            translation = translation.method_1020(originalSelectionCenter);
            selectionRegion.render(camera, translation, matrices, projection, time, 7);
        }
        if (gizmo.isGrabbed() || showGizmo) {
            gizmo.render(matrices, camera, isCtrlDown);
        }
    }

    public static ChunkedBooleanRegion createScaled(float scaleX, float scaleY, float scaleZ) {
        if ((double)Math.abs(scaleX) < 1.0E-7 || (double)Math.abs(scaleY) < 1.0E-7 || (double)Math.abs(scaleZ) < 1.0E-7) {
            return new ChunkedBooleanRegion();
        }
        class_2338 min2 = selectionRegion.min();
        class_2338 max2 = selectionRegion.max();
        double centerX = ModifySelection.originalSelectionCenter.field_1352;
        double centerY = ModifySelection.originalSelectionCenter.field_1351;
        double centerZ = ModifySelection.originalSelectionCenter.field_1350;
        int minX = (int)Math.floor(((double)min2.method_10263() - centerX) * (double)scaleX + centerX) - 1;
        int minY = (int)Math.floor(((double)min2.method_10264() - centerY) * (double)scaleY + centerY) - 1;
        int minZ = (int)Math.floor(((double)min2.method_10260() - centerZ) * (double)scaleZ + centerZ) - 1;
        int maxX = (int)Math.ceil(((double)(max2.method_10263() + 1) - centerX) * (double)scaleX + centerX) + 1;
        int maxY = (int)Math.ceil(((double)(max2.method_10264() + 1) - centerY) * (double)scaleY + centerY) + 1;
        int maxZ = (int)Math.ceil(((double)(max2.method_10260() + 1) - centerZ) * (double)scaleZ + centerZ) + 1;
        ChunkedBooleanRegion region = new ChunkedBooleanRegion();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int newZ;
                    int newY;
                    int newX = (int)Math.floor(((double)((float)x + 0.5f) - centerX) / (double)scaleX + centerX);
                    if (!selectionRegion.contains(newX, newY = (int)Math.floor(((double)((float)y + 0.5f) - centerY) / (double)scaleY + centerY), newZ = (int)Math.floor(((double)((float)z + 0.5f) - centerZ) / (double)scaleZ + centerZ))) continue;
                    region.add(x, y, z);
                }
            }
        }
        return region;
    }

    public static boolean isModifyingSelection() {
        return gizmo != null;
    }
}

