/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.mojang.datafixers.util.Pair;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.DefaultBlocks;
import com.moulberry.axiom.collections.JoinedList;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.datagen.MaterialBlockTagGenerator;
import com.moulberry.axiom.editor.palette.CustomBlockStateOrTombstone;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.ImportantBlocks;
import com.moulberry.axiom.utils.WeirdTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_1124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BlockList {
    private boolean needsReload = true;
    private String lastNameSearch = "";
    private Set<String> lastFilteredTags = Set.of();
    private Set<String> lastEffectiveFilteredTags = Set.of();
    private Set<String> lastFilteredNamespaces = Set.of();
    private String lastSearchRaw = "";
    private Predicate<CustomBlockState> lastFilter = null;
    private List<Entry> searchedBlocks;
    private List<TagEntry> searchedTags;
    private final List<Entry> blocksStartsWith = new ArrayList<Entry>();
    private final List<Entry> blocksContains = new ArrayList<Entry>();
    private final List<TagEntry> tagsStartsWith = new ArrayList<TagEntry>();
    private final List<TagEntry> tagsContains = new ArrayList<TagEntry>();
    private List<Entry> blocksAll = List.of();
    private List<Entry> blocksAllLengthSorted;
    private List<TagEntry> tagsAll;
    private List<TagEntry> tagsAllLengthSorted;
    private static final Set<class_2960> BUILTIN_AXIOM_TAGS = Set.of(class_2960.method_60654((String)"axiom:concrete"), class_2960.method_60654((String)"axiom:concrete_powder"), class_2960.method_60654((String)"axiom:grayscale_blocks"), class_2960.method_60654((String)"axiom:infested_blocks"), class_2960.method_60654((String)"axiom:ore_blocks"), class_2960.method_60654((String)"axiom:precious_materials"), class_2960.method_60654((String)"axiom:tree_blocks"), class_2960.method_60654((String)"axiom:can_be_waterlogged"), class_2960.method_60654((String)"axiom:colored_blocks"), class_2960.method_60654((String)"axiom:existing"), class_2960.method_60654((String)"axiom:falling_blocks"), class_2960.method_60654((String)"axiom:nonsolid"), class_2960.method_60654((String)"axiom:plants"), class_2960.method_60654((String)"axiom:solid"), class_2960.method_60654((String)"axiom:stained_glass"), class_2960.method_60654((String)"axiom:underwater_plants"));

    private static List<class_2960> sortedList(Set<class_2960> set) {
        if (set == null) {
            return null;
        }
        ArrayList<class_2960> list = new ArrayList<class_2960>(set);
        list.sort(class_2960::method_12833);
        return list;
    }

    public BlockList() {
        this.searchedBlocks = this.blocksAll;
        this.blocksAllLengthSorted = List.of();
        this.tagsAll = List.of();
        this.searchedTags = this.tagsAll;
        this.tagsAllLengthSorted = List.of();
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                this.markNeedsReload();
            }
        });
    }

    public void markNeedsReload() {
        this.needsReload = true;
    }

    /*
     * WARNING - void declaration
     */
    private void doReload() {
        void var5_19;
        void var5_17;
        boolean result;
        this.needsReload = false;
        ArrayList<Entry> blocksAll = new ArrayList<Entry>();
        HashSet<class_2248> processedBlocks = new HashSet<class_2248>();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (result = class_7706.method_47330((class_7699)player.field_3944.method_45735(), (player.method_7338() && (Boolean)class_310.method_1551().field_1690.method_47395().method_41753() != false ? 1 : 0) != 0, (class_7225.class_7874)player.method_73183().method_30349()))) {
            class_1124 class_11242 = player.field_3944.method_60347();
            List list = List.copyOf(class_7706.method_47344().method_47313());
            class_11242.method_60357((class_7225.class_7874)player.method_73183().method_30349(), list);
            class_11242.method_60355(list);
        }
        for (class_2248 class_22482 : ImportantBlocks.IMPORTANT_BLOCKS) {
            BlockList.addBlockToAll(blocksAll, processedBlocks, class_22482, true);
        }
        for (Map.Entry entry2 : ServerCustomBlocks.customBlockMap.entrySet()) {
            CustomBlockState state = ((CustomBlock)entry2.getValue()).axiom$defaultCustomState();
            class_1767[] name = AxiomI18n.get(((CustomBlock)entry2.getValue()).axiom$translationKey());
            Entry entry22 = new Entry(state, (class_2960)entry2.getKey(), ((class_2960)entry2.getKey()).method_12832(), BlockList.createSearchKey((String)name), ((CustomBlock)entry2.getValue()).axiom$translationKey());
            blocksAll.add(entry22);
        }
        for (class_1799 class_17992 : class_7706.method_47344().method_45414()) {
            class_2248 block = class_2248.method_9503((class_1792)class_17992.method_7909());
            BlockList.addBlockToAll(blocksAll, processedBlocks, block, false);
        }
        for (class_2248 class_22483 : class_7923.field_41175) {
            BlockList.addBlockToAll(blocksAll, processedBlocks, class_22483, false);
        }
        this.blocksAll = Collections.unmodifiableList(blocksAll);
        this.searchedBlocks = this.blocksAll;
        ArrayList<Entry> blocksAllLengthSorted = new ArrayList<Entry>(blocksAll);
        blocksAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.blocksAllLengthSorted = Collections.unmodifiableList(blocksAllLengthSorted);
        List<TagEntry> list = class_7923.field_41175.method_40272().map(named -> Pair.of((Object)named.method_40251(), (Object)named)).sorted(Comparator.comparing(o -> WeirdTags.isWeird((class_6862<class_2248>)((class_6862)o.getFirst()))).thenComparing(o -> !((class_6862)o.getFirst()).comp_327().method_12836().equals("axiom")).thenComparingInt(o -> -((class_6885.class_6888)o.getSecond()).method_40247()).thenComparing(o -> ((class_6862)o.getFirst()).comp_327().method_12832())).map(e -> new TagEntry(new MinecraftOrCustomTagSet(((class_6862)e.getFirst()).comp_327(), (class_6885<class_2248>)((class_6885)e.getSecond()), null), ((class_6862)e.getFirst()).comp_327(), BlockList.createSearchKey(((class_6862)e.getFirst()).comp_327().toString()))).toList();
        if (Axiom.configuration.internal.rootEditorPalette != null) {
            ArrayList<TagEntry> customTags = new ArrayList<TagEntry>();
            BlockList.addCustomTags("", Axiom.configuration.internal.rootEditorPalette, customTags);
            customTags.addAll(list);
            List<TagEntry> list2 = Collections.unmodifiableList(customTags);
        }
        ArrayList<class_2960> builtinTagNames = new ArrayList<class_2960>(BUILTIN_AXIOM_TAGS);
        for (class_1767 dyeColor : class_1767.values()) {
            builtinTagNames.add(class_2960.method_60654((String)("color:" + dyeColor.method_7792())));
        }
        for (String value : MaterialBlockTagGenerator.blockToMaterialMap.values()) {
            builtinTagNames.add(class_2960.method_60654((String)("material:" + value)));
        }
        for (String value : MaterialBlockTagGenerator.setTypeToMaterialMap.values()) {
            builtinTagNames.add(class_2960.method_60654((String)("material:" + value)));
        }
        for (String value : MaterialBlockTagGenerator.woodTypeToMaterialMap.values()) {
            builtinTagNames.add(class_2960.method_60654((String)("material:" + value)));
        }
        ArrayList<TagEntry> builtinTags = new ArrayList<TagEntry>();
        block8: for (class_2960 builtinAxiomTag : builtinTagNames) {
            for (TagEntry tagEntry : var5_17) {
                if (!tagEntry.tag.name.equals((Object)builtinAxiomTag)) continue;
                continue block8;
            }
            Set clientTag = ClientTags.getOrCreateLocalTag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)builtinAxiomTag));
            if (clientTag == null || clientTag.isEmpty()) continue;
            String searchKey = BlockList.createSearchKey(builtinAxiomTag.toString());
            builtinTags.add(new TagEntry(new MinecraftOrCustomTagSet(builtinAxiomTag, null, clientTag), builtinAxiomTag, searchKey));
        }
        if (!builtinTags.isEmpty()) {
            builtinTags.addAll((Collection<TagEntry>)var5_17);
            List list3 = Collections.unmodifiableList(builtinTags);
        }
        this.tagsAll = var5_19;
        this.searchedTags = this.tagsAll;
        ArrayList<TagEntry> tagsAllLengthSorted = new ArrayList<TagEntry>((Collection<TagEntry>)var5_19);
        tagsAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.tag.name.method_12832().length()));
        this.tagsAllLengthSorted = Collections.unmodifiableList(tagsAllLengthSorted);
        this.lastNameSearch = "";
        this.lastFilteredTags = Set.of();
        this.lastFilteredNamespaces = Set.of();
        this.lastSearchRaw = "";
        this.lastFilter = null;
    }

    private static void addCustomTags(String prefix, EditorPalette editorPalette, List<TagEntry> tags) {
        for (EditorPalette subcategory : editorPalette.getSubcategories()) {
            String name = subcategory.getName().toLowerCase(Locale.ROOT);
            StringBuilder pathBuilder = new StringBuilder();
            for (char c : name.toCharArray()) {
                if (!class_2960.method_29184((char)c)) continue;
                pathBuilder.append(c);
            }
            Object currentPath = pathBuilder.toString();
            if (((String)currentPath).isEmpty()) {
                currentPath = "unknown";
            }
            currentPath = prefix + (String)currentPath;
            if (!subcategory.getBlocks().isEmpty()) {
                HashSet<class_2960> blocks = new HashSet<class_2960>();
                for (CustomBlockStateOrTombstone block : subcategory.getBlocks()) {
                    if (!(block instanceof CustomBlockState)) continue;
                    CustomBlockState customBlockState = (CustomBlockState)block;
                    blocks.add(customBlockState.getVanillaState().method_26204().method_40142().method_40237().method_29177());
                }
                if (!blocks.isEmpty()) {
                    class_2960 location = class_2960.method_60655((String)"custom", (String)currentPath);
                    String searchKey = BlockList.createSearchKey(location.toString());
                    tags.add(new TagEntry(new MinecraftOrCustomTagSet(location, null, blocks), location, searchKey));
                }
            }
            BlockList.addCustomTags(prefix + (String)currentPath + "/", subcategory, tags);
        }
    }

    private static void addBlockToAll(ArrayList<Entry> all, Set<class_2248> processedBlocks, class_2248 block, boolean allowAir) {
        if (processedBlocks.contains(block)) {
            return;
        }
        if (!allowAir && block.method_9564().method_26215()) {
            return;
        }
        if (block instanceof class_2667) {
            return;
        }
        Entry entry = BlockList.createEntry(block.method_9564());
        all.add(entry);
        processedBlocks.add(block);
    }

    public static Entry createEntry(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        class_2960 location = class_7923.field_41175.method_10221((Object)block);
        CustomBlockState state = (CustomBlockState)DefaultBlocks.applyDefaultProperties(blockState);
        String name = AxiomI18n.get(block.method_63499());
        return new Entry(state, location, location.method_12832(), BlockList.createSearchKey(name), block.method_63499());
    }

    private static String createSearchKey(String string) {
        StringBuilder searchKey = new StringBuilder();
        for (char c : string.toLowerCase(Locale.ROOT).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            searchKey.append(c);
        }
        return searchKey.toString();
    }

    public void search(String search) {
        this.search(search, null);
    }

    public void search(String search, Predicate<CustomBlockState> filter) {
        this.search(search, filter, false);
    }

    public void search(String search, Predicate<CustomBlockState> filter, boolean force) {
        HashSet<class_2960> tagFilteredLocations;
        boolean forceBlock;
        String[] split;
        if (this.needsReload) {
            this.doReload();
            force = true;
        }
        search = search.toLowerCase(Locale.ROOT);
        if (!force && search.equals(this.lastSearchRaw) && filter == this.lastFilter) {
            return;
        }
        this.lastSearchRaw = search;
        HashSet<String> filteredTags = new HashSet<String>();
        HashSet<String> filteredNamespaces = new HashSet<String>();
        StringBuilder searchBuilder = new StringBuilder();
        for (String s2 : split = search.split(" ")) {
            if (s2.startsWith("#")) {
                String tag = s2.substring(1);
                if (tag.isEmpty()) continue;
                filteredTags.add(tag);
                continue;
            }
            if (s2.startsWith("@")) {
                Object namespace = s2.substring(1);
                if (((String)namespace).isEmpty()) continue;
                filteredNamespaces.add((String)namespace);
                continue;
            }
            for (char c : s2.toCharArray()) {
                if (Character.isWhitespace(c)) continue;
                searchBuilder.append(c);
            }
        }
        search = searchBuilder.toString();
        boolean bl = forceBlock = force || !filteredTags.equals(this.lastFilteredTags) || !filteredNamespaces.equals(this.lastFilteredNamespaces);
        if (!forceBlock && search.equals(this.lastNameSearch) && filter == this.lastFilter) {
            return;
        }
        this.searchTags(search, filteredTags, force);
        HashSet<class_2248> tagFilteredBlocks = filteredTags.isEmpty() ? null : new HashSet<class_2248>();
        HashSet<class_2960> hashSet = tagFilteredLocations = filteredTags.isEmpty() ? null : new HashSet<class_2960>();
        if (!filteredTags.isEmpty()) {
            for (TagEntry searchedTag : this.searchedTags) {
                Set<class_2960> custom;
                class_6885<class_2248> minecraft = searchedTag.tag.minecraft;
                if (minecraft != null) {
                    for (class_6880 blockHolder : minecraft) {
                        tagFilteredBlocks.add((class_2248)blockHolder.comp_349());
                    }
                }
                if ((custom = searchedTag.tag.customSet) == null) continue;
                tagFilteredLocations.addAll(custom);
            }
        }
        if (search.isBlank()) {
            this.doBlockSearchBlank(filter, tagFilteredBlocks, tagFilteredLocations, filteredNamespaces);
        } else {
            this.doBlockSearchByName(search, filter, tagFilteredBlocks, tagFilteredLocations, filteredNamespaces, forceBlock);
        }
        this.lastNameSearch = search;
        this.lastFilteredNamespaces = filteredNamespaces;
        this.lastFilteredTags = filteredTags;
        this.lastFilter = filter;
    }

    private boolean shouldSearchTagsFromScratch(Set<String> filteredTags) {
        JoinedList joined;
        List<TagEntry> list = this.searchedTags;
        if (!(list instanceof JoinedList) || (joined = (JoinedList)list).first() != this.tagsStartsWith || joined.second() != this.tagsContains) {
            return true;
        }
        for (String filteredTag : filteredTags) {
            boolean hasStartsWith = false;
            for (String lastEffectiveFilteredTag : this.lastEffectiveFilteredTags) {
                if (!filteredTag.startsWith(lastEffectiveFilteredTag)) continue;
                hasStartsWith = true;
                break;
            }
            if (hasStartsWith) continue;
            return true;
        }
        return false;
    }

    private void searchTags(String search, Set<String> filteredTags, boolean force) {
        if (filteredTags.isEmpty()) {
            if (search.isBlank()) {
                this.searchedTags = this.tagsAll;
                return;
            }
            filteredTags = Set.of(search);
        }
        if (force || this.shouldSearchTagsFromScratch(filteredTags)) {
            this.tagsStartsWith.clear();
            this.tagsContains.clear();
            for (TagEntry entry2 : this.tagsAllLengthSorted) {
                boolean contains = false;
                for (String filteredTag : filteredTags) {
                    if (entry2.location.method_12832().startsWith(filteredTag)) {
                        this.tagsStartsWith.add(entry2);
                        contains = false;
                        break;
                    }
                    if (!entry2.searchKey.contains(filteredTag)) continue;
                    contains = true;
                }
                if (!contains) continue;
                this.tagsContains.add(entry2);
            }
            this.searchedTags = new JoinedList<TagEntry>(this.tagsStartsWith, this.tagsContains);
        } else {
            Set<String> filteredTagsF = filteredTags;
            this.tagsContains.removeIf(entry -> {
                for (String filteredTag : filteredTagsF) {
                    if (!entry.searchKey.contains(filteredTag)) continue;
                    return false;
                }
                return true;
            });
            this.tagsStartsWith.removeIf(entry -> {
                boolean contains = false;
                for (String filteredTag : filteredTagsF) {
                    if (entry.location.method_12832().startsWith(filteredTag)) {
                        return false;
                    }
                    if (!entry.searchKey.contains(filteredTag)) continue;
                    contains = true;
                }
                if (contains) {
                    this.tagsContains.add((TagEntry)entry);
                }
                return true;
            });
        }
        this.lastEffectiveFilteredTags = filteredTags;
    }

    private void doBlockSearchBlank(Predicate<CustomBlockState> filter, Set<class_2248> tagFilteredBlocks, Set<class_2960> tagFilteredLocations, Set<String> filteredNamespaces) {
        boolean hasTagFiltered;
        boolean bl = hasTagFiltered = tagFilteredBlocks != null || tagFilteredLocations != null;
        if (hasTagFiltered) {
            if (tagFilteredBlocks == null) {
                tagFilteredBlocks = Set.of();
            }
            if (tagFilteredLocations == null) {
                tagFilteredLocations = Set.of();
            }
        }
        if (filter != null || hasTagFiltered || !filteredNamespaces.isEmpty()) {
            this.searchedBlocks = new ArrayList<Entry>();
            if (hasTagFiltered && tagFilteredBlocks.isEmpty() && tagFilteredLocations.isEmpty()) {
                return;
            }
            for (Entry entry : this.blocksAll) {
                if (filter != null && !filter.test(entry.state)) continue;
                if (!filteredNamespaces.isEmpty()) {
                    boolean namespaceMatch = false;
                    for (String filteredNamespace : filteredNamespaces) {
                        if (!entry.location.method_12836().startsWith(filteredNamespace)) continue;
                        namespaceMatch = true;
                        break;
                    }
                    if (!namespaceMatch) continue;
                }
                if (hasTagFiltered) {
                    class_2680 blockState;
                    boolean matchesTagFilter = false;
                    CustomBlockState customBlockState = entry.state;
                    if (customBlockState instanceof class_2680 && tagFilteredBlocks.contains((blockState = (class_2680)customBlockState).method_26204())) {
                        matchesTagFilter = true;
                    }
                    if (!matchesTagFilter && tagFilteredLocations.contains(entry.location)) {
                        matchesTagFilter = true;
                    }
                    if (!matchesTagFilter) continue;
                }
                this.searchedBlocks.add(entry);
            }
        } else {
            this.searchedBlocks = this.blocksAll;
        }
    }

    private void doBlockSearchByName(String search, Predicate<CustomBlockState> filter, Set<class_2248> tagFilteredBlocks, Set<class_2960> tagFilteredLocations, Set<String> filteredNamespaces, boolean force) {
        JoinedList joined;
        Object object;
        boolean hasTagFiltered;
        boolean bl = hasTagFiltered = tagFilteredBlocks != null || tagFilteredLocations != null;
        if (hasTagFiltered) {
            if (tagFilteredBlocks == null) {
                tagFilteredBlocks = Set.of();
            }
            if (tagFilteredLocations == null) {
                tagFilteredLocations = Set.of();
            }
        }
        if (force || !((object = this.searchedBlocks) instanceof JoinedList) || (joined = (JoinedList)object).first() != this.blocksStartsWith || joined.second() != this.blocksContains || !search.startsWith(this.lastNameSearch) || filter != this.lastFilter) {
            this.blocksStartsWith.clear();
            this.blocksContains.clear();
            if (hasTagFiltered && tagFilteredBlocks.isEmpty() && tagFilteredLocations.isEmpty()) {
                return;
            }
            for (Entry entry2 : this.blocksAllLengthSorted) {
                if (filter != null && !filter.test(entry2.state)) continue;
                if (!filteredNamespaces.isEmpty()) {
                    boolean namespaceMatch = false;
                    for (String filteredNamespace : filteredNamespaces) {
                        if (!entry2.location.method_12836().startsWith(filteredNamespace)) continue;
                        namespaceMatch = true;
                        break;
                    }
                    if (!namespaceMatch) continue;
                }
                if (hasTagFiltered) {
                    class_2680 blockState;
                    boolean matchesTagFilter = false;
                    CustomBlockState customBlockState = entry2.state;
                    if (customBlockState instanceof class_2680 && tagFilteredBlocks.contains((blockState = (class_2680)customBlockState).method_26204())) {
                        matchesTagFilter = true;
                    }
                    if (!matchesTagFilter && tagFilteredLocations.contains(entry2.location)) {
                        matchesTagFilter = true;
                    }
                    if (!matchesTagFilter) continue;
                }
                if (entry2.searchKeyId.startsWith(search) || entry2.searchKeyLocalized.startsWith(search)) {
                    this.blocksStartsWith.add(entry2);
                    continue;
                }
                if (!entry2.searchKeyId.contains(search) && !entry2.searchKeyLocalized.contains(search)) continue;
                this.blocksContains.add(entry2);
            }
            this.searchedBlocks = new JoinedList<Entry>(this.blocksStartsWith, this.blocksContains);
        } else {
            String searchF = search;
            this.blocksContains.removeIf(entry -> !entry.searchKeyId.contains(searchF) && !entry.searchKeyLocalized.contains(searchF));
            this.blocksStartsWith.removeIf(entry -> {
                if (entry.searchKeyId.startsWith(searchF) || entry.searchKeyLocalized.startsWith(searchF)) {
                    return false;
                }
                if (entry.searchKeyId.contains(searchF) || entry.searchKeyLocalized.contains(searchF)) {
                    this.blocksContains.add((Entry)entry);
                }
                return true;
            });
        }
    }

    public String getLastSearchRaw() {
        return this.lastSearchRaw;
    }

    public List<Entry> getBlocks() {
        if (this.needsReload) {
            this.doReload();
        }
        return this.searchedBlocks;
    }

    public List<TagEntry> getTags() {
        if (this.needsReload) {
            this.doReload();
        }
        return this.searchedTags;
    }

    public record Entry(CustomBlockState state, class_2960 location, String searchKeyId, String searchKeyLocalized, String translationKey) {
    }

    public record TagEntry(MinecraftOrCustomTagSet tag, class_2960 location, String searchKey) {
    }

    public record MinecraftOrCustomTagSet(class_2960 name, @Nullable class_6885<class_2248> minecraft, @Nullable List<class_2960> customList, @Nullable Set<class_2960> customSet) {
        public MinecraftOrCustomTagSet(class_2960 name, @Nullable class_6885<class_2248> minecraft, @Nullable Set<class_2960> customSet) {
            this(name, minecraft, BlockList.sortedList(customSet), customSet);
        }
    }
}

