/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.palette;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.palette.CustomBlockStateOrTombstone;
import com.moulberry.axiom.editor.palette.EditorPaletteTombstone;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class EditorPalette {
    public static int OFFSET_PREVIOUS = 0;
    public static int OFFSET_NEXT = 1;
    public static int OFFSET_AS_LAST_CHILD = 2;
    public static int OFFSET_AS_FIRST_CHILD = 3;
    private final Map<String, EditorPalette> subcategories;
    @Nullable
    private EditorPalette parent = null;
    @Nullable
    private EditorPalette childHead = null;
    @Nullable
    private EditorPalette childTail = null;
    @Nullable
    private EditorPalette siblingNext = null;
    @Nullable
    private EditorPalette siblingPrev = null;
    private List<CustomBlockStateOrTombstone> blocks = new ArrayList<CustomBlockStateOrTombstone>();
    private boolean isOpen = false;
    private String name;
    private boolean needsReload = false;

    public EditorPalette(String name) {
        this.name = name.replace("#", "");
        this.subcategories = new HashMap<String, EditorPalette>();
    }

    public static EditorPalette loadFromLegacyConfig(String name, ConfigurationNode node) throws SerializationException {
        EditorPalette palette = new EditorPalette(name);
        ConfigurationNode blocks = node.node("blocks");
        List<String> blocksString = blocks.getList(String.class);
        if (blocksString != null) {
            for (String string : blocksString) {
                CustomBlockState customBlockState = ServerCustomBlocks.deserialize(string);
                if (customBlockState != null) {
                    palette.addBlock(customBlockState);
                    continue;
                }
                palette.addTombstone(string);
            }
        }
        for (Map.Entry entry : node.childrenMap().entrySet()) {
            String subname = entry.getKey().toString();
            if (!subname.startsWith("c_")) continue;
            subname = subname.substring(2);
            palette.addSubcategory(EditorPalette.loadFromLegacyConfig(subname, (ConfigurationNode)entry.getValue()));
        }
        return palette;
    }

    public void markNeedsReload() {
        this.needsReload = true;
    }

    public void reloadIfNeeded() {
        if (this.needsReload) {
            this.reload();
        }
    }

    private void reload() {
        this.needsReload = false;
        List<CustomBlockStateOrTombstone> blocks = this.blocks;
        this.blocks = new ArrayList<CustomBlockStateOrTombstone>();
        for (CustomBlockStateOrTombstone block : blocks) {
            String serialized;
            CustomBlockState customBlockState;
            if (block instanceof class_2680) {
                class_2680 blockState = (class_2680)block;
                this.addBlock((CustomBlockState)blockState);
                continue;
            }
            if (block instanceof CustomBlockState) {
                customBlockState = (CustomBlockState)block;
                serialized = ServerCustomBlocks.serialize(customBlockState);
            } else if (block instanceof EditorPaletteTombstone) {
                EditorPaletteTombstone tombstone = (EditorPaletteTombstone)block;
                serialized = tombstone.key();
            } else {
                throw new FaultyImplementationError();
            }
            customBlockState = ServerCustomBlocks.deserialize(serialized);
            if (customBlockState != null) {
                this.addBlock(customBlockState);
                continue;
            }
            this.addTombstone(serialized);
        }
        for (EditorPalette child : this.subcategories.values()) {
            child.reload();
        }
    }

    public EditorPalette createSubcategory(String name) {
        return this.createSubcategory(name, OFFSET_AS_LAST_CHILD);
    }

    public EditorPalette createSubcategory(String name, int offset) {
        this.onChanged();
        name = name.replace("#", "");
        if (offset == OFFSET_AS_LAST_CHILD || offset == OFFSET_AS_FIRST_CHILD) {
            if (this.subcategories.containsKey(name)) {
                return null;
            }
            EditorPalette subcategory = new EditorPalette(name);
            subcategory.parent = this;
            if (this.childHead == null || this.childTail == null) {
                this.childHead = this.childTail = subcategory;
            } else if (offset == OFFSET_AS_LAST_CHILD) {
                this.childTail.siblingNext = subcategory;
                subcategory.siblingPrev = this.childTail;
                this.childTail = subcategory;
            } else if (offset == OFFSET_AS_FIRST_CHILD) {
                this.childHead.siblingPrev = subcategory;
                subcategory.siblingNext = this.childHead;
                this.childHead = subcategory;
            }
            this.subcategories.put(name, subcategory);
            return subcategory;
        }
        if (offset == OFFSET_PREVIOUS || offset == OFFSET_NEXT) {
            if (this.parent == null) {
                return null;
            }
            if (this.parent.subcategories.containsKey(name)) {
                return null;
            }
            EditorPalette subcategory = new EditorPalette(name);
            subcategory.parent = this.parent;
            if (offset == OFFSET_PREVIOUS) {
                if (this.parent.childHead == this) {
                    this.parent.childHead = subcategory;
                }
                if (this.siblingPrev != null) {
                    subcategory.siblingPrev = this.siblingPrev;
                    this.siblingPrev.siblingNext = subcategory;
                }
                this.siblingPrev = subcategory;
                subcategory.siblingNext = this;
            } else if (offset == OFFSET_NEXT) {
                if (this.parent.childTail == this) {
                    this.parent.childTail = subcategory;
                }
                if (this.siblingNext != null) {
                    subcategory.siblingNext = this.siblingNext;
                    this.siblingNext.siblingPrev = subcategory;
                }
                this.siblingNext = subcategory;
                subcategory.siblingPrev = this;
            }
            this.parent.subcategories.put(name, subcategory);
            return subcategory;
        }
        throw new IllegalArgumentException(offset + " is not a valid offset");
    }

    public boolean isParentOf(EditorPalette child) {
        if (child.parent == this) {
            return true;
        }
        for (EditorPalette subcategory : this.subcategories.values()) {
            if (subcategory == child) {
                return true;
            }
            if (!subcategory.isParentOf(child)) continue;
            return true;
        }
        return false;
    }

    public void addSubcategory(EditorPalette subcategory) {
        this.addSubcategory(subcategory, OFFSET_AS_LAST_CHILD);
    }

    public void addSubcategory(EditorPalette subcategory, int offset) {
        this.onChanged();
        if (subcategory == this) {
            throw new IllegalStateException("Cannot add palette to itself");
        }
        if (subcategory.parent != null) {
            throw new IllegalArgumentException("Subcategory must not already have a parent");
        }
        if (subcategory.siblingNext != null || subcategory.siblingPrev != null) {
            throw new IllegalArgumentException("Subcategory must not already have a sibling");
        }
        Object name = subcategory.getName();
        String originalName = subcategory.getName();
        int duplicateIndex = 1;
        if (offset == OFFSET_AS_LAST_CHILD || offset == OFFSET_AS_FIRST_CHILD) {
            while (this.subcategories.containsKey(name)) {
                String end = " (" + duplicateIndex + ")";
                name = originalName.substring(0, Math.min(originalName.length(), 32 - end.length())) + end;
                ++duplicateIndex;
            }
            if (!((String)name).equals(originalName) && !subcategory.rename((String)name)) {
                throw new RuntimeException("Unable to rename, even though we checked collisions");
            }
            subcategory.parent = this;
            if (this.childHead == null || this.childTail == null) {
                this.childHead = this.childTail = subcategory;
            } else if (offset == OFFSET_AS_LAST_CHILD) {
                this.childTail.siblingNext = subcategory;
                subcategory.siblingPrev = this.childTail;
                this.childTail = subcategory;
            } else if (offset == OFFSET_AS_FIRST_CHILD) {
                this.childHead.siblingPrev = subcategory;
                subcategory.siblingNext = this.childHead;
                this.childHead = subcategory;
            }
            this.subcategories.put((String)name, subcategory);
        } else if (offset == OFFSET_PREVIOUS || offset == OFFSET_NEXT) {
            if (this.parent == null) {
                return;
            }
            while (this.parent.subcategories.containsKey(name)) {
                String end = " (" + duplicateIndex + ")";
                name = originalName.substring(0, Math.min(originalName.length(), 32 - end.length())) + end;
                ++duplicateIndex;
            }
            if (!((String)name).equals(originalName) && !subcategory.rename((String)name)) {
                throw new RuntimeException("Unable to rename, even though we checked collisions");
            }
            subcategory.parent = this.parent;
            if (offset == OFFSET_PREVIOUS) {
                if (this.parent.childHead == this) {
                    this.parent.childHead = subcategory;
                }
                if (this.siblingPrev != null) {
                    subcategory.siblingPrev = this.siblingPrev;
                    this.siblingPrev.siblingNext = subcategory;
                }
                this.siblingPrev = subcategory;
                subcategory.siblingNext = this;
            } else if (offset == OFFSET_NEXT) {
                if (this.parent.childTail == this) {
                    this.parent.childTail = subcategory;
                }
                if (this.siblingNext != null) {
                    subcategory.siblingNext = this.siblingNext;
                    this.siblingNext.siblingPrev = subcategory;
                }
                this.siblingNext = subcategory;
                subcategory.siblingPrev = this;
            }
            this.parent.subcategories.put((String)name, subcategory);
        } else {
            throw new IllegalArgumentException(offset + " is not a valid offset");
        }
    }

    public void remove() {
        if (this.parent == null) {
            throw new IllegalStateException();
        }
        EditorPalette removed = this.parent.subcategories.remove(this.name);
        if (removed != this) {
            throw new IllegalStateException();
        }
        if (this.parent.childHead == this) {
            this.parent.childHead = this.siblingNext;
        }
        if (this.parent.childTail == this) {
            this.parent.childTail = this.siblingPrev;
        }
        if (this.siblingPrev != null) {
            this.siblingPrev.siblingNext = this.siblingNext;
        }
        if (this.siblingNext != null) {
            this.siblingNext.siblingPrev = this.siblingPrev;
        }
        this.siblingPrev = null;
        this.siblingNext = null;
        this.parent = null;
        this.onChanged();
    }

    public boolean rename(String name) {
        Preconditions.checkArgument((name.length() <= 32 ? 1 : 0) != 0);
        name = name.replace("#", "");
        if (this.parent != null) {
            if (this.parent.subcategories.containsKey(name)) {
                return false;
            }
            EditorPalette removed = this.parent.subcategories.remove(this.name);
            if (removed != this) {
                throw new IllegalStateException();
            }
            this.parent.subcategories.put(name, this);
        }
        this.name = name;
        this.onChanged();
        return true;
    }

    private void onChanged() {
        EditorUI.getBlockList().markNeedsReload();
    }

    public void removeBlock(int index) {
        this.blocks.remove(index);
        this.onChanged();
    }

    public void addBlock(int index, CustomBlockState block) {
        this.blocks.add(index, block);
        this.onChanged();
    }

    public void addBlock(CustomBlockState block) {
        this.blocks.add(block);
        this.onChanged();
    }

    public void addTombstone(String key) {
        this.blocks.add(new EditorPaletteTombstone(key));
    }

    public List<CustomBlockStateOrTombstone> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public int getSubcategoryCount() {
        return this.subcategories.size();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public List<EditorPalette> getSubcategories() {
        if (this.childHead == null) {
            return List.of();
        }
        ArrayList<EditorPalette> list = new ArrayList<EditorPalette>(this.subcategories.size());
        EditorPalette node = this.childHead;
        while (node != null) {
            list.add(node);
            node = node.siblingNext;
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    @FunctionalInterface
    public static interface EditorPaletteConsumer {
        public void accept(String var1, List<CustomBlockStateOrTombstone> var2);
    }

    public static class TypeAdapter
    implements JsonSerializer<EditorPalette>,
    JsonDeserializer<EditorPalette> {
        public EditorPalette deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject editorPaletteJson = json.getAsJsonObject();
            Map subcategories = (Map)context.deserialize(editorPaletteJson.get("subcategories"), TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, EditorPalette.class}).getType());
            EditorPalette palette = new EditorPalette("");
            for (Map.Entry entry : subcategories.entrySet()) {
                ((EditorPalette)entry.getValue()).name = (String)entry.getKey();
                palette.addSubcategory((EditorPalette)entry.getValue());
            }
            List blocksString = (List)context.deserialize(editorPaletteJson.get("blocks"), TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
            for (String key : blocksString) {
                CustomBlockState customBlockState = ServerCustomBlocks.deserialize(key);
                if (customBlockState != null) {
                    palette.addBlock(customBlockState);
                    continue;
                }
                palette.addTombstone(key);
            }
            return palette;
        }

        public JsonElement serialize(EditorPalette src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject editorPaletteJson = new JsonObject();
            ArrayList<String> blocksString = new ArrayList<String>();
            for (CustomBlockStateOrTombstone block : src.blocks) {
                if (block instanceof CustomBlockState) {
                    CustomBlockState customBlockState = (CustomBlockState)block;
                    blocksString.add(ServerCustomBlocks.serialize(customBlockState));
                    continue;
                }
                if (block instanceof EditorPaletteTombstone) {
                    EditorPaletteTombstone tombstone = (EditorPaletteTombstone)block;
                    blocksString.add(tombstone.key());
                    continue;
                }
                throw new FaultyImplementationError();
            }
            editorPaletteJson.add("blocks", context.serialize(blocksString));
            editorPaletteJson.add("subcategories", context.serialize(src.subcategories));
            return editorPaletteJson;
        }
    }
}

