/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.google.common.math.DoubleMath;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.scaling.RotSprite;
import com.moulberry.axiom.scaling.Scale2x;
import com.moulberry.axiom.scaling.Scale3x;
import com.moulberry.axiom.utils.BlockHelper;
import imgui.ImGui;
import java.math.RoundingMode;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class RotatePlacementWindow {
    private static final int[] algorithm = new int[]{1};
    private static final float[] rotationAmountX = new float[]{0.0f};
    private static final float[] rotationAmountY = new float[]{0.0f};
    private static final float[] rotationAmountZ = new float[]{0.0f};
    private static final float[] scaleAmountX = new float[]{1.0f};
    private static final float[] scaleAmountY = new float[]{1.0f};
    private static final float[] scaleAmountZ = new float[]{1.0f};

    public static void reset() {
        RotatePlacementWindow.rotationAmountX[0] = 0.0f;
        RotatePlacementWindow.rotationAmountY[0] = 0.0f;
        RotatePlacementWindow.rotationAmountZ[0] = 0.0f;
        RotatePlacementWindow.scaleAmountX[0] = 1.0f;
        RotatePlacementWindow.scaleAmountY[0] = 1.0f;
        RotatePlacementWindow.scaleAmountZ[0] = 1.0f;
    }

    public static void render() {
        if (!EditorWindowType.ROTATE_PLACEMENT.isOpen()) {
            return;
        }
        if (EditorWindowType.ROTATE_PLACEMENT.begin("###RotatePlacement", true)) {
            boolean disabled;
            boolean canScale;
            ImGuiHelper.combo(AxiomI18n.get("axiom.window.rotate_placement.algorithm"), algorithm, new String[]{AxiomI18n.get("axiom.window.rotate_placement.nearest_neighbor"), AxiomI18n.get("axiom.window.rotate_placement.rotsprite"), AxiomI18n.get("axiom.window.rotate_placement.scale2x"), AxiomI18n.get("axiom.window.rotate_placement.scale3x")});
            int algorithm = RotatePlacementWindow.algorithm[0];
            float rotationDegreesX = 0.0f;
            float rotationDegreesY = 0.0f;
            float rotationDegreesZ = 0.0f;
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            float scaleZ = 1.0f;
            if (algorithm == 0 || algorithm == 1) {
                String rotation = AxiomI18n.get("axiom.window.rotate_placement.rotation");
                String scale = AxiomI18n.get("axiom.window.rotate_placement.scale");
                ImGui.sliderAngle(rotation + " X", rotationAmountX, -179.0f, 180.0f, "%.1f");
                ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                ImGui.sliderAngle(rotation + " Y", rotationAmountY, -179.0f, 180.0f, "%.1f");
                ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                ImGui.sliderAngle(rotation + " Z", rotationAmountZ, -179.0f, 180.0f, "%.1f");
                ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                rotationDegreesX = (float)class_3532.method_15338((double)Math.toDegrees(rotationAmountX[0]));
                rotationDegreesY = (float)class_3532.method_15338((double)Math.toDegrees(rotationAmountY[0]));
                rotationDegreesZ = (float)class_3532.method_15338((double)Math.toDegrees(rotationAmountZ[0]));
                if (algorithm == 0) {
                    ImGui.sliderFloat(scale + " X", scaleAmountX, 0.1f, 10.0f, "%.2f", 32);
                    ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                    ImGui.sliderFloat(scale + " Y", scaleAmountY, 0.1f, 10.0f, "%.2f", 32);
                    ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                    ImGui.sliderFloat(scale + " Z", scaleAmountZ, 0.1f, 10.0f, "%.2f", 32);
                    ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
                    scaleX = (float)Math.round(scaleAmountX[0] * 100.0f) / 100.0f;
                    scaleY = (float)Math.round(scaleAmountY[0] * 100.0f) / 100.0f;
                    scaleZ = (float)Math.round(scaleAmountZ[0] * 100.0f) / 100.0f;
                }
            } else if (algorithm == 2) {
                scaleZ = 2.0f;
                scaleY = 2.0f;
                scaleX = 2.0f;
            } else if (algorithm == 3) {
                scaleZ = 3.0f;
                scaleY = 3.0f;
                scaleX = 3.0f;
            } else if (algorithm == 4) {
                scaleZ = 4.0f;
                scaleY = 4.0f;
                scaleX = 4.0f;
            }
            boolean canRotate = rotationDegreesX != 0.0f || rotationDegreesY != 0.0f || rotationDegreesZ != 0.0f;
            boolean bl = canScale = scaleX != 1.0f || scaleY != 1.0f || scaleZ != 1.0f;
            String buttonText = canRotate == canScale ? (algorithm == 0 ? AxiomI18n.get("axiom.window.rotate_placement.do_rotate_and_scale") : (algorithm == 1 ? AxiomI18n.get("axiom.window.rotate_placement.do_rotate") : AxiomI18n.get("axiom.window.rotate_placement.do_scale"))) : (canRotate ? AxiomI18n.get("axiom.window.rotate_placement.do_rotate") : AxiomI18n.get("axiom.window.rotate_placement.do_scale"));
            ChunkedBlockRegion placement = Placement.INSTANCE.getBlockRegion();
            boolean bl2 = disabled = !canRotate && !canScale || placement == null;
            if (disabled) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(buttonText)) {
                if (algorithm == 0) {
                    if (!canScale && rotationDegreesX % 90.0f == 0.0f && rotationDegreesY % 90.0f == 0.0f && rotationDegreesZ % 90.0f == 0.0f) {
                        placement = placement.rotate(class_2350.class_2351.field_11052, -Math.round(rotationDegreesY / 90.0f));
                        placement = placement.rotate(class_2350.class_2351.field_11048, -Math.round(rotationDegreesX / 90.0f));
                        placement = placement.rotate(class_2350.class_2351.field_11051, -Math.round(rotationDegreesZ / 90.0f));
                        Placement.INSTANCE.replacePlacement(placement);
                    } else {
                        Matrix4f matrix4f = new Matrix4f();
                        matrix4f.scale(scaleAmountX[0], scaleAmountY[0], scaleAmountZ[0]);
                        matrix4f.rotateYXZ((float)Math.toRadians(rotationDegreesY), (float)Math.toRadians(rotationDegreesX), (float)Math.toRadians(rotationDegreesZ));
                        int minX = placement.min().method_10263();
                        int minY = placement.min().method_10264();
                        int minZ = placement.min().method_10260();
                        int maxX = placement.max().method_10263();
                        int maxY = placement.max().method_10264();
                        int maxZ = placement.max().method_10260();
                        int newMinX = Integer.MAX_VALUE;
                        int newMinY = Integer.MAX_VALUE;
                        int newMinZ = Integer.MAX_VALUE;
                        int newMaxX = Integer.MIN_VALUE;
                        int newMaxY = Integer.MIN_VALUE;
                        int newMaxZ = Integer.MIN_VALUE;
                        Vector4f vector4f = new Vector4f();
                        int x = minX;
                        while (x <= maxX) {
                            int y = minY;
                            while (y <= maxY) {
                                int z = minZ;
                                while (z <= maxZ) {
                                    vector4f.set((float)x, (float)y, (float)z, 1.0f);
                                    matrix4f.transform(vector4f);
                                    newMinX = Math.min(newMinX, (int)Math.floor(vector4f.x));
                                    newMinY = Math.min(newMinY, (int)Math.floor(vector4f.y));
                                    newMinZ = Math.min(newMinZ, (int)Math.floor(vector4f.z));
                                    newMaxX = Math.max(newMaxX, (int)Math.ceil(vector4f.x));
                                    newMaxY = Math.max(newMaxY, (int)Math.ceil(vector4f.y));
                                    newMaxZ = Math.max(newMaxZ, (int)Math.ceil(vector4f.z));
                                    if (z == maxZ) break;
                                    z = maxZ;
                                }
                                if (y == maxY) break;
                                y = maxY;
                            }
                            if (x == maxX) break;
                            x = maxX;
                        }
                        Matrix4f inverted = matrix4f.invert(new Matrix4f());
                        int rotationCount = Math.round(rotationDegreesY / 90.0f);
                        if ((rotationCount %= 4) < 0) {
                            rotationCount += 4;
                        }
                        class_2470 rotation = switch (rotationCount) {
                            default -> class_2470.field_11467;
                            case 1 -> class_2470.field_11465;
                            case 2 -> class_2470.field_11464;
                            case 3 -> class_2470.field_11463;
                        };
                        ChunkedBlockRegion out = new ChunkedBlockRegion();
                        for (int x2 = newMinX; x2 <= newMaxX; ++x2) {
                            for (int y = newMinY; y <= newMaxY; ++y) {
                                for (int z = newMinZ; z <= newMaxZ; ++z) {
                                    vector4f.set((float)x2, (float)y, (float)z, 1.0f);
                                    inverted.transform(vector4f);
                                    int sampleX = DoubleMath.roundToInt((double)vector4f.x, (RoundingMode)RoundingMode.HALF_DOWN);
                                    int sampleY = DoubleMath.roundToInt((double)vector4f.y, (RoundingMode)RoundingMode.HALF_DOWN);
                                    int sampleZ = DoubleMath.roundToInt((double)vector4f.z, (RoundingMode)RoundingMode.HALF_DOWN);
                                    class_2680 blockState = placement.getBlockStateOrAir(sampleX, sampleY, sampleZ);
                                    if (blockState.method_26215()) continue;
                                    out.addBlock(x2, y, z, BlockHelper.rotate(blockState, rotation));
                                }
                            }
                        }
                        Placement.INSTANCE.replacePlacement(out);
                    }
                } else if (algorithm == 1) {
                    if (rotationDegreesX % 90.0f == 0.0f && rotationDegreesY % 90.0f == 0.0f && rotationDegreesZ % 90.0f == 0.0f) {
                        placement = placement.rotate(class_2350.class_2351.field_11052, -Math.round(rotationDegreesY / 90.0f));
                        placement = placement.rotate(class_2350.class_2351.field_11048, -Math.round(rotationDegreesX / 90.0f));
                        placement = placement.rotate(class_2350.class_2351.field_11051, -Math.round(rotationDegreesZ / 90.0f));
                        Placement.INSTANCE.replacePlacement(placement);
                    } else {
                        ChunkedBlockRegion rotated = RotSprite.rotate(placement, (float)Math.toRadians(rotationDegreesX), (float)Math.toRadians(rotationDegreesY), (float)Math.toRadians(rotationDegreesZ));
                        Placement.INSTANCE.replacePlacement(rotated);
                    }
                } else if (algorithm == 2) {
                    ChunkedBlockRegion scaled = Scale2x.scale2x(placement, true);
                    Placement.INSTANCE.replacePlacement(scaled);
                } else if (algorithm == 3) {
                    ChunkedBlockRegion scaled = Scale3x.scale3x(placement, true);
                    Placement.INSTANCE.replacePlacement(scaled);
                }
            }
            if (rotationDegreesX % 90.0f != 0.0f || rotationDegreesY % 90.0f != 0.0f || rotationDegreesZ % 90.0f != 0.0f) {
                ImGui.sameLine();
                ImGui.text("\u26a0 " + AxiomI18n.get("axiom.window.rotate_placement.lossy_rotation_warning"));
            } else if (scaleX % 1.0f != 0.0f || scaleY % 1.0f != 0.0f || scaleZ % 1.0f != 0.0f) {
                ImGui.sameLine();
                ImGui.text("\u26a0 " + AxiomI18n.get("axiom.window.rotate_placement.lossy_scaling_warning"));
            }
            if (disabled) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.ROTATE_PLACEMENT.end();
    }
}

