/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.styles.BuiltinStyles;
import com.moulberry.axiom.editor.styles.StyleHelper;
import com.moulberry.axiom.editor.styles.StyleManager;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImGuiStyle;
import imgui.ImVec4;
import imgui.type.ImString;
import net.minecraft.class_310;

public class StyleEditorWindow {
    private static final ImVec4 colorBuf = new ImVec4();
    private static final float[] colorBufArr = new float[4];
    private static final ImString demoTextInput = new ImString(64);
    private static boolean demoCheckbox = true;
    private static final int[] demoIntSlider = new int[]{0};
    private static long copiedToClipboardMillis = 0L;
    private static long updateClipboardMillis = 0L;
    private static String lastStyleOnClipboard;

    public static void render() {
        if (!EditorWindowType.STYLE_EDITOR.isOpen()) {
            return;
        }
        ImGui.setNextWindowSizeConstraints(500.0f, 350.0f, 5000.0f, 3000.0f);
        if (EditorWindowType.STYLE_EDITOR.begin("###StyleEditor", true)) {
            StyleHelper.Theme theme;
            long updateDelta;
            StyleHelper.Theme theme2;
            String clipboardText;
            int[] baseStyleIndex = new int[]{StyleManager.getBaseStyleIndex()};
            ImGui.setNextItemWidth(200.0f);
            if (ImGuiHelper.combo(AxiomI18n.get("axiom.editorui.window.style_editor.base_style"), baseStyleIndex, BuiltinStyles.getBaseStyleNames())) {
                StyleManager.switchBaseStyle(baseStyleIndex[0]);
            }
            ImGuiStyle baseStyle = StyleManager.getBaseStyle();
            ImGuiStyle currentStyle = ImGui.getStyle();
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.style_editor.custom_theme"));
            ImGui.setNextItemWidth(200.0f);
            ImGui.inputText(AxiomI18n.get("axiom.editorui.window.style_editor.theme_name"), StyleManager.getCustomThemeName());
            long currentTime = System.currentTimeMillis();
            long copyDelta = currentTime - copiedToClipboardMillis;
            String string = clipboardText = copyDelta >= 0L && copyDelta < 3000L ? AxiomI18n.get("axiom.editorui.window.style_editor.copied") : AxiomI18n.get("axiom.editorui.window.style_editor.export_to_clipboard");
            if (ImGui.button(clipboardText + "##ClipboardExport", 200.0f, 0.0f) && (theme2 = StyleManager.createTheme()) != null) {
                String base64 = theme2.convertToBase64();
                class_310.method_1551().field_1774.method_1455(base64);
                copiedToClipboardMillis = currentTime;
            }
            if ((updateDelta = currentTime - updateClipboardMillis) < 0L || updateDelta > 200L) {
                updateClipboardMillis = currentTime;
                String clipboard = class_310.method_1551().field_1774.method_1460();
                lastStyleOnClipboard = clipboard.startsWith("AS") ? clipboard : null;
            }
            if (lastStyleOnClipboard == null) {
                ImGui.beginDisabled();
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.style_editor.import_from_clipboard"), 200.0f, 0.0f) && (theme = StyleHelper.Theme.convertFromBase64(lastStyleOnClipboard.trim())) != null) {
                StyleManager.loadTheme(theme);
            }
            if (lastStyleOnClipboard == null) {
                ImGui.endDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.style_editor.reset"))) {
                StyleManager.reset();
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.editorui.window.style_editor.theme_parameters"));
            boolean showSizesOptions = false;
            boolean showColorOptions = false;
            if (ImGui.beginTabBar("###StyleOptions")) {
                if (ImGui.beginTabItem(AxiomI18n.get("axiom.editorui.window.style_editor.sizes") + "###SizesOptions")) {
                    showSizesOptions = true;
                    ImGui.endTabItem();
                }
                if (ImGui.beginTabItem(AxiomI18n.get("axiom.editorui.window.style_editor.color") + "###ColorOptions")) {
                    showColorOptions = true;
                    ImGui.endTabItem();
                }
                ImGui.endTabBar();
            }
            if (ImGui.beginTable("##ColorAndPreviewTable", 2, 513)) {
                ImGui.tableNextColumn();
                if (showSizesOptions) {
                    if (ImGui.beginChild("##SizesChild", 0.0f, -2.0f)) {
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.borders_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.window_borders"), currentStyle, baseStyle, 0, 1, ImGuiStyle::getWindowBorderSize, ImGuiStyle::setWindowBorderSize);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.child_borders"), currentStyle, baseStyle, 0, 1, ImGuiStyle::getChildBorderSize, ImGuiStyle::setChildBorderSize);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.popup_borders"), currentStyle, baseStyle, 0, 1, ImGuiStyle::getPopupBorderSize, ImGuiStyle::setPopupBorderSize);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.frame_borders"), currentStyle, baseStyle, 0, 1, ImGuiStyle::getFrameBorderSize, ImGuiStyle::setFrameBorderSize);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.tab_borders"), currentStyle, baseStyle, 0, 1, ImGuiStyle::getTabBorderSize, ImGuiStyle::setTabBorderSize);
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.rounding_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.window_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getWindowRounding, ImGuiStyle::setWindowRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.child_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getChildRounding, ImGuiStyle::setChildRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.popup_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getPopupRounding, ImGuiStyle::setPopupRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.frame_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getFrameRounding, ImGuiStyle::setFrameRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.tab_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getTabRounding, ImGuiStyle::setTabRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getScrollbarRounding, ImGuiStyle::setScrollbarRounding);
                            StyleEditorWindow.renderVarChanger1(AxiomI18n.get("axiom.editorui.window.style_editor.slider_grab_rounding"), currentStyle, baseStyle, 0, 12, ImGuiStyle::getGrabRounding, ImGuiStyle::setGrabRounding);
                            ImGui.unindent();
                        }
                    }
                    ImGui.endChild();
                } else if (showColorOptions) {
                    if (ImGui.beginChild("##ColorChild", 0.0f, -2.0f)) {
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.text_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 0, AxiomI18n.get("axiom.editorui.window.style_editor.text"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 1, AxiomI18n.get("axiom.editorui.window.style_editor.disabled_text"));
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.window_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 2, AxiomI18n.get("axiom.editorui.window.style_editor.window_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 4, AxiomI18n.get("axiom.editorui.window.style_editor.popup_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 5, AxiomI18n.get("axiom.editorui.window.style_editor.border_color"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 10, AxiomI18n.get("axiom.editorui.window.style_editor.title_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 11, AxiomI18n.get("axiom.editorui.window.style_editor.title_background_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 12, AxiomI18n.get("axiom.editorui.window.style_editor.title_background_collapsed"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 30, AxiomI18n.get("axiom.editorui.window.style_editor.resize_grip"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 31, AxiomI18n.get("axiom.editorui.window.style_editor.resize_grip_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 32, AxiomI18n.get("axiom.editorui.window.style_editor.resize_grip_active"));
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.frame_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 7, AxiomI18n.get("axiom.editorui.window.style_editor.frame_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 8, AxiomI18n.get("axiom.editorui.window.style_editor.frame_background_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 9, AxiomI18n.get("axiom.editorui.window.style_editor.frame_background_active"));
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.widget_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 18, AxiomI18n.get("axiom.editorui.window.style_editor.checkmark"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 21, AxiomI18n.get("axiom.editorui.window.style_editor.button"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 22, AxiomI18n.get("axiom.editorui.window.style_editor.button_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 23, AxiomI18n.get("axiom.editorui.window.style_editor.button_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 19, AxiomI18n.get("axiom.editorui.window.style_editor.slider_grab"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 20, AxiomI18n.get("axiom.editorui.window.style_editor.slider_grab_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 24, AxiomI18n.get("axiom.editorui.window.style_editor.header"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 25, AxiomI18n.get("axiom.editorui.window.style_editor.header_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 26, AxiomI18n.get("axiom.editorui.window.style_editor.header_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 27, AxiomI18n.get("axiom.editorui.window.style_editor.separator"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 28, AxiomI18n.get("axiom.editorui.window.style_editor.separator_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 29, AxiomI18n.get("axiom.editorui.window.style_editor.separator_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 33, AxiomI18n.get("axiom.editorui.window.style_editor.tab"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 34, AxiomI18n.get("axiom.editorui.window.style_editor.tab_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 35, AxiomI18n.get("axiom.editorui.window.style_editor.tab_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 36, AxiomI18n.get("axiom.editorui.window.style_editor.unfocused_tab"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 37, AxiomI18n.get("axiom.editorui.window.style_editor.unfocused_tab_active"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 46, AxiomI18n.get("axiom.editorui.window.style_editor.table_border_light"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 45, AxiomI18n.get("axiom.editorui.window.style_editor.table_border_strong"));
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 14, AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 15, AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_grab"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 16, AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_grab_hovered"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 17, AxiomI18n.get("axiom.editorui.window.style_editor.scrollbar_grab_active"));
                            ImGui.unindent();
                        }
                        if (ImGui.collapsingHeader(AxiomI18n.get("axiom.editorui.window.style_editor.other_category"))) {
                            ImGui.indent();
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 13, AxiomI18n.get("axiom.editorui.window.style_editor.menu_bar_background"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 50, AxiomI18n.get("axiom.editorui.window.style_editor.drag_drop_target"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 38, AxiomI18n.get("axiom.editorui.window.style_editor.docking_preview"));
                            StyleEditorWindow.renderColorChanger(currentStyle, baseStyle, 39, AxiomI18n.get("axiom.editorui.window.style_editor.docking_empty_background"));
                            ImGui.unindent();
                        }
                    }
                    ImGui.endChild();
                }
                ImGui.tableNextColumn();
                ImGui.text("Text");
                ImGui.textDisabled("Disabled Text");
                ImGui.inputText("Text Input", demoTextInput);
                if (ImGui.button("Button")) {
                    ImGui.openPopup("##DemoPopup");
                }
                if (ImGui.checkbox("Checkbox", demoCheckbox)) {
                    boolean bl = demoCheckbox = !demoCheckbox;
                }
                if (ImGui.beginPopup("##DemoPopup")) {
                    ImGui.text("Demo Popup!");
                    ImGui.endPopup();
                }
                ImGui.sliderInt("Slider", demoIntSlider, 0, 100);
                if (ImGui.collapsingHeader("Collapsing Header")) {
                    ImGui.indent();
                    ImGui.text("Hello There!");
                    ImGui.unindent();
                }
                ImGuiHelper.separatorWithText("Separator");
                if (ImGui.beginTabBar("##DemoTabBar")) {
                    if (ImGui.beginTabItem("Tab1")) {
                        ImGui.text("Contents1");
                        ImGui.endTabItem();
                    }
                    if (ImGui.beginTabItem("Tab2")) {
                        ImGui.text("Contents2");
                        ImGui.endTabItem();
                    }
                    if (ImGui.beginTabItem("Tab3")) {
                        ImGui.text("Contents3");
                        ImGui.endTabItem();
                    }
                    ImGui.endTabBar();
                }
                if (ImGui.beginChild("##ScrollChild", 0.0f, 50.0f, true, 2048)) {
                    ImGui.text("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
                }
                ImGui.endChild();
                if (ImGui.beginTable("##DemoTable", 2, 1920)) {
                    ImGui.tableNextColumn();
                    ImGui.text("Table 0,0");
                    ImGui.tableNextColumn();
                    ImGui.text("Table 1,0");
                    ImGui.tableNextColumn();
                    ImGui.text("Table 0,1");
                    ImGui.tableNextColumn();
                    ImGui.text("Table 1,1");
                    ImGui.endTable();
                }
                ImGui.endTable();
            }
        }
        EditorWindowType.STYLE_EDITOR.end();
    }

    private static void renderColorChanger(ImGuiStyle currentStyle, ImGuiStyle baseStyle, int colId, String name) {
        currentStyle.getColor(colId, colorBuf);
        StyleEditorWindow.colorBufArr[0] = StyleEditorWindow.colorBuf.x;
        StyleEditorWindow.colorBufArr[1] = StyleEditorWindow.colorBuf.y;
        StyleEditorWindow.colorBufArr[2] = StyleEditorWindow.colorBuf.z;
        StyleEditorWindow.colorBufArr[3] = StyleEditorWindow.colorBuf.w;
        ImGui.pushID(colId);
        int flags = 327712;
        if (ImGui.colorEdit4(name, colorBufArr, 327712)) {
            currentStyle.setColor(colId, colorBufArr[0], colorBufArr[1], colorBufArr[2], colorBufArr[3]);
        }
        baseStyle.getColor(colId, colorBuf);
        if (colorBufArr[0] != StyleEditorWindow.colorBuf.x || colorBufArr[1] != StyleEditorWindow.colorBuf.y || colorBufArr[2] != StyleEditorWindow.colorBuf.z || colorBufArr[3] != StyleEditorWindow.colorBuf.w) {
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.style_editor.revert"))) {
                currentStyle.setColor(colId, StyleEditorWindow.colorBuf.x, StyleEditorWindow.colorBuf.y, StyleEditorWindow.colorBuf.z, StyleEditorWindow.colorBuf.w);
            }
        }
        ImGui.popID();
    }

    private static void renderVarChanger1(String name, ImGuiStyle currentStyle, ImGuiStyle baseStyle, int min2, int max2, StyleHelper.VarGetter1 getter, StyleHelper.VarSetter1 setter) {
        float baseValue;
        float value = getter.get(currentStyle);
        if (min2 == 0 && max2 == 1) {
            if (ImGui.checkbox(name, (double)value > 0.5)) {
                setter.set(currentStyle, (double)value < 0.5 ? 1.0f : 0.0f);
            }
        } else {
            StyleEditorWindow.colorBufArr[0] = value;
            ImGui.setNextItemWidth(150.0f);
            if (ImGui.sliderFloat(name, colorBufArr, min2, max2, "%.0f")) {
                setter.set(currentStyle, colorBufArr[0]);
            }
        }
        if ((baseValue = getter.get(baseStyle)) != value) {
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.style_editor.revert") + "##Revert" + name)) {
                setter.set(currentStyle, baseValue);
            }
        }
    }
}

