/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.AutoshadeOperation;
import com.moulberry.axiom.operations.AutoshadeShading;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.NbtHelper;
import imgui.ImGui;
import imgui.type.ImFloat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class AutoshadeWindow {
    private static boolean sunShade = true;
    private static final int[] sunShadePositionType = new int[]{0};
    private static final List<ImFloat> customSunPositions = new ArrayList<ImFloat>();
    private static final float[] sunYawRadians = new float[]{0.7853982f};
    private static final float[] sunPitchRadians = new float[]{0.7853982f};
    private static boolean ambientShade = true;
    private static final float[] globalIllumination = new float[]{0.5f};
    private static final float[] dither = new float[]{0.1f};
    private static int paletteFlags = BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE | BlockColourMap.FLAG_NO_TILE_ENTITIES;
    private static final int[] paletteMode = new int[]{0};
    private static final List<BlockWithFloat> blockPercentages = new ArrayList<BlockWithFloat>();
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private static final PresetWidget presetWidget = new PresetWidget(AutoshadeWindow::loadSettings, AutoshadeWindow::writeSettings, "autoshade");

    public static void render() {
        if (!EditorWindowType.AUTOSHADE.isOpen()) {
            return;
        }
        if (EditorWindowType.AUTOSHADE.begin("###Autoshade", true)) {
            boolean disable;
            boolean changed = false;
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.sun_shading"));
            if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.sun"), sunShade)) {
                sunShade = !sunShade;
                changed = true;
            }
            if (sunShade) {
                changed |= ImGuiHelper.combo("From", sunShadePositionType, new String[]{"Player Position", "Custom Positions", "Sun Angle"});
                if (sunShadePositionType[0] == 1) {
                    class_1297 camera;
                    if (customSunPositions.isEmpty() && (camera = class_310.method_1551().method_1560()) != null) {
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23317() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23318() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23321() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat(1.0f));
                    }
                    if (ImGui.beginTable("##CustomSunPositionsTable", 5, 32768)) {
                        ImGui.tableNextColumn();
                        ImGui.text("X");
                        ImGui.tableNextColumn();
                        ImGui.text("Y");
                        ImGui.tableNextColumn();
                        ImGui.text("Z");
                        ImGui.tableNextColumn();
                        ImGui.text("Intensity");
                        ImGui.tableNextColumn();
                        int removeIndex = -1;
                        for (int i = 0; i < customSunPositions.size(); i += 4) {
                            ImGui.tableNextColumn();
                            ImGui.setNextItemWidth(-1.0f);
                            ImGui.inputFloat("##CustomPosition" + i, customSunPositions.get(i), 0.0f, 0.0f, "%.2f", 0);
                            ImGui.tableNextColumn();
                            ImGui.setNextItemWidth(-1.0f);
                            ImGui.inputFloat("##CustomPosition" + (i + 1), customSunPositions.get(i + 1), 0.0f, 0.0f, "%.2f", 0);
                            ImGui.tableNextColumn();
                            ImGui.setNextItemWidth(-1.0f);
                            ImGui.inputFloat("##CustomPosition" + (i + 2), customSunPositions.get(i + 2), 0.0f, 0.0f, "%.2f", 0);
                            ImGui.tableNextColumn();
                            ImGui.setNextItemWidth(-1.0f);
                            ImGui.inputFloat("##CustomPosition" + (i + 3), customSunPositions.get(i + 3), 0.0f, 0.0f, "%.2f", 0);
                            ImGui.tableNextColumn();
                            if (!ImGui.button("X##Remove" + i)) continue;
                            removeIndex = i;
                        }
                        if (removeIndex >= 0) {
                            customSunPositions.remove(removeIndex);
                            customSunPositions.remove(removeIndex);
                            customSunPositions.remove(removeIndex);
                            customSunPositions.remove(removeIndex);
                        }
                        ImGui.endTable();
                    }
                    if (ImGui.button("Add Position") && (camera = class_310.method_1551().method_1560()) != null) {
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23317() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23318() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat((float)Math.round(camera.method_23321() * 10.0) / 10.0f));
                        customSunPositions.add(new ImFloat(1.0f));
                    }
                } else if (sunShadePositionType[0] == 2) {
                    changed |= ImGui.sliderAngle(AxiomI18n.get("axiom.window.autoshade.sun_yaw"), sunYawRadians);
                    changed |= ImGui.sliderAngle(AxiomI18n.get("axiom.window.autoshade.sun_pitch"), sunPitchRadians);
                }
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.ambient_occlusion_shading"));
            if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.ambient_occlusion"), ambientShade)) {
                ambientShade = !ambientShade;
                changed = true;
            }
            if (paletteMode[0] == 0) {
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.global_illumination"));
                changed |= ImGui.sliderFloat("##GlobalIllumination", globalIllumination, 0.0f, 1.0f);
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.dither"));
            changed |= ImGui.sliderFloat("##Dither", dither, 0.0f, 1.0f);
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.window.autoshade.palette_options"));
            ImGuiHelper.combo(AxiomI18n.get("axiom.window.autoshade.palette_type"), paletteMode, new String[]{AxiomI18n.get("axiom.window.autoshade.palette_type.automatic"), AxiomI18n.get("axiom.window.autoshade.palette_type.custom")});
            if (paletteMode[0] == 0) {
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_solid"), (paletteFlags & BlockColourMap.FLAG_SOLID) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_SOLID;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_opaque"), (paletteFlags & BlockColourMap.FLAG_OPAQUE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_OPAQUE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_full_cube"), (paletteFlags & BlockColourMap.FLAG_FULL_CUBE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_FULL_CUBE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_same_texture"), (paletteFlags & BlockColourMap.FLAG_SAME_TEXTURE) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_SAME_TEXTURE;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_ores"), (paletteFlags & BlockColourMap.FLAG_NO_ORES) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_ORES;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_glazed_terracotta"), (paletteFlags & BlockColourMap.FLAG_NO_GLAZED_TERRACOTTA) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_GLAZED_TERRACOTTA;
                    changed = true;
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.window.autoshade.palette_no_tile_entities"), (paletteFlags & BlockColourMap.FLAG_NO_TILE_ENTITIES) != 0)) {
                    paletteFlags ^= BlockColourMap.FLAG_NO_TILE_ENTITIES;
                    changed = true;
                }
            } else {
                changed |= BlockWithFloat.renderList(blockPercentages, selectBlockWidget, BlockWithFloat.ExtraRenderType.PERCENTAGE, 1, true);
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
            presetWidget.displayImgui(changed);
            ImGui.separator();
            boolean bl = disable = Selection.getSelectionBuffer().isEmpty() || !sunShade && !ambientShade;
            if (disable) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.autoshade.do_autoshade"))) {
                ArrayList<class_243> vectors = new ArrayList<class_243>();
                ArrayList<AutoshadeShading.PositionWithIntensity> positions = new ArrayList<AutoshadeShading.PositionWithIntensity>();
                if (sunShadePositionType[0] == 0) {
                    class_1297 camera = class_310.method_1551().method_1560();
                    if (camera != null) {
                        positions.add(new AutoshadeShading.PositionWithIntensity((float)camera.method_23317(), (float)camera.method_23318(), (float)camera.method_23321(), 1.0f));
                    }
                } else if (sunShadePositionType[0] == 1) {
                    for (int i = 0; i < customSunPositions.size(); i += 4) {
                        positions.add(new AutoshadeShading.PositionWithIntensity(customSunPositions.get(i).get(), customSunPositions.get(i + 1).get(), customSunPositions.get(i + 2).get(), customSunPositions.get(i + 3).get()));
                    }
                } else if (sunShadePositionType[0] == 2) {
                    float yawRadians = -sunYawRadians[0];
                    float pitchRadians = -sunPitchRadians[0];
                    float cosYaw = class_3532.method_15362((float)yawRadians);
                    float sinYaw = class_3532.method_15374((float)yawRadians);
                    float cosPitch = class_3532.method_15362((float)pitchRadians);
                    float sinPitch = class_3532.method_15374((float)pitchRadians);
                    vectors.add(new class_243((double)(sinYaw * cosPitch), (double)(-sinPitch), (double)(cosYaw * cosPitch)));
                }
                if (!vectors.isEmpty() || !positions.isEmpty()) {
                    List<BlockWithFloat> customPalette = paletteMode[0] == 0 ? null : blockPercentages;
                    float globalIlluminationFloat = paletteMode[0] == 0 ? globalIllumination[0] : 0.0f;
                    AutoshadeShading shading = new AutoshadeShading(vectors, positions);
                    AutoshadeOperation.autoshade(sunShade, ambientShade, shading, globalIlluminationFloat, dither[0], customPalette, paletteFlags);
                }
            }
            if (disable) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.AUTOSHADE.end();
    }

    public static void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (!EditorWindowType.AUTOSHADE.isOpen() || !EditorUI.isActive() || customSunPositions.isEmpty()) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27379, class_290.field_1576);
        for (int i = 0; i < customSunPositions.size(); i += 4) {
            float x = customSunPositions.get(i).get();
            float y = customSunPositions.get(i + 1).get();
            float z = customSunPositions.get(i + 2).get();
            matrices.method_22903();
            matrices.method_22904((double)x - 0.1, (double)y - 0.1, (double)z - 0.1);
            Shapes.shadedBoxTriangles(bufferBuilder, matrices.method_23760().method_23761(), 0.2f, 0.2f, 0.2f, -2130706688);
            matrices.method_22904(-0.1, -0.1, -0.1);
            Shapes.shadedBoxTriangles(bufferBuilder, matrices.method_23760().method_23761(), 0.4f, 0.4f, 0.4f, -2130706688);
            matrices.method_22904(-0.1, -0.1, -0.1);
            Shapes.shadedBoxTriangles(bufferBuilder, matrices.method_23760().method_23761(), 0.6f, 0.6f, 0.6f, 0x40FFFF00);
            matrices.method_22909();
        }
        AxiomRenderPipelines.POSITION_COLOR.render(class_310.method_1551().method_1522(), provider.build());
        matrices.method_22909();
    }

    private static void loadSettings(class_2487 tag) {
        sunShade = tag.method_68566("DoSunShading", true);
        AutoshadeWindow.sunYawRadians[0] = tag.method_66563("SunYawRadians", 0.7853982f);
        AutoshadeWindow.sunPitchRadians[0] = tag.method_66563("SunPitchRadians", 0.7853982f);
        ambientShade = tag.method_68566("DoAmbientShading", true);
        AutoshadeWindow.globalIllumination[0] = tag.method_66563("GlobalIllumination", 0.5f);
        AutoshadeWindow.dither[0] = tag.method_66563("Dither", 0.5f);
        paletteFlags = tag.method_68083("PaletteFlags", BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE | BlockColourMap.FLAG_NO_TILE_ENTITIES);
        AutoshadeWindow.paletteMode[0] = tag.method_68083("PaletteMode", 0);
        blockPercentages.clear();
        class_2499 blockPercentagesList = NbtHelper.getList(tag, "BlockPercentages", 10);
        for (class_2520 blockPercentageTag : blockPercentagesList) {
            class_2487 blockPercentage = (class_2487)blockPercentageTag;
            String block = (String)blockPercentage.method_10558("Block").get();
            float percentage = ((Float)blockPercentage.method_10583("Percentage").get()).floatValue();
            blockPercentages.add(new BlockWithFloat(Objects.requireNonNullElse(ServerCustomBlocks.deserialize(block), (CustomBlockState)class_2246.field_10340.method_9564()), new float[]{percentage}, null));
        }
        if (blockPercentages.isEmpty()) {
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_37576.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_28888.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_27165.method_9564());
            BlockWithFloat.addNew(blockPercentages, (CustomBlockState)class_2246.field_10115.method_9564());
        }
    }

    private static void writeSettings(class_2487 tag) {
        tag.method_10556("DoSunShading", sunShade);
        tag.method_10548("SunYawRadians", sunYawRadians[0]);
        tag.method_10548("SunPitchRadians", sunPitchRadians[0]);
        tag.method_10556("DoAmbientShading", ambientShade);
        tag.method_10548("GlobalIllumination", globalIllumination[0]);
        tag.method_10548("Dither", dither[0]);
        tag.method_10569("PaletteFlags", paletteFlags);
        tag.method_10569("PaletteMode", paletteMode[0]);
        class_2499 blockPercentagesList = new class_2499();
        for (BlockWithFloat blockWithFloat : blockPercentages) {
            class_2487 blockWithFloatTag = new class_2487();
            blockWithFloatTag.method_10582("Block", ServerCustomBlocks.serialize(blockWithFloat.blockState()));
            blockWithFloatTag.method_10548("Percentage", blockWithFloat.percentage()[0]);
            blockPercentagesList.add((Object)blockWithFloatTag);
        }
        tag.method_10566("BlockPercentages", (class_2520)blockPercentagesList);
    }

    static {
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_37576.method_9564(), new float[]{25.0f}, null));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_28888.method_9564(), new float[]{25.0f}, null));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_27165.method_9564(), new float[]{25.0f}, null));
        blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10115.method_9564(), new float[]{25.0f}, null));
    }
}

