/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class SpiralRasterization {
    public static void archimedean(Vector3i center, float diameterX, float diameterZ, boolean centerEvenDiameters, float loops, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        double radiusX = (double)(diameterX - 1.0f) / 2.0;
        double radiusZ = (double)(diameterZ - 1.0f) / 2.0;
        double offsetX = (centerEvenDiameters ? radiusX % 1.0 : 0.0) + 0.5;
        double offsetZ = (centerEvenDiameters ? radiusZ % 1.0 : 0.0) + 0.5;
        Vector3d from = new Vector3d(offsetX, 0.5, offsetZ);
        quaternionf.transformInverse(from);
        Vector3d to = new Vector3d();
        int a = 0;
        while ((float)a <= 360.0f * loops) {
            double amount = (float)a / (360.0f * loops);
            double currX = Math.sin(Math.toRadians(a)) * amount * (radiusX - 0.15) + offsetX;
            double currZ = Math.cos(Math.toRadians(a)) * amount * (radiusZ - 0.15) + offsetZ;
            to.set(currX, 0.5, currZ);
            quaternionf.transformInverse(to);
            Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
            Vector3d temp = from;
            from = to;
            to = temp;
            ++a;
        }
    }
}

