/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.collections.SimpleBlockWeightTracker;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class GaussianBlurTable {
    private final float[] table;

    public GaussianBlurTable(float stddev, float threshold) {
        if (stddev <= 0.0f) {
            this.table = new float[]{1.0f};
        } else {
            stddev = Math.min(10.0f, stddev);
            threshold = Math.max(0.0f, Math.min(1.0f, threshold));
            float onePercentX = (float)Math.sqrt((double)(-(2.0f * stddev * stddev)) * Math.log((double)threshold * ((double)stddev * Math.sqrt(Math.PI * 2))));
            int radius = (int)Math.floor(onePercentX);
            if ((radius = Math.min(16, radius)) <= 0) {
                this.table = new float[]{1.0f};
            } else {
                this.table = new float[radius * 2 + 1];
                for (int i = -radius; i <= radius; ++i) {
                    this.table[i + radius] = (float)(Math.exp((float)(-i * i) / (2.0f * stddev * stddev)) / ((double)stddev * Math.sqrt(Math.PI * 2)));
                }
                float sum = 0.0f;
                for (float f : this.table) {
                    sum += f;
                }
                int i = 0;
                while (i < this.table.length) {
                    int n = i++;
                    this.table[n] = this.table[n] / sum;
                }
            }
        }
    }

    public float[] getTable() {
        return this.table;
    }

    public boolean isSingleValued() {
        return this.table.length == 1;
    }

    public void applyBlur(PositionSet input, Position2FloatMap output) {
        if (this.isSingleValued()) {
            input.forEach((x, y, z) -> output.add(x, y, z, 1.0f));
            return;
        }
        int radius = this.table.length / 2;
        if (radius == 0) {
            throw new FaultyImplementationError();
        }
        Position2FloatMap smoothedX = new Position2FloatMap();
        input.forEach((x, y, z) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedX.add(x + i, y, z, this.table[i + radius]);
            }
        });
        Position2FloatMap smoothedZ = new Position2FloatMap();
        smoothedX.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedZ.add(x, y, z + i, v * this.table[i + radius]);
            }
        });
        smoothedZ.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                output.add(x, y + i, z, v * this.table[i + radius]);
            }
        });
    }

    public void applyBlur(Position2FloatMap input, Position2FloatMap output) {
        if (this.isSingleValued()) {
            input.forEachEntry(output::add);
            return;
        }
        int radius = this.table.length / 2;
        if (radius == 0) {
            throw new FaultyImplementationError();
        }
        Position2FloatMap smoothedX = new Position2FloatMap();
        input.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedX.add(x + i, y, z, v * this.table[i + radius]);
            }
        });
        Position2FloatMap smoothedZ = new Position2FloatMap();
        smoothedX.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedZ.add(x, y, z + i, v * this.table[i + radius]);
            }
        });
        smoothedZ.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                output.add(x, y + i, z, v * this.table[i + radius]);
            }
        });
    }

    public void applyBlurCheckThreshold(Position2FloatMap input, Position2FloatMap output, float threshold, TriIntConsumer consumer) {
        if (this.isSingleValued()) {
            input.forEachEntry((x, y, z, v) -> {
                float currentValue = output.get(x, y, z);
                if (currentValue >= threshold) {
                    return;
                }
                float newValue = output.add(x, y, z, v);
                if (newValue >= threshold) {
                    consumer.accept(x, y, z);
                }
            });
            return;
        }
        int radius = this.table.length / 2;
        if (radius == 0) {
            throw new FaultyImplementationError();
        }
        Position2FloatMap smoothedX = new Position2FloatMap();
        input.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedX.add(x + i, y, z, v * this.table[i + radius]);
            }
        });
        Position2FloatMap smoothedZ = new Position2FloatMap();
        smoothedX.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                smoothedZ.add(x, y, z + i, v * this.table[i + radius]);
            }
        });
        smoothedZ.forEachEntry((x, y, z, v) -> {
            for (int i = -radius; i <= radius; ++i) {
                float s2 = v * this.table[i + radius];
                float newValue = output.add(x, y + i, z, s2);
                if (!(newValue >= threshold) || !(newValue - s2 < threshold)) continue;
                consumer.accept(x, y + i, z);
            }
        });
    }

    public void applyBlurCheckThreshold(Position2ObjectMap<SimpleBlockWeightTracker> input, Position2ObjectMap<SimpleBlockWeightTracker> output, float threshold, BlockBlurConsumer consumer) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (this.isSingleValued()) {
            input.forEachEntry((x, y, z, v) -> {
                if (v.block() == null) {
                    return;
                }
                SimpleBlockWeightTracker currentValue = (SimpleBlockWeightTracker)output.getOrCreate(x, y, z);
                float oldWeight = currentValue.totalWeight();
                class_2680 oldBlock = currentValue.block();
                currentValue.add((SimpleBlockWeightTracker)v);
                if (currentValue.totalWeight() >= threshold && (oldWeight < threshold || oldBlock != currentValue.block())) {
                    consumer.accept((class_2338)mutable.method_10103(x, y, z), currentValue.block());
                }
            });
            return;
        }
        int radius = this.table.length / 2;
        if (radius == 0) {
            throw new FaultyImplementationError();
        }
        Position2ObjectMap<SimpleBlockWeightTracker> smoothedX = SimpleBlockWeightTracker.createMap();
        input.forEachEntry((x, y, z, v) -> {
            if (v.block() == null) {
                return;
            }
            for (int i = -radius; i <= radius; ++i) {
                ((SimpleBlockWeightTracker)smoothedX.getOrCreate(x + i, y, z)).add((SimpleBlockWeightTracker)v, this.table[i + radius]);
            }
        });
        Position2ObjectMap<SimpleBlockWeightTracker> smoothedZ = SimpleBlockWeightTracker.createMap();
        smoothedX.forEachEntry((x, y, z, v) -> {
            if (v.block() == null) {
                return;
            }
            for (int i = -radius; i <= radius; ++i) {
                ((SimpleBlockWeightTracker)smoothedZ.getOrCreate(x, y, z + i)).add((SimpleBlockWeightTracker)v, this.table[i + radius]);
            }
        });
        smoothedZ.forEachEntry((x, y, z, v) -> {
            if (v.block() == null) {
                return;
            }
            for (int i = -radius; i <= radius; ++i) {
                SimpleBlockWeightTracker currentValue = (SimpleBlockWeightTracker)output.getOrCreate(x, y + i, z);
                float oldWeight = currentValue.totalWeight();
                class_2680 oldBlock = currentValue.block();
                currentValue.add((SimpleBlockWeightTracker)v, this.table[i + radius]);
                if (!(currentValue.totalWeight() >= threshold) || !(oldWeight < threshold) && oldBlock == currentValue.block()) continue;
                consumer.accept((class_2338)mutable.method_10103(x, y + i, z), currentValue.block());
            }
        });
    }

    public String toString() {
        return "GaussianBlurTable" + Arrays.toString(this.table);
    }

    public static interface BlockBlurConsumer {
        public void accept(class_2338 var1, class_2680 var2);
    }
}

