/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noise_parameters.distance_functions;

import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunction;

public final class MinkowskiDistance
implements DistanceFunction {
    private final long p;

    public MinkowskiDistance(long p) {
        this.p = p;
    }

    @Override
    public double distance(double x0, double x1) {
        return Math.abs(x0 - x1);
    }

    @Override
    public double distance(double x0, double y0, double x1, double y1) {
        return Math.pow(Math.pow(Math.abs(x0 - x1), this.p) + Math.pow(Math.abs(y0 - y1), this.p), 1.0 / (double)this.p);
    }

    @Override
    public double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
        return Math.pow(Math.pow(Math.abs(x0 - x1), this.p) + Math.pow(Math.abs(y0 - y1), this.p) + Math.pow(Math.abs(z0 - z1), this.p), 1.0 / (double)this.p);
    }

    @Override
    public double distance(double x0, double y0, double z0, double w0, double x1, double y1, double z1, double w1) {
        return Math.pow(Math.pow(Math.abs(x0 - x1), this.p) + Math.pow(Math.abs(y0 - y1), this.p) + Math.pow(Math.abs(z0 - z1), this.p) + Math.pow(Math.abs(w0 - w1), this.p), 1.0 / (double)this.p);
    }
}

