/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import com.google.common.primitives.Bytes;
import gg.essential.loader.stage2.EssentialLoader;
import gg.essential.loader.stage2.Utils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeModRemapper {
    private static final Logger LOGGER = LogManager.getLogger(RuntimeModRemapper.class);
    private final EssentialLoader.LoaderInternals loaderInternals;

    public RuntimeModRemapper(EssentialLoader.LoaderInternals loaderInternals) {
        this.loaderInternals = loaderInternals;
    }

    private byte[] gatherRemapInputs(Path modPath) throws IOException {
        URL mappings = FabricLauncherBase.class.getClassLoader().getResource("mappings/mappings.tiny");
        if (mappings == null) {
            throw new RuntimeException("Failed to find tiny mappings file.");
        }
        String remapClasspathFile = System.getProperty("fabric.remapClasspathFile");
        if (remapClasspathFile == null) {
            throw new RuntimeException("Remap classpath file property not set. Using an ancient Loom version?");
        }
        return DigestUtils.sha1((byte[])Bytes.concat((byte[][])new byte[][]{mappings.toString().getBytes(StandardCharsets.UTF_8), Files.readAllBytes(Paths.get(remapClasspathFile, new String[0])), Files.readAllBytes(modPath)}));
    }

    public Path remap(Path path, ModMetadata metadata) throws Exception {
        Path devPath = Utils.mapFileBaseName(path, name -> name + "-dev");
        Path devInputs = devPath.resolveSibling(devPath.getFileName().toString() + ".inputs");
        byte[] currentInputs = this.gatherRemapInputs(path);
        if (!(Files.exists(devPath, new LinkOption[0]) && Files.exists(devInputs, new LinkOption[0]) && Arrays.equals(Files.readAllBytes(devInputs), currentInputs))) {
            Files.deleteIfExists(devPath);
            Files.deleteIfExists(devInputs);
            LOGGER.info("Remapping Essential to development mappings...");
            LOGGER.info("This may take a few seconds but will only happen once (or when mappings/classpath change).");
            this.loaderInternals.remapMod(metadata, path, devPath);
            Files.write(devInputs, currentInputs, StandardOpenOption.CREATE_NEW);
        }
        return devPath;
    }
}

