/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricModJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(VersionRange.class, (Object)new VersionRange.JsonAdapter()).create();
    private final int schemaVersion;
    @NotNull
    private final String id;
    @NotNull
    private final String version;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, VersionRange> depends;
    @Nullable
    private final List<Jar> jars;

    public FabricModJson(int schemaVersion, @NotNull String id, @NotNull String version, @Nullable String name, @Nullable Map<String, VersionRange> depends, @Nullable List<Jar> jars) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.version = version;
        this.name = name;
        this.depends = depends;
        this.jars = jars;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public Map<String, VersionRange> getDepends() {
        return this.depends == null ? Collections.emptyMap() : this.depends;
    }

    public List<Jar> getJars() {
        return this.jars == null ? Collections.emptyList() : this.jars;
    }

    private FabricModJson validate() throws IOException {
        if (this.id == null) {
            throw new IOException("Missing \"id\" in fabric.mod.json.");
        }
        if (this.version == null) {
            throw new IOException("Missing \"version\" in fabric.mod.json.");
        }
        return this;
    }

    public static void write(Path jsonFile, FabricModJson json) throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(jsonFile, StandardOpenOption.CREATE);){
            GSON.toJson((Object)json, (Appendable)out);
        }
    }

    public static FabricModJson read(Path jsonFile) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(jsonFile);){
            FabricModJson fabricModJson = ((FabricModJson)GSON.fromJson((Reader)in, FabricModJson.class)).validate();
            return fabricModJson;
        }
    }

    public static FabricModJson readFromJar(Path jarFile) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(jarFile, (ClassLoader)null);){
            FabricModJson fabricModJson = FabricModJson.read(fileSystem.getPath("fabric.mod.json", new String[0]));
            return fabricModJson;
        }
    }

    public static class VersionRange
    extends ArrayList<String> {
        public VersionRange() {
        }

        public VersionRange(String version) {
            this.add(version);
        }

        private static class JsonAdapter
        extends TypeAdapter<VersionRange> {
            private JsonAdapter() {
            }

            public void write(JsonWriter out, VersionRange values) throws IOException {
                if (values.size() == 1) {
                    out.value((String)values.get(0));
                } else {
                    out.beginArray();
                    for (String value : values) {
                        out.value(value);
                    }
                    out.endArray();
                }
            }

            public VersionRange read(JsonReader in) throws IOException {
                VersionRange values = new VersionRange();
                if (in.peek() != JsonToken.BEGIN_ARRAY) {
                    values.add(in.nextString());
                } else {
                    in.beginArray();
                    while (in.peek() != JsonToken.END_ARRAY) {
                        values.add(in.nextString());
                    }
                    in.endArray();
                }
                return values;
            }
        }
    }

    public static class Jar {
        private final String file;

        public Jar(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

